/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.debug.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.BoxedValue;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CommandStack;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.core.Pipeline;
import org.eclipse.rcptt.ecl.core.Proc;
import org.eclipse.rcptt.ecl.core.ProcInstance;
import org.eclipse.rcptt.ecl.core.Sequence;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.core.With;
import org.eclipse.rcptt.ecl.core.util.CommandToStringConverter;
import org.eclipse.rcptt.ecl.debug.commands.DebugCommand;
import org.eclipse.rcptt.ecl.debug.model.ModelFactory;
import org.eclipse.rcptt.ecl.debug.model.StackFrame;
import org.eclipse.rcptt.ecl.debug.model.Variable;
import org.eclipse.rcptt.ecl.debug.model.VariableKind;
import org.eclipse.rcptt.ecl.debug.runtime.IEclDebugExtension;
import org.eclipse.rcptt.ecl.gen.ast.AstExec;
import org.eclipse.rcptt.ecl.gen.ast.AstNode;
import org.eclipse.rcptt.ecl.internal.core.DeclarationContainer;
import org.eclipse.rcptt.ecl.internal.debug.runtime.DebugExtensionManager;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;

public class EclStackSupport {
    private String id;
    private CommandToStringConverter converter = new CommandToStringConverter();
    private long varId = 0L;

    public EclStackSupport(String id) {
        this.id = id;
    }

    private DebugCommand getRoot(CommandStack stack) {
        do {
            Command command;
            if (!((command = stack.getCommand()) instanceof DebugCommand)) continue;
            return (DebugCommand)command;
        } while ((stack = stack.getParent()) != null);
        return null;
    }

    public List<StackFrame> getFrames(CommandStack stack) {
        if (this.getSource(stack) == null) {
            return null;
        }
        DebugCommand debug = this.getRoot(stack);
        if (debug == null || !this.id.equals(debug.getSession())) {
            return null;
        }
        String path = debug.getPath();
        EMap<String, String> paths = debug.getPaths();
        ArrayList<StackFrame> frames = new ArrayList<StackFrame>();
        Command lastCommand = null;
        List<IEclDebugExtension> extensions = DebugExtensionManager.getInstance().getExtensions();
        int id = 0;
        do {
            Command command;
            if ((command = stack.getCommand()) instanceof AstExec) {
                AstExec exec = (AstExec)command;
                String currentPath = this.getCurrentPath(path, paths, exec);
                StackFrame frame = ModelFactory.eINSTANCE.createStackFrame();
                frame.setFile(currentPath);
                frame.setCommand(exec.getName());
                frame.setLine(exec.getLine());
                frame.setColumn(exec.getColumn());
                frame.setLength(exec.getName().length());
                for (IEclDebugExtension ext : extensions) {
                    ext.prepareFrame(stack, frame, this);
                }
                HashSet<String> variables = new HashSet<String>();
                Variable cmdVar = this.createCommandVariable(lastCommand);
                if (cmdVar != null) {
                    cmdVar.setName(exec.getName());
                    frame.getVariables().add((Object)cmdVar);
                    variables.add(cmdVar.getName());
                }
                Object current = stack;
                boolean withSet = false;
                while (current != null) {
                    DeclarationContainer declarations = current.getDeclarations();
                    if (declarations != null) {
                        for (Declaration d : declarations.declarations()) {
                            Val v;
                            if (!(d instanceof Val) || !variables.add((v = (Val)d).getName())) continue;
                            Variable var = this.createVariable(v.getValue());
                            var.setKind(VariableKind.VARIABLE);
                            var.setName(v.getName());
                            this.processVariable(var, v.getValue());
                            frame.getVariables().add((Object)var);
                        }
                    }
                    if (!withSet && current.getCommand() instanceof With) {
                        EObject val = ((With)current.getCommand()).getObject();
                        if (val != null) {
                            Variable var = this.createVariable(val);
                            var.setKind(VariableKind.REFERENCE);
                            var.setName("with object");
                            this.processVariable(var, val);
                            frame.getVariables().add((Object)var);
                        }
                        withSet = true;
                    }
                    current = current.getCommand() instanceof ProcInstance ? null : current.getParent();
                }
                for (IEclDebugExtension ext : extensions) {
                    ext.updateFrame(stack, frame);
                }
                frame.setId(id);
                ++id;
                frames.add(frame);
                continue;
            }
            lastCommand = command;
        } while ((stack = stack.getParent()) != null);
        return frames;
    }

    public void processVariable(Variable var, Object value) {
        if (value != null) {
            List<IEclDebugExtension> extensions = DebugExtensionManager.getInstance().getExtensions();
            for (IEclDebugExtension ext : extensions) {
                if (!ext.supportVariableValue(value)) continue;
                ext.processVariable(var, value, true);
                return;
            }
            if (value instanceof EObject) {
                var.setType(((EObject)value).eClass().getName());
            } else {
                var.setType(value.getClass().getName());
            }
            if (value instanceof BoxedValue) {
                var.setValue(EcoreUtil.copy((EObject)((BoxedValue)value)));
            } else if (!this.isComplexValue(value)) {
                var.setValue((EObject)BoxedValues.box((String)value.toString()));
            }
        }
    }

    private boolean isComplexValue(Object value) {
        if (value instanceof BoxedValue) {
            return false;
        }
        List<IEclDebugExtension> extensions = DebugExtensionManager.getInstance().getExtensions();
        for (IEclDebugExtension ext : extensions) {
            if (!ext.supportVariableValue(value)) continue;
            return ext.isComplexVariableValue(value);
        }
        return value instanceof EObject || value instanceof List;
    }

    public void processObjectValue(Variable var, Object value) {
        if (!this.isComplexValue(value)) {
            return;
        }
        List<IEclDebugExtension> extensions = DebugExtensionManager.getInstance().getExtensions();
        for (IEclDebugExtension ext : extensions) {
            if (!ext.supportVariableValue(value)) continue;
            ext.processVariable(var, value, false);
            return;
        }
        if (value instanceof EObject) {
            var.getChildren().clear();
            this.processEObject(var, value);
        } else if (value instanceof List) {
            var.getChildren().clear();
            List list = (List)value;
            int index = 0;
            var.setType(List.class.getName());
            for (Object object : list) {
                Variable childVar = this.createVariable(object);
                childVar.setKind(VariableKind.REFERENCE);
                childVar.setName("[" + Integer.toString(index) + "]");
                this.processVariable(childVar, object);
                var.getChildren().add((Object)childVar);
                ++index;
            }
        }
    }

    private void processEObject(Variable var, Object value) {
        EObject obj = (EObject)value;
        for (EStructuralFeature f : obj.eClass().getEAllStructuralFeatures()) {
            Object childValue;
            if (!obj.eIsSet(f) || f == CorePackage.eINSTANCE.getCommand_Host() || f == CorePackage.eINSTANCE.getCommand_Bindings() || this.isChildFiltered(childValue = obj.eGet(f))) continue;
            Variable childVar = this.createVariable(childValue);
            childVar.setKind(VariableKind.FIELD);
            childVar.setType(f.getEType().toString());
            childVar.setName(f.getName());
            this.processVariable(childVar, childValue);
            var.getChildren().add((Object)childVar);
        }
    }

    private boolean isChildFiltered(Object childValue) {
        if (childValue instanceof AstExec || childValue instanceof Pipeline || childValue instanceof Sequence || childValue instanceof Proc) {
            return true;
        }
        List<IEclDebugExtension> extensions = DebugExtensionManager.getInstance().getExtensions();
        for (IEclDebugExtension ext : extensions) {
            if (!ext.isVariableChildFiltered(childValue)) continue;
            return true;
        }
        return false;
    }

    private String getCurrentPath(String path, EMap<String, String> paths, AstExec exec) {
        String currentPath = path;
        if (exec.getResourceID() != null && paths.containsKey((Object)exec.getResourceID())) {
            currentPath = (String)paths.get((Object)exec.getResourceID());
        }
        return currentPath;
    }

    private Variable createCommandVariable(Command command) {
        Variable result = null;
        if (command == null) {
            return result;
        }
        Variable cmd = this.createVariable(command);
        cmd.setKind(VariableKind.COMMAND);
        cmd.setName(this.converter.convert(command));
        for (EStructuralFeature f : command.eClass().getEAllStructuralFeatures()) {
            Object value;
            if (!command.eIsSet(f) || f == CorePackage.eINSTANCE.getCommand_Host() || f == CorePackage.eINSTANCE.getCommand_Bindings() || this.isChildFiltered(value = command.eGet(f))) continue;
            Variable var = this.createVariable(value);
            var.setKind(VariableKind.ARGUMENT);
            var.setType(f.getEType().toString());
            var.setName(f.getName());
            this.processVariable(var, value);
            cmd.getChildren().add((Object)var);
        }
        return cmd;
    }

    public synchronized Variable createVariable(Object value) {
        Variable cmd = ModelFactory.eINSTANCE.createVariable();
        cmd.setId(String.valueOf(this.id) + this.varId);
        ++this.varId;
        cmd.setComplex(this.isComplexValue(value));
        cmd.setObjectRef(value);
        return cmd;
    }

    private AstNode getSource(CommandStack stack) {
        Command command;
        if ((stack = stack.getParent()) != null && (command = stack.getCommand()) instanceof AstExec) {
            return (AstExec)command;
        }
        return null;
    }

    public void resolveVariable(Variable var) {
        if (var.getObjectRef() != null) {
            this.processObjectValue(var, var.getObjectRef());
        }
    }

    public Variable createVar(String name, Object value, VariableKind kind) {
        Variable var = this.createVariable(value);
        var.setKind(kind);
        var.setName(name);
        this.processVariable(var, value);
        return var;
    }
}

