/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.model.sherlock.report;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventKind implements Enumerator
{
    INFO(0, "Info", "Info"),
    BEGIN(1, "Begin", "Begin"),
    END(2, "End", "End");

    public static final int INFO_VALUE = 0;
    public static final int BEGIN_VALUE = 1;
    public static final int END_VALUE = 2;
    private static final EventKind[] VALUES_ARRAY;
    public static final List<EventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventKind[]{INFO, BEGIN, END};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind get(int value) {
        switch (value) {
            case 0: {
                return INFO;
            }
            case 1: {
                return BEGIN;
            }
            case 2: {
                return END;
            }
        }
        return null;
    }

    private EventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

