/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.jobs.jobs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JobEventKind implements Enumerator
{
    SHEDULED(0, "Sheduled", "Sheduled"),
    RUNNING(1, "Running", "Running"),
    ASYNC_FINISH(2, "AsyncFinish", "AsyncFinish"),
    ASYNC_DONE(3, "AsyncDone", "AsyncDone"),
    FINISHED(4, "Finished", "Finished"),
    SLEPPING(5, "Slepping", "Slepping"),
    WAITING(6, "Waiting", "Waiting"),
    CANCELED(7, "Canceled", "Canceled");

    public static final int SHEDULED_VALUE = 0;
    public static final int RUNNING_VALUE = 1;
    public static final int ASYNC_FINISH_VALUE = 2;
    public static final int ASYNC_DONE_VALUE = 3;
    public static final int FINISHED_VALUE = 4;
    public static final int SLEPPING_VALUE = 5;
    public static final int WAITING_VALUE = 6;
    public static final int CANCELED_VALUE = 7;
    private static final JobEventKind[] VALUES_ARRAY;
    public static final List<JobEventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JobEventKind[]{SHEDULED, RUNNING, ASYNC_FINISH, ASYNC_DONE, FINISHED, SLEPPING, WAITING, CANCELED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JobEventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JobEventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JobEventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JobEventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JobEventKind get(int value) {
        switch (value) {
            case 0: {
                return SHEDULED;
            }
            case 1: {
                return RUNNING;
            }
            case 2: {
                return ASYNC_FINISH;
            }
            case 3: {
                return ASYNC_DONE;
            }
            case 4: {
                return FINISHED;
            }
            case 5: {
                return SLEPPING;
            }
            case 6: {
                return WAITING;
            }
            case 7: {
                return CANCELED;
            }
        }
        return null;
    }

    private JobEventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

