/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.classpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathContentProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathLabelProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IEntriesChangedListener;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RuntimeClasspathViewer
extends TreeViewer
implements IClasspathViewer {
    private ListenerList fListeners = new ListenerList();
    private IClasspathEntry fCurrentParent = null;
    private IEclipsePreferences.IPreferenceChangeListener fPrefListeners = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (DebugUIPlugin.getStandardDisplay().getThread().equals(Thread.currentThread())) {
                RuntimeClasspathViewer.this.refresh(true);
            } else {
                DebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RuntimeClasspathViewer.this.refresh(true);
                    }
                });
            }
        }
    };

    public RuntimeClasspathViewer(Composite parent) {
        super(parent);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = this.getTree().getItemHeight();
        this.getTree().setLayoutData((Object)data);
        this.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (RuntimeClasspathViewer.this.updateSelection(2, (IStructuredSelection)RuntimeClasspathViewer.this.getSelection()) && event.character == '\u007f' && event.stateMask == 0) {
                    List selection = RuntimeClasspathViewer.this.getSelectionFromWidget();
                    RuntimeClasspathViewer.this.getClasspathContentProvider().removeAll(selection);
                    RuntimeClasspathViewer.this.notifyChanged();
                }
            }
        });
        this.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
                if (prefs != null) {
                    prefs.removePreferenceChangeListener(RuntimeClasspathViewer.this.fPrefListeners);
                }
            }
        });
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
        if (prefs != null) {
            prefs.addPreferenceChangeListener(this.fPrefListeners);
        }
    }

    @Override
    public void setEntries(IRuntimeClasspathEntry[] entries) {
        this.getClasspathContentProvider().setRefreshEnabled(false);
        this.resolveCurrentParent(this.getSelection());
        this.getClasspathContentProvider().removeAll(this.fCurrentParent);
        this.getClasspathContentProvider().setEntries(entries);
        this.getClasspathContentProvider().setRefreshEnabled(true);
        this.notifyChanged();
    }

    @Override
    public IRuntimeClasspathEntry[] getEntries() {
        return this.getClasspathContentProvider().getModel().getAllEntries();
    }

    @Override
    public void addEntries(IRuntimeClasspathEntry[] entries) {
        this.getClasspathContentProvider().setRefreshEnabled(false);
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        Object beforeElement = sel.getFirstElement();
        this.resolveCurrentParent(this.getSelection());
        List<IClasspathEntry> existingEntries = Arrays.asList(this.fCurrentParent.getEntries());
        int i = 0;
        while (i < entries.length) {
            if (!existingEntries.contains(entries[i])) {
                this.getClasspathContentProvider().add(this.fCurrentParent, entries[i], beforeElement);
            }
            ++i;
        }
        this.getClasspathContentProvider().setRefreshEnabled(true);
        this.notifyChanged();
    }

    private boolean resolveCurrentParent(ISelection selection) {
        this.fCurrentParent = null;
        for (Object element : (IStructuredSelection)selection) {
            if (element instanceof ClasspathEntry) {
                IClasspathEntry parent = ((IClasspathEntry)element).getParent();
                if (this.fCurrentParent != null) {
                    if (this.fCurrentParent.equals(parent)) continue;
                    return false;
                }
                this.fCurrentParent = parent;
                continue;
            }
            if (this.fCurrentParent != null) {
                if (this.fCurrentParent.equals(element)) continue;
                return false;
            }
            this.fCurrentParent = (IClasspathEntry)element;
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void setLaunchConfiguration(ILaunchConfiguration configuration) {
        if (this.getLabelProvider() != null) {
            ((ClasspathLabelProvider)this.getLabelProvider()).setLaunchConfiguration(configuration);
        }
    }

    public void addEntriesChangedListener(IEntriesChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeEntriesChangedListener(IEntriesChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void notifyChanged() {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IEntriesChangedListener)listeners[i]).entriesChanged(this);
            ++i;
        }
    }

    @Override
    public int indexOf(IRuntimeClasspathEntry entry) {
        IClasspathEntry existingEntry;
        IClasspathEntry[] entries = this.getClasspathContentProvider().getBootstrapClasspathEntries();
        int i = 0;
        while (i < entries.length) {
            existingEntry = entries[i];
            if (existingEntry.equals(entry)) {
                return 1;
            }
            ++i;
        }
        entries = this.getClasspathContentProvider().getUserClasspathEntries();
        i = 0;
        while (i < entries.length) {
            existingEntry = entries[i];
            if (existingEntry.equals(entry)) {
                return 1;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Shell getShell() {
        return this.getControl().getShell();
    }

    private ClasspathContentProvider getClasspathContentProvider() {
        return (ClasspathContentProvider)super.getContentProvider();
    }

    @Override
    public boolean updateSelection(int actionType, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        switch (actionType) {
            case 1: {
                for (IClasspathEntry entry : selection) {
                    if (entry.isEditable() || !(entry instanceof ClasspathEntry)) continue;
                    return false;
                }
                return selection.size() > 0;
            }
            case 2: 
            case 3: {
                for (IClasspathEntry entry : selection) {
                    if (entry.isEditable()) continue;
                    return false;
                }
                return selection.size() > 0;
            }
        }
        return true;
    }

    public ISelection getSelectedEntries() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(selection.size() * 2);
        for (IClasspathEntry element : selection) {
            if (element.hasEntries()) {
                entries.addAll(Arrays.asList(element.getEntries()));
                continue;
            }
            entries.add(element);
        }
        return new StructuredSelection(entries);
    }
}

