/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public final class Signatures {
    private Signatures() {
    }

    public static String processMethodSignature(IApiMethod method) {
        String signature = method.getGenericSignature();
        if (signature == null) {
            signature = method.getSignature();
        }
        return Signatures.dequalifySignature(signature);
    }

    public static String getPrimaryTypeName(String typename) {
        int idx = typename.indexOf(36);
        if (idx > -1) {
            return typename.substring(0, idx);
        }
        return typename;
    }

    public static String getMethodSignature(IApiMethod method) throws CoreException {
        String methodsig = method.getGenericSignature();
        if (methodsig == null) {
            methodsig = method.getSignature();
        }
        String methodname = Signatures.getMethodName(method);
        return Signature.toString((String)Signatures.dequalifySignature(methodsig), (String)methodname, null, (boolean)false, (boolean)false);
    }

    public static String getQualifiedMethodSignature(IApiMethod method) throws CoreException {
        String methodsig;
        StringBuffer buffer = new StringBuffer();
        IApiType type = method.getEnclosingType();
        if (type != null) {
            buffer.append(Signatures.getQualifiedTypeSignature(type)).append('.');
        }
        if ((methodsig = method.getGenericSignature()) == null) {
            methodsig = method.getSignature();
        }
        String methodname = Signatures.getMethodName(method);
        buffer.append(Signature.toString((String)Signatures.dequalifySignature(methodsig), (String)methodname, null, (boolean)false, (boolean)false));
        return buffer.toString();
    }

    public static String getQualifiedMethodSignature(IMethodDescriptor method) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        IReferenceTypeDescriptor type = method.getEnclosingType();
        if (type != null) {
            buffer.append(Signatures.getQualifiedTypeSignature(type)).append('.');
        }
        String methodsig = method.getSignature();
        String methodname = Signatures.getMethodName(method);
        buffer.append(Signature.toString((String)Signatures.dequalifySignature(methodsig), (String)methodname, null, (boolean)false, (boolean)false));
        return buffer.toString();
    }

    public static String getQualifiedMethodSignature(IMethodDescriptor method, boolean qualifiedparams, boolean includereturn) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        IReferenceTypeDescriptor type = method.getEnclosingType();
        if (type != null) {
            buffer.append(Signatures.getQualifiedTypeSignature(type)).append('.');
        }
        String methodsig = method.getSignature();
        String methodname = Signatures.getMethodName(method);
        buffer.append(Signature.toString((String)methodsig, (String)methodname, null, (boolean)qualifiedparams, (boolean)false).replace('/', '.'));
        if (includereturn) {
            buffer.append(" : ");
            buffer.append(Signature.toString((String)Signature.getReturnType((String)methodsig)).replace('/', '.'));
        }
        return buffer.toString();
    }

    public static String getMethodSignature(IMethodDescriptor method, boolean includereturn) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        String methodsig = method.getSignature();
        String methodname = Signatures.getMethodName(method);
        String dqsig = Signatures.dequalifySignature(methodsig);
        buffer.append(Signature.toString((String)dqsig, (String)methodname, null, (boolean)false, (boolean)false));
        if (includereturn) {
            buffer.append(" : ");
            buffer.append(Signature.toString((String)Signature.getReturnType((String)dqsig)).replace('/', '.'));
        }
        return buffer.toString();
    }

    public static String getMethodName(IApiMethod method) throws CoreException {
        IApiType type;
        String mname = method.getName();
        if ("<init>".equals(method.getName()) && (type = method.getEnclosingType()) != null) {
            return type.getSimpleName();
        }
        return mname;
    }

    public static String getMethodName(IMethodDescriptor method) throws CoreException {
        IReferenceTypeDescriptor type;
        String mname = method.getName();
        if ("<init>".equals(method.getName()) && (type = method.getEnclosingType()) != null) {
            return type.getName();
        }
        return mname;
    }

    public static String getFieldSignature(IApiField field) {
        return field.getName();
    }

    public static String getQualifiedFieldSignature(IApiField field) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        IApiType type = field.getEnclosingType();
        if (type != null) {
            buffer.append(Signatures.getQualifiedTypeSignature(type)).append('.');
        }
        buffer.append(field.getName());
        return buffer.toString();
    }

    public static String getQualifiedFieldSignature(IFieldDescriptor field) {
        StringBuffer buffer = new StringBuffer();
        IReferenceTypeDescriptor type = field.getEnclosingType();
        if (type != null) {
            buffer.append(Signatures.getQualifiedTypeSignature(type)).append('.');
        }
        buffer.append(field.getName());
        return buffer.toString();
    }

    public static String getQualifiedTypeSignature(IApiType type) {
        return Signatures.getTypeSignature(type.getSignature(), type.getGenericSignature(), true);
    }

    public static String getQualifiedTypeSignature(IReferenceTypeDescriptor type) {
        return Signatures.getTypeSignature(type.getSignature(), type.getGenericSignature(), true);
    }

    public static String getTypeSignature(IApiType type) {
        return Signatures.getTypeSignature(type.getSignature(), type.getGenericSignature(), false);
    }

    public static String getTypeSignature(String signature, String genericsignature, boolean qualified) {
        StringBuffer buffer = new StringBuffer();
        String sig = signature.replace('/', '.');
        if (!qualified) {
            sig = Signatures.dequalifySignature(sig);
        }
        buffer.append(Signature.toString((String)sig.replace('$', '.')));
        if (genericsignature != null) {
            Signatures.appendTypeParameters(buffer, Signature.getTypeParameters((String)genericsignature.replace('/', '.')));
        }
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String getAnonymousTypeName(String name) {
        if (name != null && (idx = name.lastIndexOf(36)) > -1) {
            num = name.substring(idx + 1, name.length());
            try {
                Integer.parseInt(num);
                return null;
            }
            catch (NumberFormatException v0) {
                i = 0;
                ** while (i < name.length())
            }
lbl-1000:
            // 1 sources

            {
                if (!Character.isDigit(num.charAt(i))) {
                    return num.substring(i, num.length());
                }
                ++i;
                continue;
            }
        }
lbl14:
        // 3 sources

        return null;
    }

    public static void appendTypeParameters(StringBuffer buffer, String[] parameters) {
        if (parameters == null) {
            return;
        }
        if (parameters.length == 0) {
            return;
        }
        buffer.append(Signatures.getLT());
        int i = 0;
        while (i < parameters.length) {
            if (i > 0) {
                buffer.append(Signatures.getComma());
            }
            buffer.append(Signature.getTypeVariable((String)parameters[i]));
            ++i;
        }
        buffer.append(Signatures.getGT());
    }

    public static String getComma() {
        return ", ";
    }

    public static String getLT() {
        return "<";
    }

    public static String getGT() {
        return ">";
    }

    public static String dequalifySignature(String signature) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = signature.toCharArray();
        int i = 0;
        int max = chars.length;
        while (i < max) {
            char currentChar = chars[i];
            switch (currentChar) {
                case 'L': {
                    if (chars[i + 1] != ';') {
                        buffer.append('Q');
                        int lastDotPosition = i++;
                        while (i < chars.length && currentChar != ';' && currentChar != '<') {
                            switch (currentChar) {
                                case '.': 
                                case '/': {
                                    lastDotPosition = i;
                                    break;
                                }
                            }
                            currentChar = chars[++i];
                        }
                        buffer.append(chars, lastDotPosition + 1, i - lastDotPosition - 1);
                        buffer.append(currentChar);
                        break;
                    }
                    buffer.append(currentChar);
                    break;
                }
                case 'Q': {
                    while (i < chars.length && currentChar != ';') {
                        buffer.append(currentChar);
                        currentChar = chars[++i];
                    }
                }
                default: {
                    buffer.append(currentChar);
                }
            }
            ++i;
        }
        return String.valueOf(buffer);
    }

    public static String getMethodSignatureFromNode(MethodDeclaration node) {
        Assert.isNotNull((Object)node);
        List params = node.parameters();
        List<String> rparams = Signatures.getParametersTypeNames(params);
        if (rparams.size() == params.size()) {
            if (!node.isConstructor()) {
                String rtype;
                Type returnType = Signatures.getType((ASTNode)node);
                if (returnType != null && (rtype = Signatures.getTypeSignature(returnType)) != null) {
                    return Signature.createMethodSignature((String[])rparams.toArray(new String[rparams.size()]), (String)rtype);
                }
            } else {
                Signatures.collectSyntheticParam(node, rparams);
                return Signature.createMethodSignature((String[])rparams.toArray(new String[rparams.size()]), (String)"V");
            }
        }
        return null;
    }

    private static List<String> getParametersTypeNames(List<SingleVariableDeclaration> rawparams) {
        ArrayList<String> rparams = new ArrayList<String>(rawparams.size());
        String pname = null;
        for (SingleVariableDeclaration param : rawparams) {
            pname = Signatures.getTypeSignature(Signatures.getType((ASTNode)param));
            if (pname == null) continue;
            rparams.add(pname);
        }
        return rparams;
    }

    private static Type getType(ASTNode node) {
        switch (node.getNodeType()) {
            case 44: {
                SingleVariableDeclaration param = (SingleVariableDeclaration)node;
                Type type = param.getType();
                int extraDim = param.getExtraDimensions();
                if (extraDim == 0) {
                    return type;
                }
                AST ast = type.getAST();
                type = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type);
                type = ast.newArrayType(type, extraDim);
                return type;
            }
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)node;
        Type type = methodDeclaration.getReturnType2();
        int extraDim = methodDeclaration.getExtraDimensions();
        if (extraDim == 0) {
            return type;
        }
        AST ast = type.getAST();
        type = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type);
        type = ast.newArrayType(type, extraDim);
        return type;
    }

    public static String getTypeName(String qualifiedname) {
        int idx = qualifiedname.lastIndexOf(46);
        if (++idx > 0) {
            return qualifiedname.substring(idx, qualifiedname.length());
        }
        return qualifiedname;
    }

    public static String getTypeSignature(Type type) {
        switch (type.getNodeType()) {
            case 43: {
                return Signature.createTypeSignature((String)((SimpleType)type).getName().getFullyQualifiedName(), (boolean)false);
            }
            case 75: {
                return Signature.createTypeSignature((String)((QualifiedType)type).getName().getFullyQualifiedName(), (boolean)false);
            }
            case 5: {
                ArrayType a = (ArrayType)type;
                return Signature.createArraySignature((String)Signatures.getTypeSignature(a.getElementType()), (int)a.getDimensions());
            }
            case 74: {
                return Signatures.getTypeSignature(((ParameterizedType)type).getType());
            }
            case 39: {
                return Signature.createTypeSignature((String)((PrimitiveType)type).getPrimitiveTypeCode().toString(), (boolean)false);
            }
        }
        return null;
    }

    public static boolean matchesSignatures(String signature, String signature2) {
        String[] parameterTypes2;
        int length2;
        if (!Signatures.matches(Signature.getReturnType((String)signature), Signature.getReturnType((String)signature2))) {
            return false;
        }
        String[] parameterTypes = Signature.getParameterTypes((String)signature);
        int length = parameterTypes.length;
        if (length != (length2 = (parameterTypes2 = Signature.getParameterTypes((String)signature2)).length)) {
            return false;
        }
        int i = 0;
        while (i < length2) {
            if (!Signatures.matches(parameterTypes[i], parameterTypes2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean matches(String type, String type2) {
        if (Signature.getArrayCount((String)type) == Signature.getArrayCount((String)type2)) {
            String[] typeargs2;
            String el1 = Signature.getElementType((String)type);
            String el2 = Signature.getElementType((String)type2);
            String[] typeargs1 = Signature.getTypeArguments((String)el1);
            if (typeargs1.length == (typeargs2 = Signature.getTypeArguments((String)el2)).length) {
                String signatureSimpleName2;
                if (typeargs1.length > 0) {
                    int i = 0;
                    while (i < typeargs1.length) {
                        if (!Signatures.matches(typeargs1[i], typeargs2[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                String signatureSimpleName = Signature.getSignatureSimpleName((String)el1);
                if (signatureSimpleName.equals(signatureSimpleName2 = Signature.getSignatureSimpleName((String)el2))) {
                    return true;
                }
                int index = signatureSimpleName2.lastIndexOf(46);
                if (index != -1) {
                    return signatureSimpleName.equals(signatureSimpleName2.subSequence(index + 1, signatureSimpleName2.length()));
                }
            }
        }
        return false;
    }

    public static boolean isQualifiedSignature(String signature) {
        StringTokenizer tokenizer = new StringTokenizer(signature, "();IJCSBDFTZ![");
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken().charAt(0) == 'L';
        }
        return false;
    }

    public static String getPackageName(String typeName) {
        int index = typeName.lastIndexOf(46);
        return index == -1 ? "" : typeName.substring(0, index);
    }

    static void collectSyntheticParam(MethodDeclaration method, List<String> rparams) {
        Assert.isNotNull((Object)method);
        if (Signatures.isInTopLevelType(method)) {
            return;
        }
        ASTNode parent = method.getParent();
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)parent;
        if (Signatures.isStatic(type)) {
            return;
        }
        StringBuffer name = new StringBuffer();
        while (parent != null) {
            CompilationUnit cunit;
            PackageDeclaration pdec;
            if ((parent = parent.getParent()) instanceof AbstractTypeDeclaration) {
                type = (AbstractTypeDeclaration)parent;
                name.insert(0, type.getName().getFullyQualifiedName());
                if (!type.isMemberTypeDeclaration()) continue;
                name.insert(0, '$');
                continue;
            }
            if (!(parent instanceof CompilationUnit) || (pdec = (cunit = (CompilationUnit)parent).getPackage()) == null) continue;
            name.insert(0, '.');
            name.insert(0, cunit.getPackage().getName().getFullyQualifiedName());
        }
        name.insert(0, "L");
        name.append(';');
        if (name.length() > 2) {
            rparams.add(0, name.toString());
        }
    }

    static boolean isStatic(AbstractTypeDeclaration typeDeclaration) {
        List modifiers = typeDeclaration.modifiers();
        if (modifiers.isEmpty()) {
            return false;
        }
        for (IExtendedModifier modifier : modifiers) {
            Modifier modifier2;
            if (!modifier.isModifier() || !(modifier2 = (Modifier)modifier).isStatic()) continue;
            return true;
        }
        return false;
    }

    static boolean isInTopLevelType(MethodDeclaration method) {
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)method.getParent();
        return type != null && type.isPackageMemberTypeDeclaration();
    }

    public static String getSimpleTypeName(String referencedTypeName) {
        int index = referencedTypeName.lastIndexOf(46);
        if (index == -1) {
            return referencedTypeName;
        }
        return referencedTypeName.substring(index + 1);
    }
}

