/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiBaselinePreferencePage;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.pde.internal.ui.preferences.ConfigurationBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class ApiBaselinesConfigurationBlock
extends ConfigurationBlock {
    private static final Key KEY_MISSING_DEFAULT_API_PROFILE = ApiBaselinesConfigurationBlock.getApiToolsKey("missing_default_api_profile");
    private static Key[] fgAllKeys = new Key[]{KEY_MISSING_DEFAULT_API_PROFILE};
    private static final String[] SEVERITIES_LABELS = new String[]{PreferenceMessages.ApiErrorsWarningsConfigurationBlock_error, PreferenceMessages.ApiErrorsWarningsConfigurationBlock_warning, PreferenceMessages.ApiErrorsWarningsConfigurationBlock_ignore};
    private static final String[] SEVERITIES = new String[]{"Error", "Warning", "Ignore"};
    private SelectionListener selectionlistener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Combo) {
                Combo combo = (Combo)e.widget;
                ControlData data = (ControlData)combo.getData();
                data.key.setStoredValue(ApiBaselinesConfigurationBlock.this.fLookupOrder[0], combo.getText(), ApiBaselinesConfigurationBlock.this.fManager);
                ApiBaselinesConfigurationBlock.this.fDirty = true;
                ApiBaselinePreferencePage.rebuildcount = 0;
            }
        }
    };
    private Combo fCombo = null;
    IScopeContext[] fLookupOrder = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    IWorkingCopyManager fManager = null;
    private Composite fMainComp = null;
    boolean fDirty = false;
    private Composite fParent = null;

    protected static final Key getApiToolsKey(String key) {
        return new Key("org.eclipse.pde.api.tools", key);
    }

    public ApiBaselinesConfigurationBlock(IWorkbenchPreferenceContainer container) {
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
    }

    public Control createControl(Composite parent, ApiBaselinePreferencePage page) {
        this.fParent = parent;
        this.fMainComp = SWTFactory.createComposite(parent, 1, 1, 768, 0, 0);
        Group optionsProfileGroup = SWTFactory.createGroup(this.fMainComp, PreferenceMessages.ApiProfilesConfigurationBlock_options_group_title, 2, 1, 1808);
        this.fCombo = this.createComboControl((Composite)optionsProfileGroup, PreferenceMessages.ApiProfilesConfigurationBlock_missing_default_api_profile_message, KEY_MISSING_DEFAULT_API_PROFILE);
        Dialog.applyDialogFont((Control)this.fMainComp);
        return this.fMainComp;
    }

    public void performOK() {
        this.save();
    }

    public void performApply() {
        this.save();
    }

    private void save() {
        if (this.fDirty) {
            try {
                ArrayList<Key> changes = new ArrayList<Key>();
                this.collectChanges(this.fLookupOrder[0], changes);
                if (changes.size() > 0 && ApiBaselinePreferencePage.rebuildcount < 1) {
                    ++ApiBaselinePreferencePage.rebuildcount;
                    this.fManager.applyChanges();
                    String message = PreferenceMessages.ApiErrorsWarningsConfigurationBlock_0;
                    IProject[] apiProjects = Util.getApiProjects();
                    if (apiProjects != null && MessageDialog.openQuestion((Shell)this.fParent.getShell(), (String)PreferenceMessages.ApiErrorsWarningsConfigurationBlock_2, (String)message)) {
                        Util.getBuildJob((IProject[])apiProjects).schedule();
                    }
                }
                this.fDirty = false;
            }
            catch (BackingStoreException bse) {
                ApiPlugin.log((Throwable)bse);
            }
        }
    }

    public void performCancel() {
    }

    public void performDefaults() {
        String defval = null;
        int i = 0;
        while (i < fgAllKeys.length) {
            defval = fgAllKeys[i].getStoredValue(this.fLookupOrder, true, this.fManager);
            fgAllKeys[i].setStoredValue(this.fLookupOrder[0], defval, this.fManager);
            ++i;
        }
        this.updateCombos();
        this.fDirty = true;
    }

    private void updateCombos() {
        if (this.fCombo != null) {
            ControlData data = (ControlData)this.fCombo.getData();
            this.fCombo.select(data.getSelection(data.getKey().getStoredValue(this.fLookupOrder, false, this.fManager)));
        }
    }

    public void dispose() {
        this.fMainComp.getParent().dispose();
    }

    protected Combo createComboControl(Composite parent, String label, Key key) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(1, 2, true, false);
        lbl.setLayoutData((Object)gd);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        gd = new GridData(3, 2, false, false);
        combo.setLayoutData((Object)gd);
        ControlData data = new ControlData(key, SEVERITIES);
        combo.setData((Object)data);
        combo.setItems(SEVERITIES_LABELS);
        combo.addSelectionListener(this.selectionlistener);
        combo.select(data.getSelection(key.getStoredValue(this.fLookupOrder, false, this.fManager)));
        this.addHighlight(parent, lbl, combo);
        return combo;
    }

    private void collectChanges(IScopeContext context, List<Key> changes) {
        Key key = null;
        String origval = null;
        String newval = null;
        boolean complete = true;
        int i = 0;
        while (i < fgAllKeys.length) {
            key = fgAllKeys[i];
            origval = key.getStoredValue(context, null);
            newval = key.getStoredValue(context, this.fManager);
            if (newval == null) {
                if (origval != null) {
                    changes.add(key);
                } else if (complete) {
                    key.setStoredValue(context, key.getStoredValue(this.fLookupOrder, true, this.fManager), this.fManager);
                    changes.add(key);
                }
            } else if (!newval.equals(origval)) {
                changes.add(key);
            }
            ++i;
        }
    }

    public static Key[] getAllKeys() {
        return fgAllKeys;
    }

    protected static class ControlData {
        Key key;
        private String[] values;

        public ControlData(Key key, String[] values) {
            this.key = key;
            this.values = values;
        }

        public Key getKey() {
            return this.key;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.values[index];
        }

        public String getValue(int index) {
            return this.values[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.values.length) {
                    if (value.equals(this.values[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.values.length - 1;
        }
    }

    protected static class Key {
        private String qualifier;
        private String key;

        public Key(String qualifier, String key) {
            this.qualifier = qualifier;
            this.key = key;
        }

        private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = context.getNode(this.qualifier);
            if (manager != null) {
                return manager.getWorkingCopy(node);
            }
            return node;
        }

        public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (node != null) {
                return node.get(this.key, null);
            }
            return null;
        }

        public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < lookupOrder.length) {
                String value = this.getStoredValue(lookupOrder[i], manager);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (value != null) {
                node.put(this.key, value);
            } else {
                node.remove(this.key);
            }
        }

        public String toString() {
            return String.valueOf(this.qualifier) + '/' + this.key;
        }
    }
}

