/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IInPlaceEditor;
import org.eclipse.ui.IInPlaceEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FileInPlaceEditorInput
extends FileEditorInput
implements IInPlaceEditorInput {
    IInPlaceEditor embeddedEditor;
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta affectedElement;
            IResourceDelta mainDelta = event.getDelta();
            if (mainDelta != null && FileInPlaceEditorInput.this.embeddedEditor != null && (affectedElement = mainDelta.findMember(FileInPlaceEditorInput.this.getFile().getFullPath())) != null) {
                this.processDelta(affectedElement);
            }
        }

        private boolean processDelta(final IResourceDelta delta) {
            Runnable changeRunnable = null;
            switch (delta.getKind()) {
                case 2: {
                    changeRunnable = (0x2000 & delta.getFlags()) != 0 ? new Runnable(){

                        @Override
                        public void run() {
                            IPath path = delta.getMovedToPath();
                            IFile newFile = delta.getResource().getWorkspace().getRoot().getFile(path);
                            if (newFile != null && (this).FileInPlaceEditorInput.this.embeddedEditor != null) {
                                (this).FileInPlaceEditorInput.this.embeddedEditor.sourceChanged((IInPlaceEditorInput)new FileInPlaceEditorInput(newFile));
                            }
                        }
                    } : new Runnable(){

                        @Override
                        public void run() {
                            if ((this).FileInPlaceEditorInput.this.embeddedEditor != null) {
                                (this).FileInPlaceEditorInput.this.embeddedEditor.sourceDeleted();
                                (this).FileInPlaceEditorInput.this.embeddedEditor.getSite().getPage().closeEditor((IEditorPart)(this).FileInPlaceEditorInput.this.embeddedEditor, true);
                            }
                        }
                    };
                }
            }
            if (changeRunnable != null && FileInPlaceEditorInput.this.embeddedEditor != null) {
                FileInPlaceEditorInput.this.embeddedEditor.getSite().getShell().getDisplay().asyncExec(changeRunnable);
            }
            return true;
        }
    };

    public FileInPlaceEditorInput(IFile file) {
        super(file);
    }

    public void setInPlaceEditor(IInPlaceEditor editor) {
        if (this.embeddedEditor != editor) {
            if (this.embeddedEditor != null) {
                this.getFile().getWorkspace().removeResourceChangeListener(this.resourceListener);
            }
            this.embeddedEditor = editor;
            if (this.embeddedEditor != null) {
                this.getFile().getWorkspace().addResourceChangeListener(this.resourceListener);
            }
        }
    }
}

