/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.Types;
import java.util.Collection;
import org.eclipse.jdt.apt.core.internal.NonEclipseImplementationException;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.TypeParameterDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.type.ArrayTypeImpl;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class TypesUtil
implements Types {
    private static final String[] NO_ARGS = new String[0];
    private final BaseProcessorEnv _env;

    public static void main(String[] args) {
    }

    public TypesUtil(BaseProcessorEnv env) {
        this._env = env;
        assert (env != null) : "null environment.";
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        if (componentType == null) {
            return null;
        }
        if (componentType instanceof EclipseMirrorType) {
            ITypeBinding leaf;
            int dimension;
            EclipseMirrorType impl = (EclipseMirrorType)componentType;
            switch (impl.kind()) {
                case TYPE_VOID: 
                case TYPE_ERROR: {
                    throw new IllegalArgumentException("Illegal element type for array");
                }
                case TYPE_ARRAY: {
                    ITypeBinding array = ((ArrayTypeImpl)componentType).getTypeBinding();
                    dimension = array.getDimensions() + 1;
                    leaf = array.getElementType();
                    break;
                }
                default: {
                    leaf = impl.getTypeBinding();
                    dimension = 1;
                }
            }
            if (leaf == null || leaf.isParameterizedType()) {
                throw new IllegalArgumentException("illegal component type: " + componentType);
            }
            String bindingKey = BindingKey.createArrayTypeBindingKey((String)leaf.getKey(), (int)dimension);
            ITypeBinding arrayType = this._env.getTypeBindingFromKey(bindingKey);
            if (arrayType == null) {
                return null;
            }
            return (ArrayType)((Object)Factory.createTypeMirror(arrayType, this._env));
        }
        throw new NonEclipseImplementationException("only applicable to eclipse type system objects. Found " + componentType.getClass().getName());
    }

    private ITypeBinding findMemberType(ITypeBinding outer, String inner) {
        ITypeBinding[] interfaces;
        ITypeBinding[] nestedTypes;
        if (outer == null || inner == null) {
            return null;
        }
        outer = outer.getTypeDeclaration();
        ITypeBinding[] iTypeBindingArray = nestedTypes = outer.getDeclaredTypes();
        int n = nestedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding nestedType = iTypeBindingArray[n2];
            if (inner.equals(nestedType.getName())) {
                return nestedType;
            }
            ++n2;
        }
        ITypeBinding result = this.findMemberType(outer.getSuperclass(), inner);
        if (result != null) {
            return result;
        }
        ITypeBinding[] iTypeBindingArray2 = interfaces = outer.getInterfaces();
        int n3 = interfaces.length;
        int n4 = 0;
        while (n4 < n3) {
            ITypeBinding interfaceType = iTypeBindingArray2[n4];
            result = this.findMemberType(interfaceType, inner);
            if (result != null) {
                return result;
            }
            ++n4;
        }
        return null;
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType containing, TypeDeclaration decl, TypeMirror ... typeArgs) {
        int numArgs;
        ITypeBinding memberBinding;
        if (decl == null) {
            return null;
        }
        ITypeBinding outerBinding = TypesUtil.getTypeBinding(containing);
        if (containing == null) {
            memberBinding = TypesUtil.getTypeBinding(decl);
        } else {
            if (outerBinding.isGenericType()) {
                throw new IllegalArgumentException("[containing], " + containing + ", is a generic type.");
            }
            memberBinding = this.findMemberType(outerBinding, decl.getSimpleName());
            if (memberBinding == null) {
                throw new IllegalArgumentException(decl + " is not a member type of " + containing);
            }
        }
        int n = numArgs = typeArgs == null ? 0 : typeArgs.length;
        if (memberBinding.isGenericType()) {
            int numTypeParams;
            String[] argKeys = numArgs == 0 ? NO_ARGS : new String[numArgs];
            int i = 0;
            while (i < numArgs) {
                ITypeBinding binding = TypesUtil.getTypeBinding(typeArgs[i]);
                assert (binding != null) : "failed to get binding mirror type";
                argKeys[i] = binding.getKey();
                ++i;
            }
            ITypeBinding[] typeParams = memberBinding.getTypeParameters();
            int n2 = numTypeParams = typeParams == null ? 0 : typeParams.length;
            if (numTypeParams != numArgs && numArgs != 0) {
                throw new IllegalArgumentException("type, " + memberBinding.getQualifiedName() + ", require " + numTypeParams + " type arguments " + "but found " + numArgs);
            }
            String typeKey = BindingKey.createParameterizedTypeBindingKey((String)memberBinding.getKey(), (String[])argKeys);
            ITypeBinding resultBinding = this._env.getTypeBindingFromKey(typeKey);
            return Factory.createReferenceType(resultBinding, this._env);
        }
        if (numArgs != 0) {
            throw new IllegalArgumentException("type, " + memberBinding + " is not a generic type and cannot have type arguments.");
        }
        return (DeclaredType)((Object)decl);
    }

    @Override
    public DeclaredType getDeclaredType(TypeDeclaration decl, TypeMirror ... typeArgs) {
        return this.getDeclaredType(null, decl, typeArgs);
    }

    @Override
    public TypeMirror getErasure(TypeMirror t) {
        if (t == null) {
            return null;
        }
        if (t instanceof EclipseMirrorType) {
            EclipseMirrorType impl = (EclipseMirrorType)t;
            switch (impl.kind()) {
                case TYPE_VOID: 
                case TYPE_PRIMITIVE: 
                case TYPE_ERROR: {
                    return t;
                }
            }
            ITypeBinding binding = impl.getTypeBinding();
            ITypeBinding erasure = binding.getErasure();
            if (erasure == binding) {
                return t;
            }
            EclipseMirrorType m_erasure = Factory.createTypeMirror(erasure, impl.getEnvironment());
            if (m_erasure == null) {
                return Factory.createErrorClassType(erasure);
            }
            return m_erasure;
        }
        throw new NonEclipseImplementationException("only applicable to eclipse type system objects. Found " + t.getClass().getName());
    }

    @Override
    public PrimitiveType getPrimitiveType(PrimitiveType.Kind kind) {
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case BOOLEAN: {
                return this._env.getBooleanType();
            }
            case BYTE: {
                return this._env.getByteType();
            }
            case CHAR: {
                return this._env.getCharType();
            }
            case DOUBLE: {
                return this._env.getDoubleType();
            }
            case FLOAT: {
                return this._env.getFloatType();
            }
            case INT: {
                return this._env.getIntType();
            }
            case LONG: {
                return this._env.getLongType();
            }
            case SHORT: {
                return this._env.getShortType();
            }
        }
        throw new IllegalStateException("unknown primitive kind : " + (Object)((Object)kind));
    }

    @Override
    public TypeVariable getTypeVariable(TypeParameterDeclaration tparam) {
        if (tparam == null) {
            return null;
        }
        if (tparam instanceof TypeParameterDeclarationImpl) {
            return (TypeVariable)((Object)tparam);
        }
        throw new NonEclipseImplementationException("only applicable to eclipse type system objects. Found " + tparam.getClass().getName());
    }

    @Override
    public VoidType getVoidType() {
        return this._env.getVoidType();
    }

    @Override
    public WildcardType getWildcardType(Collection<ReferenceType> upperBounds, Collection<ReferenceType> lowerBounds) {
        ITypeBinding binding;
        int boundKind;
        String boundKey;
        int lowerBoundCount;
        int upperBoundCount = upperBounds == null ? 0 : upperBounds.size();
        int n = lowerBoundCount = lowerBounds == null ? 0 : lowerBounds.size();
        if (upperBoundCount == 0 && lowerBoundCount == 0) {
            boundKey = null;
            boundKind = 42;
        } else if (upperBoundCount == 1 && lowerBoundCount == 0) {
            binding = TypesUtil.getTypeBinding(upperBounds.iterator().next());
            boundKey = binding.getKey();
            boundKind = 43;
        } else if (lowerBoundCount == 1 && upperBoundCount == 0) {
            binding = TypesUtil.getTypeBinding(lowerBounds.iterator().next());
            boundKey = binding.getKey();
            boundKind = 45;
        } else {
            throw new IllegalArgumentException("Wildcard can only have a upper bound, a lower bound or be unbounded.");
        }
        String wildcardkey = BindingKey.createWilcardTypeBindingKey(boundKey, (char)boundKind);
        ITypeBinding wildcard = this._env.getTypeBindingFromKey(wildcardkey);
        return (WildcardType)((Object)Factory.createTypeMirror(wildcard, this._env));
    }

    @Override
    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        EclipseMirrorType left = (EclipseMirrorType)t1;
        EclipseMirrorType right = (EclipseMirrorType)t2;
        return left.isAssignmentCompatible(right);
    }

    @Override
    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        EclipseMirrorType left = (EclipseMirrorType)t1;
        EclipseMirrorType right = (EclipseMirrorType)t2;
        return left.isSubTypeCompatible(right);
    }

    private static ITypeBinding getTypeBinding(TypeMirror type) throws NonEclipseImplementationException {
        if (type == null) {
            return null;
        }
        if (type instanceof EclipseMirrorType) {
            return ((EclipseMirrorType)type).getTypeBinding();
        }
        throw new NonEclipseImplementationException("only applicable to eclipse type system objects. Found " + type.getClass().getName());
    }

    public static ITypeBinding getTypeBinding(TypeDeclaration type) throws NonEclipseImplementationException {
        if (type == null) {
            return null;
        }
        if (type instanceof EclipseMirrorObject) {
            return ((TypeDeclarationImpl)type).getTypeBinding();
        }
        throw new NonEclipseImplementationException("only applicable to eclipse type system objects. Found " + type.getClass().getName());
    }
}

