/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.runtime;

import java.util.LinkedHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.ui.Color;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.verifications.runtime.StyledMessage;
import org.eclipse.rcptt.verifications.runtime.VerificationStatus;
import org.eclipse.rcptt.verifications.status.TreeItemStyleVerificationError;
import org.eclipse.rcptt.verifications.status.TreeItemVerificationError;
import org.eclipse.rcptt.verifications.status.VerificationStatusData;

public class VerificationReporter {
    public static StyledMessage getStyledMessage(VerificationStatus status) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<StyleRangeEntry, Object> styles = new LinkedHashMap<StyleRangeEntry, Object>();
        sb.append(status.getMessage()).append('\n');
        for (VerificationStatusData data : status.getData()) {
            VerificationReporter.appendVerificationStatusData(data, styles, sb);
        }
        return new StyledMessage(sb.toString(), styles);
    }

    private static void appendVerificationStatusData(VerificationStatusData data, LinkedHashMap<StyleRangeEntry, Object> ranges, StringBuilder buffer) {
        if (data instanceof TreeItemStyleVerificationError) {
            buffer.append(data.getMessage());
            VerificationReporter.appendTreeItemStyleVerificationErrorData((TreeItemStyleVerificationError)data, ranges, buffer);
            VerificationReporter.appendTreeItemVerificationErrorData((TreeItemVerificationError)data, ranges, buffer);
        } else if (data instanceof TreeItemVerificationError) {
            buffer.append(data.getMessage());
            VerificationReporter.appendTreeItemVerificationErrorData((TreeItemVerificationError)data, ranges, buffer);
        } else {
            buffer.append(data.getMessage());
        }
        buffer.append("\n");
    }

    private static void appendTreeItemStyleVerificationErrorData(TreeItemStyleVerificationError error, LinkedHashMap<StyleRangeEntry, Object> ranges, StringBuilder buffer) {
        buffer.append(" Expected ");
        if (error.getExpectedStyle() != null) {
            VerificationReporter.appendStyleRange(buffer, ranges, error.getExpectedStyle(), VerificationReporter.getRangeEntryDescription(error.getExpectedStyle(), "start", "length", "text"));
        } else {
            buffer.append("no style");
        }
        buffer.append(", but was ");
        if (error.getActualStyle() != null) {
            VerificationReporter.appendStyleRange(buffer, ranges, error.getActualStyle(), VerificationReporter.getRangeEntryDescription(error.getActualStyle(), "start", "length", "text"));
        } else {
            buffer.append("no style");
        }
    }

    private static void appendStyleRange(StringBuilder buffer, LinkedHashMap<StyleRangeEntry, Object> ranges, StyleRangeEntry rangeEntry, String text) {
        int start = buffer.length();
        buffer.append(text);
        int length = buffer.length() - start;
        StyleRangeEntry range = (StyleRangeEntry)EcoreUtil.copy((EObject)rangeEntry);
        range.setStart(start);
        range.setLength(length);
        ranges.put(range, null);
    }

    private static void appendTreeItemVerificationErrorData(TreeItemVerificationError error, LinkedHashMap<StyleRangeEntry, Object> ranges, StringBuilder buffer) {
        if (error.getColumn() != null) {
            buffer.append(" in column ");
            buffer.append("\"");
            buffer.append(error.getColumn());
            buffer.append("\"");
        }
        if (error.getItemPath() != null) {
            buffer.append(" at item ");
            buffer.append("\"");
            int start = buffer.length();
            buffer.append(error.getItemPath());
            int length = buffer.length() - start;
            ranges.put(VerificationReporter.createLinkStyle(start, length), error);
            buffer.append("\"");
        }
    }

    private static StyleRangeEntry createLinkStyle(int start, int length) {
        StyleRangeEntry style = UiFactory.eINSTANCE.createStyleRangeEntry();
        style.setUnderline("verification_link");
        style.setStart(start);
        style.setLength(length);
        return style;
    }

    public static String getRangeEntryDescription(StyleRangeEntry entry, String ... ignoredAttrs) {
        StringBuilder sb = new StringBuilder();
        for (EStructuralFeature feature : entry.eClass().getEStructuralFeatures()) {
            Object val;
            boolean accepted = true;
            String[] stringArray = ignoredAttrs;
            int n = ignoredAttrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (feature.getName().equals(attr)) {
                    accepted = false;
                    break;
                }
                ++n2;
            }
            if (!accepted || (val = entry.eGet(feature)) == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(feature.getName()).append(": ");
            if (val instanceof Color) {
                Color col = (Color)val;
                sb.append(String.format("#%02X%02X%02X%02X", col.getAlfa(), col.getRed(), col.getGreen(), col.getBlue()));
                continue;
            }
            sb.append(val.toString());
        }
        return sb.toString();
    }
}

