/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.search.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.search.tags.parser.TagsLexer;
import org.eclipse.rcptt.core.search.tags.parser.TagsParser;

public class TagsSearch {
    private static List<RecognitionException> errors = new ArrayList<RecognitionException>();

    public static IQ7NamedElement[] findAllByExpression(String expression) {
        CommonTree tree = TagsSearch.createTree(expression);
        if (tree == null) {
            return new IQ7NamedElement[0];
        }
        ArrayList<IQ7NamedElement> result = new ArrayList<IQ7NamedElement>();
        Map tagsRefsMap = Q7SearchCore.findAllTagReferences();
        for (Map.Entry entry : tagsRefsMap.entrySet()) {
            if (!TagsSearch.eval(tree, (List)entry.getValue())) continue;
            result.add((IQ7NamedElement)entry.getKey());
        }
        return result.toArray(new IQ7NamedElement[result.size()]);
    }

    private static CommonTree createTree(String expression) {
        CommonTree ast = null;
        errors.clear();
        try {
            ANTLRStringStream input = new ANTLRStringStream(expression);
            TagsLexer lexer = new TagsLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            TagsParser parser = new TagsParser((TokenStream)tokens);
            TagsParser.expression_return ret = parser.expression();
            ast = (CommonTree)ret.getTree();
            if (lexer.hasErrors()) {
                errors.addAll(lexer.getAllErrors());
            }
            if (parser.hasErrors()) {
                errors.addAll(parser.getAllErrors());
            }
        }
        catch (RecognitionException recognitionException) {}
        return ast;
    }

    public static List<RecognitionException> getAllErrors() {
        return errors;
    }

    public static boolean isParenthesesMissed() {
        for (RecognitionException e : TagsSearch.getAllErrors()) {
            if (!(e instanceof MismatchedTokenException)) continue;
            MismatchedTokenException mte = (MismatchedTokenException)e;
            if (mte.expecting != 5 && mte.expecting != 9) continue;
            return true;
        }
        return false;
    }

    private static boolean eval(CommonTree tree, List<String> tags) {
        if (tree != null) {
            if (tree.getType() == 6) {
                return tags.contains(tree.getText());
            }
            if (tree.getType() == 7 && tree.getChildren() != null) {
                return !TagsSearch.eval((CommonTree)tree.getChild(0), tags);
            }
            if (tree.getType() == 4 && tree.getChildren() != null) {
                boolean result = true;
                for (Object subtree : tree.getChildren()) {
                    if (TagsSearch.eval((CommonTree)subtree, tags)) continue;
                    result = false;
                    break;
                }
                return result;
            }
            if (tree.getType() == 8 && tree.getChildren() != null) {
                boolean result = false;
                for (Object subtree : tree.getChildren()) {
                    if (!TagsSearch.eval((CommonTree)subtree, tags)) continue;
                    result = true;
                    break;
                }
                return result;
            }
        }
        return false;
    }

    private static void printTree(CommonTree ast) {
        TagsSearch.print(ast, 0);
    }

    private static void print(CommonTree tree, int level) {
        int i = 0;
        while (i < level) {
            System.out.print("--");
            ++i;
        }
        if (tree == null) {
            System.out.println(" null tree");
            return;
        }
        System.out.println(" " + tree.getType() + " " + tree.getText());
        if (tree.getChildren() != null) {
            for (Object ie : tree.getChildren()) {
                TagsSearch.print((CommonTree)ie, level + 1);
            }
        }
    }
}

