/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;

public class BinaryFileOutputStream
extends ByteArrayOutputStream {
    protected final IFile _file;
    private final BuildEnv _env;

    public BinaryFileOutputStream(IFile file, BuildEnv env) {
        this._file = file;
        this._env = env;
    }

    @Override
    public void close() throws IOException {
        block11: {
            super.close();
            ByteArrayInputStream contents = new ByteArrayInputStream(this.toByteArray());
            try {
                boolean contentsChanged;
                block13: {
                    contentsChanged = true;
                    if (!this._file.exists()) {
                        this.saveToDisk(contents, true);
                        break block11;
                    }
                    ByteArrayInputStream in = null;
                    BufferedInputStream oldData = null;
                    try {
                        try {
                            in = new ByteArrayInputStream(this.toByteArray());
                            oldData = new BufferedInputStream(this._file.getContents());
                            if (FileSystemUtil.compareStreams(in, oldData)) {
                                contentsChanged = false;
                            }
                        }
                        catch (CoreException coreException) {
                            contentsChanged = true;
                            this.closeInputStream(in);
                            this.closeInputStream(oldData);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        this.closeInputStream(in);
                        this.closeInputStream(oldData);
                        throw throwable;
                    }
                    this.closeInputStream(in);
                    this.closeInputStream(oldData);
                }
                if (contentsChanged) {
                    ((InputStream)contents).reset();
                    this.saveToDisk(contents, false);
                }
            }
            finally {
                this.closeInputStream(contents);
            }
        }
        IFile parentFile = this._env.getFile();
        if (parentFile != null) {
            this._env.getAptProject().getGeneratedFileManager().addGeneratedFileDependency(Collections.singleton(parentFile), this._file);
            this._env.addGeneratedNonSourceFile(this._file);
        }
    }

    private void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void saveToDisk(InputStream toSave, boolean create) throws IOException {
        block4: {
            try {
                FileSystemUtil.makeDerivedParentFolders(this._file.getParent());
                if (create) {
                    this._file.create(toSave, 1025, null);
                } else {
                    this._file.setContents(toSave, true, false, null);
                }
            }
            catch (CoreException ce) {
                if (this._file.exists()) break block4;
                AptPlugin.log(ce, "Could not create generated file");
                throw new IOException(ce.getMessage());
            }
        }
    }
}

