/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.apt.core.internal.declaration.DeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.PackageUtil;
import org.eclipse.jdt.apt.core.internal.util.SourcePositionImpl;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;

public class PackageDeclarationImpl
extends DeclarationImpl
implements PackageDeclaration {
    private final boolean _hideSourcePosition;
    private final TypeDeclarationImpl _typeDecl;
    private IPackageFragment[] _pkgFragments = null;

    public PackageDeclarationImpl(IPackageBinding binding, TypeDeclarationImpl typeDecl, BaseProcessorEnv env, boolean hideSourcePosition) {
        this(binding, typeDecl, env, hideSourcePosition, null);
    }

    public PackageDeclarationImpl(IPackageBinding binding, TypeDeclarationImpl typeDecl, BaseProcessorEnv env, boolean hideSourcePosition, IPackageFragment[] pkgFragments) {
        super((IBinding)binding, env);
        this._typeDecl = typeDecl;
        this._hideSourcePosition = hideSourcePosition;
        this._pkgFragments = pkgFragments;
    }

    public IPackageBinding getPackageBinding() {
        return (IPackageBinding)this._binding;
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitPackageDeclaration(this);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> anno) {
        return this._getAnnotation(anno, this.getPackageBinding().getAnnotations());
    }

    @Override
    public Collection<AnnotationMirror> getAnnotationMirrors() {
        return this._getAnnotationMirrors(this.getPackageBinding().getAnnotations());
    }

    @Override
    public Collection<AnnotationTypeDeclaration> getAnnotationTypes() {
        return Collections.emptyList();
    }

    @Override
    public Collection<ClassDeclaration> getClasses() {
        this.initFragments();
        List<IType> types = PackageDeclarationImpl.getTypesInPackage(this._pkgFragments);
        ArrayList<ClassDeclaration> classes = new ArrayList<ClassDeclaration>();
        for (IType type : types) {
            try {
                TypeDeclaration td;
                if (!type.isClass() || !((td = this._env.getTypeDeclaration(type)) instanceof ClassDeclaration)) continue;
                classes.add((ClassDeclaration)td);
            }
            catch (JavaModelException javaModelException) {}
        }
        return classes;
    }

    @Override
    public Collection<EnumDeclaration> getEnums() {
        this.initFragments();
        List<IType> types = PackageDeclarationImpl.getTypesInPackage(this._pkgFragments);
        ArrayList<EnumDeclaration> enums = new ArrayList<EnumDeclaration>();
        for (IType type : types) {
            try {
                if (!type.isEnum()) continue;
                enums.add((EnumDeclaration)this._env.getTypeDeclaration(type));
            }
            catch (JavaModelException javaModelException) {}
        }
        return enums;
    }

    @Override
    public Collection<InterfaceDeclaration> getInterfaces() {
        this.initFragments();
        List<IType> types = PackageDeclarationImpl.getTypesInPackage(this._pkgFragments);
        ArrayList<InterfaceDeclaration> interfaces = new ArrayList<InterfaceDeclaration>();
        for (IType type : types) {
            try {
                if (!type.isInterface()) continue;
                interfaces.add((InterfaceDeclaration)this._env.getTypeDeclaration(type));
            }
            catch (JavaModelException javaModelException) {}
        }
        return interfaces;
    }

    @Override
    public String getDocComment() {
        return null;
    }

    @Override
    public Collection<Modifier> getModifiers() {
        return Collections.emptyList();
    }

    @Override
    public SourcePosition getPosition() {
        if (this._hideSourcePosition) {
            return null;
        }
        if (this.isFromSource()) {
            CompilationUnit unit = this._typeDecl.getCompilationUnit();
            ASTNode node = unit.findDeclaringNode((IBinding)this.getDeclarationBinding());
            if (node == null) {
                return null;
            }
            int start = node.getStartPosition();
            return new SourcePositionImpl(start, node.getLength(), unit.getLineNumber(start), unit.getColumnNumber(start), this);
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getPackageBinding().getName();
    }

    @Override
    public String getSimpleName() {
        IPackageBinding pkg = this.getPackageBinding();
        String[] components = pkg.getNameComponents();
        if (components == null || components.length == 0) {
            return "";
        }
        return components[components.length - 1];
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.PACKAGE;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public IPackageBinding getDeclarationBinding() {
        return (IPackageBinding)this._binding;
    }

    @Override
    public boolean isFromSource() {
        return this._typeDecl != null && this._typeDecl.isFromSource();
    }

    private void initFragments() {
        if (this._pkgFragments == null) {
            this._pkgFragments = PackageUtil.getPackageFragments(this._binding.getName(), this._env);
        }
    }

    private static List<IType> getTypesInPackage(IPackageFragment[] fragments) {
        ArrayList<IType> types = new ArrayList<IType>();
        try {
            IPackageFragment[] iPackageFragmentArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IType type;
                IPackageFragment fragment = iPackageFragmentArray[n2];
                IClassFile[] iClassFileArray = fragment.getClassFiles();
                int n3 = iClassFileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClassFile classFile = iClassFileArray[n4];
                    type = classFile.getType();
                    if (!(type.isLocal() || type.isMember() || type.isAnonymous())) {
                        types.add(type);
                    }
                    ++n4;
                }
                iClassFileArray = fragment.getCompilationUnits();
                n3 = iClassFileArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IClassFile compUnit = iClassFileArray[n4];
                    IType[] iTypeArray = compUnit.getTypes();
                    int n5 = iTypeArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        type = iTypeArray[n6];
                        if (!(type.isLocal() || type.isMember() || type.isAnonymous())) {
                            types.add(type);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return types;
    }
}

