/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.dialogs.ShowViewDialog;

public final class ShowViewHandler
extends AbstractHandler {
    public ShowViewHandler() {
    }

    public ShowViewHandler(boolean makeFast) {
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        Shell shell = HandlerUtil.getActiveShell(event);
        IEclipseContext ctx = (IEclipseContext)workbenchWindow.getService(IEclipseContext.class);
        EModelService modelService = (EModelService)workbenchWindow.getService(EModelService.class);
        EPartService partService = (EPartService)workbenchWindow.getService(EPartService.class);
        MApplication app = (MApplication)workbenchWindow.getService(MApplication.class);
        MWindow window = (MWindow)workbenchWindow.getService(MWindow.class);
        Map parameters = event.getParameters();
        Object value = parameters.get("org.eclipse.ui.views.showView.viewId");
        if (value == null) {
            this.openOther(shell, app, window, modelService, ctx, partService);
        } else {
            try {
                this.openView((String)value, partService);
            }
            catch (PartInitException e) {
                throw new ExecutionException("Part could not be initialized", (Throwable)((Object)e));
            }
        }
        return null;
    }

    private final void openOther(Shell shell, MApplication app, MWindow window, EModelService modelService, IEclipseContext context, EPartService partService) {
        MPartDescriptor[] descriptors;
        ShowViewDialog dialog = new ShowViewDialog(shell, app, window, modelService, partService, context);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        MPartDescriptor[] mPartDescriptorArray = descriptors = dialog.getSelection();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            MPartDescriptor descriptor = mPartDescriptorArray[n2];
            partService.showPart(descriptor.getElementId(), EPartService.PartState.ACTIVATE);
            ++n2;
        }
    }

    private final void openView(String viewId, EPartService partService) throws PartInitException {
        partService.showPart(viewId, EPartService.PartState.ACTIVATE);
    }
}

