/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.descriptors;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringContribution;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.refactoring.descriptors.DescriptorMessages;
import org.eclipse.jdt.internal.core.refactoring.descriptors.JavaRefactoringDescriptorUtil;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class JavaRefactoringDescriptor
extends RefactoringDescriptor {
    protected static final String ATTRIBUTE_ELEMENT = "element";
    protected static final String ATTRIBUTE_INPUT = "input";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_REFERENCES = "references";
    protected static final String ATTRIBUTE_SELECTION = "selection";
    protected static final String ATTRIBUTE_VERSION = "version";
    public static final int JAR_MIGRATION = 65536;
    public static final int JAR_REFACTORING = 524288;
    public static final int JAR_SOURCE_ATTACHMENT = 262144;
    protected static final String VALUE_VERSION_1_0 = "1.0";
    protected final Map fArguments;

    protected static String elementToHandle(String project, IJavaElement element) {
        return JavaRefactoringDescriptorUtil.elementToHandle(project, element);
    }

    protected static IJavaElement handleToElement(String project, String handle) {
        return JavaRefactoringDescriptor.handleToElement(project, handle, true);
    }

    protected static IJavaElement handleToElement(String project, String handle, boolean check) {
        return JavaRefactoringDescriptor.handleToElement(null, project, handle, check);
    }

    protected static IJavaElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        return JavaRefactoringDescriptorUtil.handleToElement(owner, project, handle, check);
    }

    protected static IResource handleToResource(String project, String handle) {
        return JavaRefactoringDescriptorUtil.handleToResource(project, handle);
    }

    protected static String resourceToHandle(String project, IResource resource) {
        return JavaRefactoringDescriptorUtil.resourcePathToHandle(project, resource.getFullPath());
    }

    protected JavaRefactoringDescriptor(String id) {
        this(id, null, DescriptorMessages.JavaRefactoringDescriptor_not_available, null, new HashMap(), 6);
    }

    public JavaRefactoringDescriptor(String id, String project, String description, String comment, Map arguments, int flags) {
        super(id, project, description, comment, flags);
        this.fArguments = arguments;
        this.fArguments.put(ATTRIBUTE_VERSION, VALUE_VERSION_1_0);
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        Refactoring refactoring = null;
        String id = this.getID();
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)id);
        if (contribution != null) {
            if (contribution instanceof JavaRefactoringContribution) {
                JavaRefactoringContribution javaContribution = (JavaRefactoringContribution)contribution;
                refactoring = javaContribution.createRefactoring(this, status);
            } else {
                JavaManipulationPlugin.log((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 0, MessageFormat.format(DescriptorMessages.JavaRefactoringDescriptor_no_resulting_descriptor, id), null));
            }
        }
        return refactoring;
    }

    protected Map getArguments() {
        this.populateArgumentMap();
        return new HashMap(this.fArguments);
    }

    protected void populateArgumentMap() {
        RefactoringStatus status = this.validateDescriptor();
        if (status.hasFatalError()) {
            throw new RuntimeException("Validation returns a fatal error status", (Throwable)new CoreException(status.getEntryWithHighestSeverity().toStatus()));
        }
    }

    public void setComment(String comment) {
        super.setComment(comment);
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setFlags(int flags) {
        super.setFlags(flags);
    }

    public void setProject(String project) {
        super.setProject(project);
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = new RefactoringStatus();
        String description = this.getDescription();
        if (description == null || "".equals(description)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.JavaRefactoringDescriptor_no_description));
        }
        return status;
    }
}

