/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.server.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.server.tcp.SessionRequestHandler;

public class SessionManager {
    private ExecutorService executor = Executors.newCachedThreadPool();
    int count = 0;
    private boolean useJobs = false;

    public SessionManager(boolean useJobs) {
        this.useJobs = useJobs;
    }

    public void acceptNewConnection(Socket client) {
        try {
            ++this.count;
            String uuid = this.initRecover(client);
            if (uuid != null) {
                this.executor.execute(new SessionRequestHandler(client, this.useJobs));
            } else {
                client.close();
            }
        }
        catch (Throwable e) {
            CorePlugin.log((Throwable)e);
        }
    }

    private String initRecover(Socket client) throws IOException {
        InputStream stream = client.getInputStream();
        DataInputStream din = new DataInputStream(stream);
        DataOutputStream dout = new DataOutputStream(client.getOutputStream());
        String utf = din.readUTF();
        if ("newsession".equals(utf)) {
            String uuid = EcoreUtil.generateUUID();
            uuid = EcoreUtil.generateUUID();
            dout.writeUTF(uuid);
            dout.flush();
            return uuid;
        }
        return null;
    }
}

