/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.AssertTablesMatch;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.ecl.data.objects.Table;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class AssertTablesMatchService
implements ICommandService {
    private static final String SEP = ", ";

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        Table rightTable;
        AssertTablesMatch cmd = (AssertTablesMatch)command;
        boolean ignoreOrder = cmd.isIgnoreColumnOrder();
        Table leftTable = cmd.getLeft();
        if (EcoreUtil.equals((EObject)leftTable, (EObject)(rightTable = cmd.getRight()))) {
            return Status.OK_STATUS;
        }
        List<Column> leftColumns = AssertTablesMatchService.toColumns(leftTable.getColumns());
        List<Column> rightColumns = AssertTablesMatchService.toColumns(rightTable.getColumns());
        switch (cmd.getIgnoreMissingColumns()) {
            case LEFT: {
                rightColumns = AssertTablesMatchService.excludeNotPresent(rightColumns, leftColumns);
                break;
            }
            case RIGHT: {
                leftColumns = AssertTablesMatchService.excludeNotPresent(leftColumns, rightColumns);
                break;
            }
            case BOTH: {
                rightColumns = AssertTablesMatchService.excludeNotPresent(rightColumns, leftColumns);
                leftColumns = AssertTablesMatchService.excludeNotPresent(leftColumns, rightColumns);
                break;
            }
        }
        if (leftColumns.size() != rightColumns.size()) {
            return EclDataPlugin.createErr("Columns in left table(%s) don't match to columns in right table(%s)", AssertTablesMatchService.columnNames(leftColumns), AssertTablesMatchService.columnNames(rightColumns));
        }
        if (!ignoreOrder) {
            int i = 0;
            while (i < leftColumns.size()) {
                if (!rightColumns.get((int)i).name.equals(leftColumns.get((int)i).name)) {
                    return EclDataPlugin.createErr("Different columns at position %d: left table has '%s', while right column has '%s'", i, leftColumns.get((int)i).name, rightColumns.get((int)i).name);
                }
                ++i;
            }
        } else {
            ArrayList<Column> tmp = new ArrayList<Column>();
            for (Column left : leftColumns) {
                Column right = AssertTablesMatchService.findColumn(rightColumns, left.name);
                if (right == null) {
                    return EclDataPlugin.createErr("Unmatched column '%s' in left table", left.name);
                }
                tmp.add(right);
                rightColumns.remove(right);
            }
            rightColumns = tmp;
        }
        return AssertTablesMatchService.rowsMatch(leftColumns, rightColumns, leftTable.getRows(), rightTable.getRows(), new Position());
    }

    private static IStatus rowsMatch(List<Column> leftColumns, List<Column> rightColumns, List<Row> leftRows, List<Row> rightRows, Position pos) {
        if (leftRows.size() != rightRows.size()) {
            return EclDataPlugin.createErr("Child row count differ, %s", pos.toString());
        }
        int row = 0;
        while (row < leftRows.size()) {
            Row leftRow = leftRows.get(row);
            Row rightRow = rightRows.get(row);
            int col = 0;
            while (col < leftColumns.size()) {
                String rv;
                Column lc = leftColumns.get(col);
                Column rc = rightColumns.get(col);
                String lv = (String)leftRow.getValues().get(lc.index);
                if (!lv.equals(rv = (String)rightRow.getValues().get(rc.index))) {
                    return EclDataPlugin.createErr("Tables differ at column '%s', %s: left value is '%s', right value is '%s'", lc.name, pos.toString(), lv, rv);
                }
                ++col;
            }
            pos.goIn();
            IStatus childResult = AssertTablesMatchService.rowsMatch(leftColumns, rightColumns, leftRow.getChildren(), rightRow.getChildren(), pos);
            if (!childResult.isOK()) {
                return childResult;
            }
            pos.goOut();
            pos.nextSibling();
            ++row;
        }
        return Status.OK_STATUS;
    }

    private static List<Column> toColumns(List<String> columnNames) {
        ArrayList<Column> result = new ArrayList<Column>();
        int i = 0;
        while (i < columnNames.size()) {
            result.add(new Column(columnNames.get(i), i));
            ++i;
        }
        return result;
    }

    private static final List<Column> excludeNotPresent(List<Column> from, List<Column> where) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : from) {
            if (!AssertTablesMatchService.containsName(where, column.name)) continue;
            result.add(column);
        }
        return result;
    }

    private static final String columnNames(List<Column> columns) {
        if (columns.isEmpty()) {
            return "<no columns>";
        }
        StringBuilder sb = new StringBuilder();
        for (Column column : columns) {
            sb.append(column.name).append(SEP);
        }
        sb.setLength(sb.length() - SEP.length());
        return sb.toString();
    }

    private static final boolean containsName(List<Column> columns, String name) {
        return AssertTablesMatchService.findColumn(columns, name) != null;
    }

    private static final Column findColumn(List<Column> columns, String name) {
        for (Column column : columns) {
            if (!column.name.equals(name)) continue;
            return column;
        }
        return null;
    }

    private static class Column {
        public final String name;
        public final int index;

        public Column(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }

    private static class Position {
        private int absoluteIndex = 0;
        private int currentIndex = 0;
        private List<Integer> indexPath = new ArrayList<Integer>();

        private Position() {
        }

        public void nextSibling() {
            ++this.currentIndex;
        }

        public void goIn() {
            this.indexPath.add(this.currentIndex);
            this.currentIndex = 0;
        }

        public void goOut() {
            this.currentIndex = this.indexPath.get(this.indexPath.size() - 1);
            this.indexPath.remove(this.indexPath.size() - 1);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int index : this.indexPath) {
                sb.append(index).append("/");
            }
            sb.append(this.currentIndex);
            return String.format("absolute row index '%d' (path in tree - '%s')", this.absoluteIndex, sb.toString());
        }
    }
}

