/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.debug.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.IMarkeredPipe;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;

public abstract class Session
extends Job {
    private final Socket socket;
    private IMarkeredPipe pipe;
    private volatile boolean terminated = false;

    public Session(Socket socket) throws CoreException {
        super("Event Dispatch");
        this.setSystem(true);
        this.socket = socket;
        try {
            this.pipe = CoreUtils.createEMFPipe((InputStream)socket.getInputStream(), (OutputStream)socket.getOutputStream());
        }
        catch (IOException e) {
            throw new CoreException(CorePlugin.err((String)e.getMessage(), (Throwable)e));
        }
        this.schedule();
    }

    public void request(EObject event) throws CoreException {
        this.pipe.write((Object)event);
    }

    public void terminate() {
        this.terminated = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
    }

    protected abstract void handle(EObject var1);

    protected abstract void handle(Exception var1);

    protected IStatus run(IProgressMonitor monitor) {
        block5: {
            try {
                while (!this.pipe.isClosed()) {
                    Object take = this.pipe.take(60000L);
                    if (take instanceof IStatus) {
                        return Status.OK_STATUS;
                    }
                    if (this.pipe.isClosed()) {
                        return Status.OK_STATUS;
                    }
                    if (!(take instanceof EObject)) continue;
                    this.handle((EObject)take);
                }
            }
            catch (Exception e) {
                if (this.terminated) break block5;
                this.handle(e);
            }
        }
        return Status.OK_STATUS;
    }
}

