/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.MementoUpdate;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IMemento;

public class ElementCompareRequest
extends MementoUpdate
implements IElementCompareRequest {
    private boolean fEqual;
    private final int fModelIndex;
    private ModelDelta fDelta;
    private boolean fKnowsHasChildren;
    private boolean fKnowsChildCount;
    private boolean fCheckChildrenRealized;

    public ElementCompareRequest(TreeModelContentProvider provider, Object viewerInput, Object element, TreePath elementPath, IMemento memento, ModelDelta delta, int modelIndex, boolean knowsHasChildren, boolean knowsChildCount, boolean checkChildrenRealized) {
        super(provider, viewerInput, provider.getPresentationContext(), element, elementPath, memento);
        this.fProvider = provider;
        this.fDelta = delta;
        this.fModelIndex = modelIndex;
        this.fKnowsHasChildren = knowsHasChildren;
        this.fKnowsChildCount = knowsChildCount;
        this.fCheckChildrenRealized = checkChildrenRealized;
    }

    @Override
    public void setEqual(boolean equal) {
        this.fEqual = equal;
    }

    public void done() {
        IInternalTreeModelViewer viewer = this.getContentProvider().getViewer();
        if (viewer == null) {
            return;
        }
        if (viewer.getDisplay().getThread() == Thread.currentThread()) {
            this.fProvider.getStateTracker().compareFinished(this, this.fDelta);
        } else {
            viewer.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ElementCompareRequest.this.getContentProvider().isDisposed()) {
                        return;
                    }
                    ElementCompareRequest.this.fProvider.getStateTracker().compareFinished(ElementCompareRequest.this, ElementCompareRequest.this.fDelta);
                }
            });
        }
    }

    public boolean isEqual() {
        return this.fEqual;
    }

    ModelDelta getDelta() {
        return this.fDelta;
    }

    int getModelIndex() {
        return this.fModelIndex;
    }

    void setKnowsHasChildren(boolean hasChildren) {
        this.fKnowsHasChildren = hasChildren;
    }

    boolean knowsHasChildren() {
        return this.fKnowsHasChildren;
    }

    void setKnowsChildCount(boolean childCount) {
        this.fKnowsChildCount = childCount;
    }

    boolean knowChildCount() {
        return this.fKnowsChildCount;
    }

    void setCheckChildrenRealized(boolean checkChildrenRealized) {
        this.fCheckChildrenRealized = checkChildrenRealized;
    }

    boolean checkChildrenRealized() {
        return this.fCheckChildrenRealized;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IElementCompareRequest: ");
        buf.append(this.getElement());
        return buf.toString();
    }
}

