/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfo;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;

public class Q7WaitUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateInfo(String kind, String className, Q7WaitInfoRoot info) {
        if (info == null || className == null) {
            return;
        }
        Q7WaitInfoRoot q7WaitInfoRoot = info;
        synchronized (q7WaitInfoRoot) {
            String methodValue;
            int pos = className.indexOf("$");
            if (pos != -1 && (methodValue = (String)info.getInnerClassMap().get((Object)className)) == null) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String clName = className.substring(0, pos);
                int i1 = 0;
                while (i1 < stackTrace.length) {
                    if (stackTrace[i1].getClassName().startsWith(clName)) {
                        methodValue = String.valueOf(stackTrace[i1].getMethodName()) + ":" + stackTrace[i1].getLineNumber();
                        break;
                    }
                    if (stackTrace[i1].getClassName().equals("org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer") && stackTrace[i1].getMethodName().equals("exec")) {
                        methodValue = String.valueOf(stackTrace[i1 + 1].getMethodName()) + ":" + stackTrace[i1 + 1].getLineNumber();
                        break;
                    }
                    ++i1;
                }
                if (methodValue != null) {
                    info.getInnerClassMap().put((Object)className, (Object)methodValue);
                }
            }
            int classId = Q7WaitUtils.getID(className, info.getClassNames());
            int typeId = Q7WaitUtils.getID(kind, info.getTypesNames());
            long currentTime = System.currentTimeMillis();
            long currentTick = info.getTick();
            if (classId != -1 && typeId != -1) {
                EList<Q7WaitInfo> infos = info.getInfos();
                for (Q7WaitInfo i : infos) {
                    long lastTick;
                    if (i.getTypeId() != typeId || i.getClassId() != classId || (lastTick = i.getLastTick()) != currentTick && lastTick != currentTick - 1L && i.getEndTime() != currentTime) continue;
                    i.setEndTime(currentTime);
                    i.setLastTick(currentTick);
                    if (lastTick != currentTick) {
                        i.setTicks(i.getTicks() + 1L);
                    }
                    return;
                }
            }
            if (classId == -1) {
                classId = info.getClassNames().size();
                info.getClassNames().add((Object)className);
            }
            if (typeId == -1) {
                typeId = info.getTypesNames().size();
                info.getTypesNames().add((Object)kind);
            }
            Q7WaitInfo i = InfoFactory.eINSTANCE.createQ7WaitInfo();
            info.getInfos().add((Object)i);
            i.setTypeId(typeId);
            i.setClassId(classId);
            i.setStartTime(currentTime);
            i.setTicks(1L);
            i.setLastTick(currentTick);
            i.setEndTime(i.getStartTime());
        }
    }

    private static int getID(String kind, List<String> values) {
        int i = 0;
        while (i < values.size()) {
            String typeName = values.get(i);
            if (typeName.equals(kind)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

