/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleCollection;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.FilePathEditor;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorActionGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.preferences.PreferenceConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.EditableListWidget;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.IEditableListListener;
import org.eclipse.mylyn.reviews.userSearch.query.IQueryUser;
import org.eclipse.mylyn.reviews.userSearch.query.QueryUserFactory;
import org.eclipse.mylyn.reviews.userSearch.userInfo.IUserInfo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IEditableListListener {
    private static final int PREFS_CONTAINER_DATA_SPAN = 1;
    private static final int GROUP_PREFS_CONTAINER_DATA_SPAN = 4;
    private static final String INVALID_FILE_STR = "<File not found>";
    private static final String PARTICIPANTS_LISTS_LABEL = "Participants Lists: ";
    private static final String GROUP_VALIDATION_STR = ".*_group_root.xrer";
    private static final String GROUP_VALIDATION_ERROR_DIALOG_TITLE = "Invalid Review Group file";
    private static final String GROUP_VALIDATION_ERROR_DIALOG_MSG = "File is not a valid Review Group file";
    private static final String RULESET_VALIDATION_STR = ".*_rule_set.xrer";
    private static final String RULESET_VALIDATION_ERROR_DIALOG_TITLE = "Invalid Rule Set file";
    private static final String RULESET_VALIDATION_ERROR_DIALOG_MSG = "File is not a valid Rule Set file";
    private TabFolder fR4EPrefsTabFolder = null;
    private TabItem fUserPrefsTab = null;
    private TabItem fGroupsPrefsTab = null;
    private TabItem fRuleSetsPrefsTab = null;
    private TabItem fFiltersPrefsTab = null;
    private Text fUserIdTextField = null;
    private Text fUserEmailTextField = null;
    private Button fUseDeltasButton = null;
    private Button fImportPostponedGlobalAnomaliesButton = null;
    private Button fSendNotificationToSenderButton = null;
    private Composite fR4EGroupPrefsGroup = null;
    private FilePathEditor fGroupFilesEditor = null;
    private Text fGroupNameText = null;
    private Text fGroupDescriptionText = null;
    private Composite fR4ERuleSetPrefsGroup = null;
    private FilePathEditor fRuleSetFilesEditor = null;
    private Text fRuleSetNameText = null;
    private Text fRuleSetVersionText = null;
    private Button fReviewShowDisabledButton = null;
    private Button fReviewsCompletedFilterButton = null;
    private Button fReviewsOnlyFilterButton = null;
    private Button fAnomaliesMyFilterButton = null;
    private Button fReviewMyFilterButton = null;
    private Button fParticipantFilterButton = null;
    private Button fAssignMyFilterButton = null;
    private Button fAssignFilterButton = null;
    private Button fUnassignFilterButton = null;
    private Button fAnomaliesFilterButton = null;
    private Button fReviewedItemsFilterButton = null;
    private Button fHideRuleSetsFilterButton = null;
    private Button fHideDeltasFilterButton = null;
    private Text fParticipantIdText = null;
    private Text fAssignIdText = null;
    private EditableListWidget fParticipantsLists;
    private EditableListWidget fParticipantsList;
    private static final Map<String, List<String>> FParticipantsListsHashMap = new HashMap<String, List<String>>();

    public R4EPreferencePage() {
        super(1);
        this.setPreferenceStore(R4EUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("R4E Global Preferences");
        R4EPreferencePage.populateParticipantListMap();
    }

    public void createFieldEditors() {
        R4EUIPlugin.Ftracer.traceInfo("Build R4E Preference page");
        Composite prefsContainer = new Composite(this.getFieldEditorParent(), 0);
        GridData prefsContainerData = new GridData(4, 4, true, true);
        prefsContainerData.horizontalSpan = 1;
        prefsContainer.setLayoutData((Object)prefsContainerData);
        GridLayout prefsLayout = new GridLayout(1, false);
        prefsContainer.setLayout((Layout)prefsLayout);
        this.fR4EPrefsTabFolder = new TabFolder(prefsContainer, 128);
        GridData tabFolderData = new GridData(4, 4, true, true);
        this.fR4EPrefsTabFolder.setLayoutData((Object)tabFolderData);
        this.createUserPreferencesTab(this.fR4EPrefsTabFolder);
        this.createGroupPreferencesTab(this.fR4EPrefsTabFolder);
        this.createRuleSetsPreferencesTab(this.fR4EPrefsTabFolder);
        this.createFiltersPreferencesTab(this.fR4EPrefsTabFolder);
    }

    private void createUserPreferencesTab(TabFolder aParent) {
        final IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
        this.fUserPrefsTab = new TabItem(aParent, 0);
        this.fUserPrefsTab.setText("User");
        Composite r4EUserPrefsGroup = new Composite((Composite)aParent, 0);
        this.fUserPrefsTab.setControl((Control)r4EUserPrefsGroup);
        GridData r4eUserPrefsGroupData = new GridData(4, 4, true, true);
        r4eUserPrefsGroupData.horizontalSpan = 4;
        r4EUserPrefsGroup.setLayoutData((Object)r4eUserPrefsGroupData);
        r4EUserPrefsGroup.setLayout((Layout)new GridLayout(4, false));
        Label r4EUserPrefsSpacer = new Label(r4EUserPrefsGroup, 4);
        GridData r4EUserPrefsSpacerData = new GridData(4, 4, true, false);
        r4EUserPrefsSpacerData.horizontalSpan = 4;
        r4EUserPrefsSpacer.setLayoutData((Object)r4EUserPrefsSpacerData);
        Label userIdLabel = new Label(r4EUserPrefsGroup, 4);
        GridData userIdLabelData = new GridData(1, 4, false, false);
        userIdLabelData.horizontalSpan = 1;
        userIdLabel.setText("User ID:");
        userIdLabel.setLayoutData((Object)userIdLabelData);
        this.fUserIdTextField = new Text(r4EUserPrefsGroup, 2052);
        GridData userIdTextData = new GridData(4, 4, true, false);
        userIdTextData.horizontalSpan = 3;
        if (R4EUIModelController.isJobInProgress()) {
            this.fUserIdTextField.setEnabled(false);
            this.fUserIdTextField.setEditable(false);
        } else {
            this.fUserIdTextField.setEnabled(true);
            this.fUserIdTextField.setEditable(true);
        }
        this.fUserIdTextField.setLayoutData((Object)userIdTextData);
        this.fUserIdTextField.setText(store.getString("userIdPreference"));
        this.fUserIdTextField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                R4EPreferencePage.this.fUserEmailTextField.setText("");
                if (R4EUIModelController.isUserQueryAvailable() && R4EPreferencePage.this.fUserIdTextField.getText().length() > 0) {
                    R4EPreferencePage.this.fUserIdTextField.setText(R4EPreferencePage.this.fUserIdTextField.getText().toLowerCase());
                    R4EPreferencePage.this.getShell().setCursor(R4EPreferencePage.this.getShell().getDisplay().getSystemCursor(1));
                    IQueryUser query = new QueryUserFactory().getInstance();
                    try {
                        try {
                            ArrayList users = query.searchByUserId(R4EPreferencePage.this.fUserIdTextField.getText());
                            for (IUserInfo user : users) {
                                if (!user.getUserId().toLowerCase().equals(R4EPreferencePage.this.fUserIdTextField.getText())) continue;
                                R4EPreferencePage.this.fUserEmailTextField.setText(user.getEmail());
                                break;
                            }
                        }
                        catch (NamingException ex) {
                            R4EUIPlugin.Ftracer.traceError("Exception: " + ex.toString() + " (" + ex.getMessage() + ")");
                            R4EUIPlugin.getDefault().logError("Exception: " + ex.toString(), ex);
                            R4EPreferencePage.this.getShell().setCursor(R4EPreferencePage.this.getShell().getDisplay().getSystemCursor(0));
                        }
                        catch (IOException ex) {
                            R4EUIPlugin.getDefault().logWarning("Exception: " + ex.toString(), ex);
                            R4EPreferencePage.this.getShell().setCursor(R4EPreferencePage.this.getShell().getDisplay().getSystemCursor(0));
                        }
                    }
                    finally {
                        R4EPreferencePage.this.getShell().setCursor(R4EPreferencePage.this.getShell().getDisplay().getSystemCursor(0));
                    }
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Label userEmailLabel = new Label(r4EUserPrefsGroup, 4);
        GridData userEmailLabelData = new GridData(1, 4, false, false);
        userEmailLabelData.horizontalSpan = 1;
        userEmailLabel.setText("User Email:");
        userEmailLabel.setLayoutData((Object)userEmailLabelData);
        this.fUserEmailTextField = new Text(r4EUserPrefsGroup, 2052);
        GridData userEmailTextData = new GridData(4, 4, true, false);
        userEmailTextData.horizontalSpan = 3;
        if (R4EUIModelController.isJobInProgress()) {
            this.fUserEmailTextField.setEnabled(false);
            this.fUserEmailTextField.setEditable(false);
        } else {
            this.fUserEmailTextField.setEnabled(true);
            this.fUserEmailTextField.setEditable(true);
        }
        this.fUserEmailTextField.setLayoutData((Object)userEmailTextData);
        this.fUserEmailTextField.setText(store.getString("userEmailPreference"));
        this.fUserEmailTextField.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                String newValue = R4EPreferencePage.this.fUserEmailTextField.getText().trim();
                if (!CommandUtils.isEmailValid(newValue)) {
                    R4EPreferencePage.this.fUserEmailTextField.setText(store.getString("userEmailPreference"));
                }
            }
        });
        Label label = new Label(r4EUserPrefsGroup, 0);
        label.setText(PARTICIPANTS_LISTS_LABEL);
        label.setToolTipText("Participants Lists.  Participants Lists are a bundle of users that can be added at once to the reviews");
        GridData participantsListsLabelGridData = new GridData(1, 1, false, false);
        participantsListsLabelGridData.horizontalSpan = 1;
        label.setLayoutData((Object)participantsListsLabelGridData);
        GridData participantsListsGridData = new GridData(4, 4, true, false);
        participantsListsGridData.horizontalSpan = 3;
        this.fParticipantsLists = new EditableListWidget(null, r4EUserPrefsGroup, participantsListsGridData, this, 0, Text.class, null);
        this.fParticipantsLists.setToolTipText("Participants Lists.  Participants Lists are a bundle of users that can be added at once to the reviews");
        String[] participantsListsStr = store.getString("participantsLists").split(";");
        this.fParticipantsLists.removeAll();
        Item item = null;
        String participantsListStr = null;
        int i = 0;
        while (i < participantsListsStr.length) {
            participantsListStr = participantsListsStr[i];
            if (participantsListStr != null && !"".equals(participantsListStr)) {
                if (i >= this.fParticipantsLists.getItemCount()) {
                    item = this.fParticipantsLists.addItem();
                } else {
                    item = this.fParticipantsLists.getItem(i);
                    if (item == null) {
                        item = this.fParticipantsLists.addItem();
                    }
                }
                item.setText(participantsListStr);
            }
            ++i;
        }
        this.fParticipantsLists.updateButtons();
        label = new Label(r4EUserPrefsGroup, 0);
        label.setText("Participants");
        label.setToolTipText("Users that are part of the selected Participants List.");
        GridData participantsLabelGridData = new GridData(1, 1, false, true);
        participantsLabelGridData.horizontalSpan = 1;
        label.setLayoutData((Object)participantsLabelGridData);
        GridData participantsGridData = new GridData(4, 4, true, true);
        participantsGridData.horizontalSpan = 3;
        this.fParticipantsList = new EditableListWidget(null, r4EUserPrefsGroup, participantsGridData, this, 1, Label.class, null);
        this.fParticipantsList.setToolTipText("Users that are part of the selected Participants List.");
        this.fParticipantsList.removeAll();
        this.fParticipantsList.updateTable();
        this.fParticipantsList.setEnabled(false);
        GridData filtersButtonData = new GridData(4, 4, true, false);
        filtersButtonData.horizontalSpan = 4;
        this.fUseDeltasButton = new Button(r4EUserPrefsGroup, 32);
        this.fUseDeltasButton.setText("Create Delta Elements to track changes for Version-Controlled Review Items");
        this.fUseDeltasButton.setLayoutData((Object)filtersButtonData);
        this.fUseDeltasButton.setSelection(store.getBoolean("useDeltasPreferences"));
        this.fImportPostponedGlobalAnomaliesButton = new Button(r4EUserPrefsGroup, 32);
        this.fImportPostponedGlobalAnomaliesButton.setText("Import Postponed Global Anomalies ");
        this.fImportPostponedGlobalAnomaliesButton.setLayoutData((Object)filtersButtonData);
        this.fImportPostponedGlobalAnomaliesButton.setSelection(store.getBoolean("importPostponedGlobalAnomaliesPreferences"));
        this.fSendNotificationToSenderButton = new Button(r4EUserPrefsGroup, 32);
        this.fSendNotificationToSenderButton.setText("Include sender in e-mail notifications");
        this.fSendNotificationToSenderButton.setLayoutData((Object)filtersButtonData);
        this.fSendNotificationToSenderButton.setSelection(store.getBoolean("SendNotificationToSenderPreferences"));
    }

    private void createGroupPreferencesTab(TabFolder aParent) {
        this.fGroupsPrefsTab = new TabItem(aParent, 0);
        this.fGroupsPrefsTab.setText("Review Groups");
        this.fR4EGroupPrefsGroup = new Composite((Composite)aParent, 0);
        this.fGroupsPrefsTab.setControl((Control)this.fR4EGroupPrefsGroup);
        GridData r4EGroupPrefsGroupData = new GridData(4, 4, true, true);
        r4EGroupPrefsGroupData.horizontalSpan = 4;
        this.fR4EGroupPrefsGroup.setLayoutData((Object)r4EGroupPrefsGroupData);
        this.fR4EGroupPrefsGroup.setLayout((Layout)new GridLayout(4, false));
        Label r4EGroupPrefsSpacer = new Label(this.fR4EGroupPrefsGroup, 4);
        GridData r4EGroupPrefsSpacerData = new GridData(4, 4, true, false);
        r4EGroupPrefsSpacerData.horizontalSpan = 4;
        r4EGroupPrefsSpacer.setLayoutData((Object)r4EGroupPrefsSpacerData);
        String filter = Platform.getOS().equals("macosx") ? "*.xrer" : "*_group_root.xrer";
        String[] extensions = new String[]{filter};
        this.fGroupFilesEditor = new FilePathEditor("groupFilePathPreference", "Review Group Files:", extensions, this.fR4EGroupPrefsGroup, GROUP_VALIDATION_STR, GROUP_VALIDATION_ERROR_DIALOG_TITLE, GROUP_VALIDATION_ERROR_DIALOG_MSG);
        this.addField((FieldEditor)this.fGroupFilesEditor);
        if (R4EUIModelController.isJobInProgress()) {
            this.fGroupFilesEditor.setEnabled(false, this.fR4EGroupPrefsGroup);
        } else {
            this.fGroupFilesEditor.setEnabled(true, this.fR4EGroupPrefsGroup);
        }
        org.eclipse.swt.widgets.List filesList = this.fGroupFilesEditor.getListControl(this.fR4EGroupPrefsGroup);
        filesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent aEvent) {
                String selectedGroupFile = R4EPreferencePage.this.fGroupFilesEditor.getSelection();
                R4EPreferencePage.this.fGroupNameText.setText("");
                R4EPreferencePage.this.fGroupDescriptionText.setText("");
                try {
                    R4EReviewGroup group = R4EUIModelController.peekReviewGroup(selectedGroupFile);
                    if (group != null) {
                        R4EPreferencePage.this.fGroupNameText.setText(group.getName());
                        R4EPreferencePage.this.fGroupDescriptionText.setText(group.getDescription());
                        R4EUIModelController.FModelExt.closeR4EReviewGroup(group);
                    } else {
                        R4EPreferencePage.this.fGroupNameText.setText(R4EPreferencePage.INVALID_FILE_STR);
                    }
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), (Exception)((Object)e));
                    R4EPreferencePage.this.fGroupDescriptionText.setText("<Error:  Resource Error>");
                }
                catch (CompatibilityException e) {
                    R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), (Exception)((Object)e));
                    R4EPreferencePage.this.fGroupDescriptionText.setText("<Error:  Version Mismatch>");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite groupDetailsContainer = new Composite(this.fR4EGroupPrefsGroup, 0);
        GridData groupDetailsLayoutData = new GridData(4, 4, false, false);
        groupDetailsContainer.setLayoutData((Object)groupDetailsLayoutData);
        groupDetailsContainer.setLayout((Layout)new GridLayout(4, false));
        Label groupNameLabel = new Label(groupDetailsContainer, 4);
        GridData groupNameLabelData = new GridData(4, 4, false, false);
        groupNameLabel.setText("Name: ");
        groupNameLabel.setLayoutData((Object)groupNameLabelData);
        this.fGroupNameText = new Text(groupDetailsContainer, 4);
        GridData groupNameTextData = new GridData(4, 4, true, false);
        groupNameTextData.horizontalSpan = 3;
        this.fGroupNameText.setEnabled(true);
        this.fGroupNameText.setEditable(false);
        this.fGroupNameText.setLayoutData((Object)groupNameTextData);
        Label groupDescriptionLabel = new Label(groupDetailsContainer, 0);
        GridData groupDescriptionLabelData = new GridData(4, 4, false, false);
        groupDescriptionLabel.setText("Description: ");
        groupDescriptionLabel.setLayoutData((Object)groupDescriptionLabelData);
        this.fGroupDescriptionText = new Text(groupDetailsContainer, 0);
        GridData groupDescriptionTextData = new GridData(4, 4, true, false);
        groupDescriptionTextData.horizontalSpan = 3;
        this.fGroupDescriptionText.setEnabled(true);
        this.fGroupDescriptionText.setEditable(false);
        this.fGroupDescriptionText.setLayoutData((Object)groupDescriptionTextData);
    }

    private void createRuleSetsPreferencesTab(TabFolder aParent) {
        this.fRuleSetsPrefsTab = new TabItem(aParent, 0);
        this.fRuleSetsPrefsTab.setText("Rule Sets");
        this.fR4ERuleSetPrefsGroup = new Composite((Composite)aParent, 0);
        this.fRuleSetsPrefsTab.setControl((Control)this.fR4ERuleSetPrefsGroup);
        GridData r4ERuleSetPrefsGroupData = new GridData(4, 4, true, true);
        r4ERuleSetPrefsGroupData.horizontalSpan = 4;
        this.fR4ERuleSetPrefsGroup.setLayoutData((Object)r4ERuleSetPrefsGroupData);
        this.fR4ERuleSetPrefsGroup.setLayout((Layout)new GridLayout(4, false));
        Label r4ERuleSetPrefsSpacer = new Label(this.fR4ERuleSetPrefsGroup, 4);
        GridData r4ERuleSetPrefsSpacerData = new GridData(4, 4, true, false);
        r4ERuleSetPrefsSpacerData.horizontalSpan = 4;
        r4ERuleSetPrefsSpacer.setLayoutData((Object)r4ERuleSetPrefsSpacerData);
        String filter = Platform.getOS().equals("macosx") ? "*.xrer" : "*_rule_set.xrer";
        String[] ruleSetsExtensions = new String[]{filter};
        this.fRuleSetFilesEditor = new FilePathEditor("ruleSetFilePathPreference", "Rule Set Files:", ruleSetsExtensions, this.fR4ERuleSetPrefsGroup, RULESET_VALIDATION_STR, RULESET_VALIDATION_ERROR_DIALOG_TITLE, RULESET_VALIDATION_ERROR_DIALOG_MSG);
        this.addField((FieldEditor)this.fRuleSetFilesEditor);
        if (R4EUIModelController.isJobInProgress()) {
            this.fRuleSetFilesEditor.setEnabled(false, this.fR4ERuleSetPrefsGroup);
        } else {
            this.fRuleSetFilesEditor.setEnabled(true, this.fR4ERuleSetPrefsGroup);
        }
        org.eclipse.swt.widgets.List ruleSetfilesList = this.fRuleSetFilesEditor.getListControl(this.fR4ERuleSetPrefsGroup);
        ruleSetfilesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent aEvent) {
                String selectedRuleSetFile = R4EPreferencePage.this.fRuleSetFilesEditor.getSelection();
                R4EPreferencePage.this.fRuleSetNameText.setText("");
                R4EPreferencePage.this.fRuleSetVersionText.setText("");
                try {
                    R4EDesignRuleCollection ruleSet = R4EUIModelController.peekRuleSet(selectedRuleSetFile);
                    if (ruleSet != null) {
                        R4EPreferencePage.this.fRuleSetNameText.setText(ruleSet.getName());
                        R4EPreferencePage.this.fRuleSetVersionText.setText(ruleSet.getVersion());
                        R4EUIModelController.FModelExt.closeR4EDesignRuleCollection(ruleSet);
                    } else {
                        R4EPreferencePage.this.fRuleSetNameText.setText(R4EPreferencePage.INVALID_FILE_STR);
                    }
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), (Exception)((Object)e));
                    R4EPreferencePage.this.fRuleSetVersionText.setText("<Error:  Resource Error>");
                }
                catch (CompatibilityException e) {
                    R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), (Exception)((Object)e));
                    R4EPreferencePage.this.fRuleSetVersionText.setText("<Error:  Version Mismatch>");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite ruleSetDetailsContainer = new Composite(this.fR4ERuleSetPrefsGroup, 0);
        GridData ruleSetDetailsLayoutData = new GridData(4, 4, false, false);
        ruleSetDetailsContainer.setLayoutData((Object)ruleSetDetailsLayoutData);
        ruleSetDetailsContainer.setLayout((Layout)new GridLayout(4, false));
        Label ruleSetNameLabel = new Label(ruleSetDetailsContainer, 4);
        GridData ruleSetNameLabelData = new GridData(4, 4, false, false);
        ruleSetNameLabel.setText("Name: ");
        ruleSetNameLabel.setLayoutData((Object)ruleSetNameLabelData);
        this.fRuleSetNameText = new Text(ruleSetDetailsContainer, 4);
        GridData ruleSetNameTextData = new GridData(4, 4, true, false);
        ruleSetNameTextData.horizontalSpan = 3;
        this.fRuleSetNameText.setEnabled(true);
        this.fRuleSetNameText.setEditable(false);
        this.fRuleSetNameText.setLayoutData((Object)ruleSetNameTextData);
        Label ruleSetVersionLabel = new Label(ruleSetDetailsContainer, 0);
        GridData ruleSetVersionLabelData = new GridData(4, 4, false, false);
        ruleSetVersionLabel.setText("Version: ");
        ruleSetVersionLabel.setLayoutData((Object)ruleSetVersionLabelData);
        this.fRuleSetVersionText = new Text(ruleSetDetailsContainer, 0);
        GridData ruleSetVersionTextData = new GridData(4, 4, true, false);
        ruleSetVersionTextData.horizontalSpan = 3;
        this.fRuleSetVersionText.setEnabled(true);
        this.fRuleSetVersionText.setEditable(false);
        this.fRuleSetVersionText.setLayoutData((Object)ruleSetVersionTextData);
    }

    private void createFiltersPreferencesTab(TabFolder aParent) {
        this.fFiltersPrefsTab = new TabItem(aParent, 0);
        this.fFiltersPrefsTab.setText("Default Filters");
        Composite r4EFilterPrefsGroup = new Composite((Composite)aParent, 0);
        this.fFiltersPrefsTab.setControl((Control)r4EFilterPrefsGroup);
        GridData r4EFilterPrefsGroupData = new GridData(4, 4, true, true);
        r4EFilterPrefsGroupData.horizontalSpan = 4;
        r4EFilterPrefsGroup.setLayoutData((Object)r4EFilterPrefsGroupData);
        r4EFilterPrefsGroup.setLayout((Layout)new GridLayout(4, false));
        Label r4ERuleSetPrefsSpacer = new Label(r4EFilterPrefsGroup, 4);
        GridData r4ERuleSetPrefsSpacerData = new GridData(4, 4, true, false);
        r4ERuleSetPrefsSpacerData.horizontalSpan = 4;
        r4ERuleSetPrefsSpacer.setLayoutData((Object)r4ERuleSetPrefsSpacerData);
        GridData filtersButtonData = new GridData(4, 4, true, false);
        filtersButtonData.horizontalSpan = 4;
        IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
        this.fReviewShowDisabledButton = new Button(r4EFilterPrefsGroup, 32);
        this.fReviewShowDisabledButton.setText("Show Disabled Elements");
        this.fReviewShowDisabledButton.setLayoutData((Object)filtersButtonData);
        this.fReviewShowDisabledButton.setSelection(store.getBoolean("showDisabled"));
        if (R4EUIModelController.getNavigatorView() != null && R4EUIModelController.getNavigatorView().isDefaultDisplay()) {
            this.fReviewShowDisabledButton.setEnabled(true);
        } else {
            this.fReviewShowDisabledButton.setEnabled(false);
        }
        this.fReviewsCompletedFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fReviewsCompletedFilterButton.setText("Hide Completed Reviews");
        this.fReviewsCompletedFilterButton.setLayoutData((Object)filtersButtonData);
        this.fReviewsCompletedFilterButton.setSelection(store.getBoolean("reviewsCompletedFilter"));
        this.fReviewsOnlyFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fReviewsOnlyFilterButton.setText("Show Reviews Only");
        this.fReviewsOnlyFilterButton.setLayoutData((Object)filtersButtonData);
        this.fReviewsOnlyFilterButton.setSelection(store.getBoolean("reviewsOnlyFilter"));
        this.fReviewMyFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fReviewMyFilterButton.setText("Show My Reviews");
        this.fReviewMyFilterButton.setLayoutData((Object)filtersButtonData);
        this.fReviewMyFilterButton.setSelection(store.getBoolean("reviewsMyFilter"));
        this.fParticipantFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fParticipantFilterButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fParticipantFilterButton.setText("Show Reviews for Participant... ");
        this.fParticipantIdText = new Text(r4EFilterPrefsGroup, 2048);
        this.fParticipantIdText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (store.getString("participantFilter").equals("")) {
            this.fParticipantFilterButton.setSelection(false);
            this.fParticipantFilterButton.setEnabled(false);
            this.fParticipantIdText.setText("");
        } else {
            this.fParticipantFilterButton.setSelection(true);
            this.fParticipantIdText.setText(store.getString("participantFilter"));
        }
        this.fParticipantIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (R4EPreferencePage.this.fParticipantIdText.getCharCount() > 0) {
                    R4EPreferencePage.this.fParticipantFilterButton.setEnabled(true);
                } else {
                    R4EPreferencePage.this.fParticipantFilterButton.setEnabled(false);
                }
            }
        });
        this.fAssignMyFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fAssignMyFilterButton.setText("Show My Assigned Elements");
        this.fAssignMyFilterButton.setLayoutData((Object)filtersButtonData);
        this.fAssignMyFilterButton.setSelection(store.getBoolean("assignMyFilter"));
        this.fAssignMyFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (R4EPreferencePage.this.fAssignMyFilterButton.getSelection()) {
                    R4EPreferencePage.this.fAssignIdText.setEnabled(false);
                    R4EPreferencePage.this.fAssignFilterButton.setEnabled(false);
                    R4EPreferencePage.this.fUnassignFilterButton.setEnabled(false);
                } else {
                    R4EPreferencePage.this.fAssignIdText.setEnabled(true);
                    if (R4EPreferencePage.this.fAssignIdText.getCharCount() > 0) {
                        R4EPreferencePage.this.fAssignFilterButton.setEnabled(true);
                    } else {
                        R4EPreferencePage.this.fAssignFilterButton.setEnabled(false);
                    }
                    R4EPreferencePage.this.fUnassignFilterButton.setEnabled(true);
                }
            }
        });
        this.fAssignFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fAssignFilterButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fAssignFilterButton.setText("Show Assigned Elements for Participant... ");
        this.fAssignIdText = new Text(r4EFilterPrefsGroup, 2048);
        this.fAssignIdText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (store.getString("participantFilter").equals("")) {
            this.fAssignFilterButton.setSelection(false);
            this.fAssignFilterButton.setEnabled(false);
            this.fAssignIdText.setText("");
        } else {
            this.fAssignFilterButton.setSelection(true);
            this.fAssignIdText.setText(store.getString("participantFilter"));
        }
        this.fAssignIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (R4EPreferencePage.this.fAssignIdText.getCharCount() > 0) {
                    R4EPreferencePage.this.fAssignFilterButton.setEnabled(true);
                } else {
                    R4EPreferencePage.this.fAssignFilterButton.setEnabled(false);
                }
            }
        });
        this.fAssignFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (R4EPreferencePage.this.fAssignFilterButton.getSelection()) {
                    R4EPreferencePage.this.fAssignMyFilterButton.setEnabled(false);
                    R4EPreferencePage.this.fUnassignFilterButton.setEnabled(false);
                } else {
                    R4EPreferencePage.this.fAssignMyFilterButton.setEnabled(true);
                    R4EPreferencePage.this.fUnassignFilterButton.setEnabled(true);
                }
            }
        });
        this.fUnassignFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fUnassignFilterButton.setText("Show Unassigned Elements");
        this.fUnassignFilterButton.setLayoutData((Object)filtersButtonData);
        this.fUnassignFilterButton.setSelection(store.getBoolean("unassignFilter"));
        this.fUnassignFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (R4EPreferencePage.this.fUnassignFilterButton.getSelection()) {
                    R4EPreferencePage.this.fAssignMyFilterButton.setEnabled(false);
                    R4EPreferencePage.this.fAssignIdText.setEnabled(false);
                    R4EPreferencePage.this.fAssignFilterButton.setEnabled(false);
                } else {
                    R4EPreferencePage.this.fAssignMyFilterButton.setEnabled(true);
                    R4EPreferencePage.this.fAssignIdText.setEnabled(true);
                    if (R4EPreferencePage.this.fAssignIdText.getCharCount() > 0) {
                        R4EPreferencePage.this.fAssignFilterButton.setEnabled(true);
                    } else {
                        R4EPreferencePage.this.fAssignFilterButton.setEnabled(false);
                    }
                }
            }
        });
        this.fAnomaliesFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fAnomaliesFilterButton.setText("Show Anomalies Only");
        this.fAnomaliesFilterButton.setLayoutData((Object)filtersButtonData);
        this.fAnomaliesFilterButton.setSelection(store.getBoolean("anomaliesFilter"));
        this.fAnomaliesMyFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fAnomaliesMyFilterButton.setText("Show My Anomalies");
        this.fAnomaliesMyFilterButton.setLayoutData((Object)filtersButtonData);
        this.fAnomaliesMyFilterButton.setSelection(store.getBoolean("anomaliesMyFilter"));
        this.fReviewedItemsFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fReviewedItemsFilterButton.setText("Hide Reviewed Elements");
        this.fReviewedItemsFilterButton.setLayoutData((Object)filtersButtonData);
        this.fReviewedItemsFilterButton.setSelection(store.getBoolean("reviewItemsFilter"));
        this.fHideRuleSetsFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fHideRuleSetsFilterButton.setText("Hide Rule Sets");
        this.fHideRuleSetsFilterButton.setLayoutData((Object)filtersButtonData);
        this.fHideRuleSetsFilterButton.setSelection(store.getBoolean("hideRuleSetsFilter"));
        this.fHideDeltasFilterButton = new Button(r4EFilterPrefsGroup, 32);
        this.fHideDeltasFilterButton.setText("Hide Deltas");
        this.fHideDeltasFilterButton.setLayoutData((Object)filtersButtonData);
        this.fHideDeltasFilterButton.setSelection(store.getBoolean("hideDeltasFilter"));
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
        PreferenceConstants.setUserEmailDefaultPreferences();
        store.setValue("useDeltasPreferences", true);
        this.fUseDeltasButton.setSelection(true);
        store.setValue("reviewsCompletedFilter", true);
        this.fImportPostponedGlobalAnomaliesButton.setSelection(false);
        this.fSendNotificationToSenderButton.setSelection(false);
        this.fReviewsCompletedFilterButton.setSelection(true);
        store.setValue("hideDeltasFilter", true);
        this.fHideDeltasFilterButton.setSelection(true);
        store.setValue("showDisabled", false);
        this.fReviewShowDisabledButton.setSelection(false);
        store.setValue("reviewsOnlyFilter", false);
        this.fReviewsOnlyFilterButton.setSelection(false);
        store.setValue("reviewsMyFilter", false);
        this.fReviewMyFilterButton.setSelection(false);
        store.setValue("participantFilter", "");
        this.fParticipantFilterButton.setSelection(false);
        this.fParticipantIdText.setText("");
        store.setValue("assignMyFilter", false);
        this.fAssignMyFilterButton.setSelection(false);
        this.fAssignMyFilterButton.setEnabled(true);
        store.setValue("assignFilter", false);
        this.fAssignFilterButton.setSelection(false);
        this.fAssignIdText.setEnabled(true);
        this.fAssignIdText.setText("");
        store.setValue("unassignFilter", false);
        this.fUnassignFilterButton.setSelection(false);
        this.fUnassignFilterButton.setEnabled(true);
        store.setValue("anomaliesFilter", false);
        this.fAnomaliesFilterButton.setSelection(false);
        store.setValue("anomaliesMyFilter", false);
        this.fAnomaliesMyFilterButton.setSelection(false);
        store.setValue("reviewItemsFilter", false);
        this.fReviewedItemsFilterButton.setSelection(false);
        store.setValue("hideRuleSetsFilter", false);
        this.fHideRuleSetsFilterButton.setSelection(false);
        super.performDefaults();
        if (!R4EUIModelController.getNavigatorView().isDefaultDisplay()) {
            this.checkToChangeDisplay();
        }
    }

    public boolean performOk() {
        String filterUserId;
        IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
        store.setValue("userIdPreference", this.fUserIdTextField.getText().toLowerCase());
        Item[] groupItems = this.fParticipantsLists.getItems();
        StringBuffer buffer = new StringBuffer();
        Item[] itemArray = groupItems;
        int n = groupItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            buffer.append(String.valueOf(item.getText()) + ";");
            ++n2;
        }
        store.setValue("participantsLists", buffer.toString());
        store.setValue("participants", this.formatParticipantsListsPreferences());
        store.setValue("showDisabled", this.fReviewShowDisabledButton.getSelection());
        store.setValue("reviewsCompletedFilter", this.fReviewsCompletedFilterButton.getSelection());
        store.setValue("reviewsOnlyFilter", this.fReviewsOnlyFilterButton.getSelection());
        store.setValue("anomaliesMyFilter", this.fAnomaliesMyFilterButton.getSelection());
        store.setValue("reviewsMyFilter", this.fReviewMyFilterButton.getSelection());
        if (this.fParticipantFilterButton.getSelection()) {
            filterUserId = this.fParticipantIdText.getText().toLowerCase();
            if (filterUserId.equals(store.getString("userIdPreference"))) {
                store.setValue("reviewsMyFilter", true);
            } else {
                store.setValue("participantFilter", filterUserId);
            }
        } else {
            store.setValue("participantFilter", "");
            this.fParticipantIdText.setText("");
        }
        store.setValue("assignMyFilter", this.fAssignMyFilterButton.getSelection());
        if (this.fAssignFilterButton.getSelection()) {
            filterUserId = this.fAssignIdText.getText().toLowerCase();
            if (filterUserId.equals(store.getString("userIdPreference"))) {
                store.setValue("assignMyFilter", true);
            } else {
                store.setValue("assignFilter", filterUserId);
            }
        } else {
            store.setValue("assignFilter", "");
            this.fAssignIdText.setText("");
        }
        store.setValue("unassignFilter", this.fUnassignFilterButton.getSelection());
        store.setValue("anomaliesFilter", this.fAnomaliesFilterButton.getSelection());
        store.setValue("reviewItemsFilter", this.fReviewedItemsFilterButton.getSelection());
        store.setValue("hideRuleSetsFilter", this.fHideRuleSetsFilterButton.getSelection());
        store.setValue("hideDeltasFilter", this.fHideDeltasFilterButton.getSelection());
        if (R4EUIModelController.getNavigatorView() != null && !R4EUIModelController.getNavigatorView().getTreeViewer().getTree().isDisposed()) {
            R4EUIModelController.getNavigatorView().applyDefaultFilters();
        }
        store.setValue("useDeltasPreferences", this.fUseDeltasButton.getSelection());
        store.setValue("importPostponedGlobalAnomaliesPreferences", this.fImportPostponedGlobalAnomaliesButton.getSelection());
        store.setValue("SendNotificationToSenderPreferences", this.fSendNotificationToSenderButton.getSelection());
        if (!CommandUtils.isEmailValid(this.fUserEmailTextField.getText())) {
            return false;
        }
        store.setValue("userEmailPreference", this.fUserEmailTextField.getText());
        if (R4EUIModelController.getNavigatorView() != null && !R4EUIModelController.getNavigatorView().isDefaultDisplay()) {
            this.checkToChangeDisplay();
        }
        return super.performOk();
    }

    private void checkToChangeDisplay() {
        if (R4EUIModelController.getNavigatorView() != null && !R4EUIModelController.getNavigatorView().getTreeViewer().getTree().isDisposed()) {
            boolean parentGroupRemoved = true;
            if (R4EUIModelController.getActiveReview() != null) {
                String[] groupFiles;
                String[] stringArray = groupFiles = this.fGroupFilesEditor.getListControl(this.fR4EGroupPrefsGroup).getItems();
                int n = groupFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String groupFile = stringArray[n2];
                    if (groupFile.equals(((R4EUIReviewGroup)R4EUIModelController.getActiveReview().getParent()).getReviewGroup().eResource().getURI().toFileString())) {
                        parentGroupRemoved = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (parentGroupRemoved) {
                try {
                    ((ReviewNavigatorActionGroup)R4EUIModelController.getNavigatorView().getActionSet()).changeDisplayCommand();
                    R4EUIModelController.getNavigatorView().resetInput();
                }
                catch (ExecutionException e) {
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
                catch (NotDefinedException e) {
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
                catch (NotEnabledException e) {
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
                catch (NotHandledException e) {
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
            }
        }
    }

    public String getUser() {
        return this.fUserIdTextField.getText();
    }

    public void setUser(String aUser) {
        this.fUserIdTextField.setText(aUser);
    }

    public String getEmail() {
        return this.fUserEmailTextField.getText();
    }

    public void setEmail(String aEmail) {
        this.fUserEmailTextField.setText(aEmail);
    }

    public boolean getGlobalPostponedImport() {
        return this.fImportPostponedGlobalAnomaliesButton.getSelection();
    }

    public void setGlobalPostponedImport(boolean aValue) {
        this.fImportPostponedGlobalAnomaliesButton.setSelection(aValue);
    }

    public void addGroupPrefs(String aGroupPath) {
        this.fR4EPrefsTabFolder.setSelection(this.fGroupsPrefsTab);
        this.fGroupFilesEditor.getListControl(this.fR4EGroupPrefsGroup).add(aGroupPath);
    }

    public void removeGroupPrefs(String aGroupPath) {
        this.fR4EPrefsTabFolder.setSelection(this.fGroupsPrefsTab);
        this.fGroupFilesEditor.getListControl(this.fR4EGroupPrefsGroup).remove(aGroupPath);
    }

    public void addRuleSetPrefs(String aRuleSetPath) {
        this.fR4EPrefsTabFolder.setSelection(this.fRuleSetsPrefsTab);
        this.fRuleSetFilesEditor.getListControl(this.fR4ERuleSetPrefsGroup).add(aRuleSetPath);
    }

    public void removeRuleSetPrefs(String aRuleSetPath) {
        this.fR4EPrefsTabFolder.setSelection(this.fRuleSetsPrefsTab);
        this.fRuleSetFilesEditor.getListControl(this.fR4ERuleSetPrefsGroup).remove(aRuleSetPath);
    }

    @Override
    public void itemsUpdated(Item[] aItems, int aInstanceId) {
        Item selectedGroup;
        if (aInstanceId == 0) {
            Iterator<Map.Entry<String, List<String>>> entries = FParticipantsListsHashMap.entrySet().iterator();
            while (entries.hasNext()) {
                boolean itemFound = false;
                Map.Entry<String, List<String>> entry = entries.next();
                Item[] itemArray = aItems;
                int n = aItems.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    if (item.getText().equals(entry.getKey())) {
                        itemFound = true;
                    }
                    ++n2;
                }
                if (itemFound) continue;
                FParticipantsListsHashMap.remove(entry.getKey());
            }
            if (this.fParticipantsLists.getSelectedItem() == null) {
                this.fParticipantsList.removeAll();
                this.fParticipantsList.setEnabled(false);
            }
        } else if (1 == aInstanceId && (selectedGroup = this.fParticipantsLists.getSelectedItem()) != null) {
            FParticipantsListsHashMap.remove(selectedGroup.getText());
            ArrayList<String> newParticipants = new ArrayList<String>(aItems.length);
            Item[] itemArray = aItems;
            int n = aItems.length;
            int n3 = 0;
            while (n3 < n) {
                Item item = itemArray[n3];
                StringBuffer buffer = new StringBuffer();
                int numColumns = ((TableItem)item).getParent().getColumnCount();
                int i = 0;
                while (i < numColumns) {
                    buffer.append(String.valueOf(((TableItem)item).getText(i)) + ";");
                    ++i;
                }
                buffer.deleteCharAt(buffer.length() - 1);
                newParticipants.add(buffer.toString());
                ++n3;
            }
            FParticipantsListsHashMap.put(selectedGroup.getText(), newParticipants);
        }
    }

    @Override
    public void itemSelected(Item aItem, int aInstanceId) {
        if (aInstanceId == 0) {
            if (aItem == null) {
                this.fParticipantsList.removeAll();
                return;
            }
            this.fParticipantsList.setEnabled(true);
            List<String> participantsStr = FParticipantsListsHashMap.get(aItem.getText());
            this.fParticipantsList.removeAll();
            Item item = null;
            String participantStr = null;
            if (participantsStr != null) {
                int i = 0;
                while (i < participantsStr.size()) {
                    participantStr = participantsStr.get(i);
                    if (i >= this.fParticipantsList.getItemCount()) {
                        item = this.fParticipantsList.addItem();
                    } else {
                        item = this.fParticipantsList.getItem(i);
                        if (item == null) {
                            item = this.fParticipantsList.addItem();
                        }
                    }
                    ((TableItem)item).setText(participantStr.split(";"));
                    ++i;
                }
                this.fParticipantsList.updateButtons();
            }
        }
    }

    public static void populateParticipantListMap() {
        IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
        String[] participantListStrs = store.getString("participants").split(";");
        if (participantListStrs != null && participantListStrs[0] != null && !"".equals(participantListStrs[0])) {
            int readIndex = 0;
            int numLists = Integer.parseInt(participantListStrs[readIndex++]);
            int i = 0;
            while (i < numLists) {
                String participantListName = participantListStrs[readIndex++];
                int numParticipants = Integer.parseInt(participantListStrs[readIndex++]);
                ArrayList<String> users = new ArrayList<String>(numParticipants);
                int j = 0;
                while (j < numParticipants) {
                    users.add(String.valueOf(participantListStrs[readIndex++]) + ";" + participantListStrs[readIndex++]);
                    ++j;
                }
                FParticipantsListsHashMap.put(participantListName, users);
                ++i;
            }
        }
    }

    private String formatParticipantsListsPreferences() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(FParticipantsListsHashMap.size()) + ";");
        for (Map.Entry<String, List<String>> participantList : FParticipantsListsHashMap.entrySet()) {
            buffer.append(String.valueOf(participantList.getKey()) + ";");
            List<String> participants = participantList.getValue();
            buffer.append(String.valueOf(participants.size()) + ";");
            for (String participant : participants) {
                buffer.append(String.valueOf(participant) + ";");
            }
        }
        return buffer.toString();
    }

    public static List<String> getParticipantsFromList(String aQueryStr) {
        List<String> participants = FParticipantsListsHashMap.get(aQueryStr);
        if (participants == null) {
            participants = new ArrayList<String>();
        }
        if (participants.size() == 0) {
            participants.add(aQueryStr);
        }
        return participants;
    }

    public static String[] getParticipantsLists() {
        ArrayList<String> activeParticipantsLists = new ArrayList<String>();
        for (Map.Entry<String, List<String>> participantList : FParticipantsListsHashMap.entrySet()) {
            if (participantList.getValue().size() <= 0) continue;
            activeParticipantsLists.add(participantList.getKey());
        }
        return activeParticipantsLists.toArray(new String[0]);
    }
}

