/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.filters;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorActionGroup;
import org.eclipse.ui.progress.UIJob;

public class RemoveAllFiltersHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Removing all applied Filters...";

    public Object execute(ExecutionEvent aEvent) {
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(RemoveAllFiltersHandler.COMMAND_MESSAGE, 1);
                R4EUIPlugin.Ftracer.traceInfo(RemoveAllFiltersHandler.COMMAND_MESSAGE);
                Object[] elements = R4EUIModelController.getNavigatorView().getTreeViewer().getExpandedElements();
                try {
                    ((ReviewNavigatorActionGroup)R4EUIModelController.getNavigatorView().getActionSet()).resetAllFilterActions();
                }
                catch (NotDefinedException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                catch (NotEnabledException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                catch (NotHandledException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                catch (ExecutionException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                R4EUIModelController.getNavigatorView().getTreeViewer().setExpandedElements(elements);
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

