/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.navigator;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.OverlayImageIcon;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ReviewNavigatorDecorator
implements ILabelDecorator,
IFontDecorator,
IColorDecorator {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image aBaseImage, Object aElement) {
        Image currentOverlayImage = aBaseImage;
        OverlayImageIcon overlayIcon = null;
        if (!((IR4EUIModelElement)aElement).isEnabled()) {
            overlayIcon = new OverlayImageIcon(currentOverlayImage, ((IR4EUIModelElement)aElement).getDisabledImage(), 3);
            return overlayIcon.getImage();
        }
        if (((IR4EUIModelElement)aElement).isUserReviewed()) {
            overlayIcon = new OverlayImageIcon(currentOverlayImage, ((IR4EUIModelElement)aElement).getUserReviewedImage(), 3);
        }
        Image image = currentOverlayImage = overlayIcon == null ? currentOverlayImage : overlayIcon.getImage();
        if (aElement instanceof R4EUIFileContext) {
            if (((R4EUIFileContext)aElement).getBaseFileVersion() == null && ((R4EUIFileContext)aElement).getTargetFileVersion() != null) {
                overlayIcon = new OverlayImageIcon(currentOverlayImage, ((R4EUIFileContext)aElement).getAddedImage(), 2);
            } else if (((R4EUIFileContext)aElement).getBaseFileVersion() != null && ((R4EUIFileContext)aElement).getTargetFileVersion() == null) {
                overlayIcon = new OverlayImageIcon(currentOverlayImage, ((R4EUIFileContext)aElement).getRemovedImage(), 2);
            }
        }
        if (((IR4EUIModelElement)aElement).isReadOnly()) {
            overlayIcon = new OverlayImageIcon(currentOverlayImage, ((IR4EUIModelElement)aElement).getReadOnlyImage(), 1);
        }
        return (Image)(overlayIcon == null ? overlayIcon : overlayIcon.getImage());
    }

    public String decorateText(String aText, Object aElement) {
        if (aElement instanceof R4EUIFileContext && !CommandUtils.useWorkspaceResource(((R4EUIFileContext)aElement).getTargetFileVersion())) {
            return "> " + aText;
        }
        return null;
    }

    public Font decorateFont(Object aElement) {
        if (R4EUIModelController.getActiveReview() != null && R4EUIModelController.getActiveReview().equals(aElement)) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        if (this.isMyReview((IR4EUIModelElement)aElement)) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return null;
    }

    private boolean isMyReview(IR4EUIModelElement aElement) {
        IR4EUIModelElement currentElement = aElement;
        while (currentElement != null) {
            if (currentElement instanceof R4EUIReviewBasic && ((R4EUIReviewBasic)currentElement).isParticipant(R4EUIModelController.getReviewer())) {
                return true;
            }
            currentElement = currentElement.getParent();
        }
        return false;
    }

    public Color decorateBackground(Object aElement) {
        return null;
    }

    public Color decorateForeground(Object aElement) {
        if (aElement instanceof R4EUIReviewBasic && ((R4EReviewState)((R4EUIReviewBasic)aElement).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
            return Display.getCurrent().getSystemColor(16);
        }
        if (aElement instanceof IR4EUIModelElement && ((IR4EUIModelElement)aElement).isReadOnly()) {
            return Display.getCurrent().getSystemColor(16);
        }
        return null;
    }
}

