/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lbc.internal.base.api.FloatingState;
import org.eclipse.passage.lbc.internal.base.api.RawRequest;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.io.Hashes;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.base.io.MD5Hashes;
import org.eclipse.passage.lic.base.io.PathKeyKeeper;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;
import org.eclipse.passage.lic.internal.net.api.handle.NetRequest;
import org.eclipse.passage.lic.internal.net.handle.ProductUserRequest;
import org.eclipse.passage.lic.internal.net.io.SafePayload;
import org.eclipse.passage.lic.licenses.model.api.GrantAcqisition;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;

public abstract class DecodedRequest<T extends EObject> {
    private final RawRequest request;
    private final Map<String, Object> options;

    protected DecodedRequest(RawRequest request, Map<String, Object> options) {
        this.request = request;
        this.options = options;
    }

    public final T get() throws IOException, LicensingException {
        return (T)new EObjectFromBytes(this.decoded(this.request.content()), this.target()).get(this.options);
    }

    protected abstract EClass target();

    private byte[] decoded(byte[] raw) throws LicensingException {
        LicensedProduct product = (LicensedProduct)new ProductUserRequest((NetRequest)this.request).product().get();
        return new SafePayload((KeyKeeper)new PathKeyKeeper(product, ((FloatingState)this.request.state())::source), (Hashes)new MD5Hashes()).decode(raw);
    }

    public static final class GrantAck
    extends DecodedRequest<GrantAcqisition> {
        public GrantAck(RawRequest request) {
            super(request, Collections.singletonMap("http://www.eclipse.org/passage/lic/licenses/3.0.0", LicensesPackage.eINSTANCE));
        }

        @Override
        protected EClass target() {
            return LicensesPackage.eINSTANCE.getGrantAcqisition();
        }
    }
}

