/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.FeatureIdentifier;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;

public final class FeatureFilter<T>
implements Function<ServiceInvocationResult<Collection<T>>, ServiceInvocationResult<Collection<T>>> {
    private final FeatureIdentifier feature;
    private final BiFunction<T, FeatureIdentifier, Optional<T>> map;

    public FeatureFilter(FeatureIdentifier feature, BiFunction<T, FeatureIdentifier, Optional<T>> map) {
        this.feature = Objects.requireNonNull(feature);
        this.map = Objects.requireNonNull(map);
    }

    @Override
    public ServiceInvocationResult<Collection<T>> apply(ServiceInvocationResult<Collection<T>> original) {
        return new BaseServiceInvocationResult<Collection<T>>(original.diagnostic(), this.filter(original.data()));
    }

    private Collection<T> filter(Optional<Collection<T>> targets) {
        return targets.map(this::filter).orElse(Collections.emptySet());
    }

    private Collection<T> filter(Collection<T> targets) {
        return targets.stream().map(target -> this.map.apply(target, this.feature)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

