/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.keys.model.api.KeyPair;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.loc.internal.api.workspace.Keys;
import org.eclipse.passage.loc.internal.equinox.OperatorGearAware;
import org.eclipse.passage.loc.internal.products.core.KeyPairGeneraged;
import org.eclipse.passage.loc.internal.products.core.KeyPairStored;
import org.eclipse.passage.loc.internal.products.core.ProductVersionPassword;
import org.eclipse.passage.loc.internal.products.core.i18n.ProductsCoreMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProductVersionKeys {
    private final String plugin;
    private final Consumer<String> notify;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    ProductVersionKeys(String plugin, Consumer<String> notify) {
        Objects.requireNonNull(plugin, "ProductVersionPassword::plugin");
        Objects.requireNonNull(notify, "ProductVersionPassword::notify");
        this.plugin = plugin;
        this.notify = notify;
    }

    ProductVersionKeys(String plugin) {
        this(plugin, p -> {});
    }

    public IStatus createKeys(ProductVersion target) {
        Optional<StreamCodec> codec;
        Optional<String> existing;
        BaseLicensedProduct product = this.product(target);
        try {
            existing = this.keyIsPresent((LicensedProduct)product);
        }
        catch (LicensingException e) {
            return this.failed((Exception)((Object)e));
        }
        if (existing.isPresent()) {
            return this.error(existing.get());
        }
        try {
            codec = this.codec((LicensedProduct)product);
        }
        catch (LicensingException e) {
            return this.failed((Exception)((Object)e));
        }
        if (codec.isEmpty()) {
            return this.noCodec(target, (LicensedProduct)product);
        }
        try {
            return this.createKeyPair(target, (LicensedProduct)product, codec.get());
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    private BaseLicensedProduct product(ProductVersion target) {
        return new BaseLicensedProduct(target.getProduct().getIdentifier(), target.getVersion());
    }

    private Optional<StreamCodec> codec(LicensedProduct product) throws LicensingException {
        return new OperatorGearAware().withGear(gear -> gear.codec(product));
    }

    private Optional<String> keyIsPresent(LicensedProduct target) throws LicensingException {
        Keys service = (Keys)new OperatorGearAware().withGear(gear -> Optional.of(gear.workspace().keys())).get();
        Optional exists = service.existing(target.identifier(), target.version());
        return exists.map(path -> String.format(ProductsCoreMessages.ProductOperatorServiceImpl_e_key_already_defined, path));
    }

    private IStatus createKeyPair(ProductVersion target, LicensedProduct product, StreamCodec codec) throws LicensingException {
        Optional<String> stored = this.store(this.generate(target, product, codec));
        if (!stored.isPresent()) {
            this.notify.accept(stored.get());
        }
        return this.created(stored);
    }

    private Optional<String> store(KeyPair pair) throws LicensingException {
        return new KeyPairStored(pair).store();
    }

    /*
     * Loose catch block
     */
    private KeyPair generate(ProductVersion target, LicensedProduct product, StreamCodec codec) throws LicensingException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                KeyPair keyPair;
                ByteArrayOutputStream secret;
                ByteArrayOutputStream open;
                block18: {
                    block17: {
                        open = new ByteArrayOutputStream();
                        secret = new ByteArrayOutputStream();
                        codec.createKeyPair((OutputStream)open, (OutputStream)secret, product.identifier(), new ProductVersionPassword(target).get());
                        keyPair = new KeyPairGeneraged(codec, open.toByteArray(), secret.toByteArray()).get();
                        if (secret == null) break block17;
                        secret.close();
                    }
                    if (open == null) break block18;
                    open.close();
                }
                return keyPair;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (secret != null) {
                                secret.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (open != null) {
                                open.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new LicensingException("failed to generate keys", (Throwable)e);
        }
    }

    private Status error(String errors) {
        return new Status(4, this.plugin, errors);
    }

    private Status noCodec(ProductVersion target, LicensedProduct product) {
        return this.error(String.format(ProductsCoreMessages.ProductOperatorServiceImpl_e_unable_to_create_keys, product.version(), target.getProduct().getName()));
    }

    private Status failed(Exception e) {
        this.log.error("", (Throwable)e);
        return new Status(4, this.plugin, ProductsCoreMessages.ProductOperatorServiceImpl_e_export_error, (Throwable)e);
    }

    private Status created(Optional<String> persisted) {
        return new Status(0, this.plugin, String.format(ProductsCoreMessages.ProductOperatorServiceImpl_ok_keys_exported, persisted.orElse("unknown")));
    }
}

