/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.loc.internal.e4.events.OperatorProductEvents;
import org.eclipse.passage.loc.internal.equinox.OperatorProductService;
import org.eclipse.passage.loc.internal.products.core.ProductVersionKeys;
import org.eclipse.passage.loc.internal.products.core.ProductVersionPassword;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;

@Component
public final class ProductOperatorServiceImpl
implements OperatorProductService {
    private final List<EventAdmin> events = new ArrayList<EventAdmin>();

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void bindEventAdmin(EventAdmin admin) {
        this.events.add(admin);
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events.remove(admin);
    }

    public String createPassword(ProductVersion descriptor) {
        return new ProductVersionPassword(descriptor).get();
    }

    public IStatus createProductKeys(ProductVersion target) {
        return new ProductVersionKeys(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), this::broadcast).createKeys(target);
    }

    private void broadcast(String info) {
        ((EventAdmin)this.events.stream().findAny().get()).postEvent(new OperatorProductEvents().keysCreated(info));
    }
}

