/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.internal.products.model.util.ProductsResourceImpl;
import org.eclipse.passage.lic.products.model.api.Product;
import org.eclipse.passage.lic.products.model.api.ProductLine;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.lic.products.model.api.ProductVersionFeature;
import org.eclipse.passage.lic.products.model.meta.ProductsPackage;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.KnownResources;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.internal.api.workspace.Products;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.equinox.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.products.core.ProductsDomainRegistryTracker;
import org.eclipse.passage.loc.internal.products.core.i18n.ProductsCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=products", "org.eclipse.passage.lic.emf.edit.file.extension=products_xmi"})
public final class ProductDomainRegistry
extends BaseDomainRegistry<ProductLine>
implements ProductRegistry,
EditingDomainRegistry<ProductLine> {
    private final Map<String, ProductLine> lines = new HashMap<String, ProductLine>();
    private final Map<String, Product> products = new HashMap<String, Product>();
    private final Map<String, Map<String, ProductVersion>> versions = new HashMap<String, Map<String, ProductVersion>>();
    private final Map<String, Map<String, Map<String, ProductVersionFeature>>> features = new HashMap<String, Map<String, Map<String, ProductVersionFeature>>>();
    private final List<EventAdmin> events = new ArrayList<EventAdmin>();

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void bindEventAdmin(EventAdmin admin) {
        this.events.add(admin);
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events.remove(admin);
    }

    @Reference
    public void bindGear(OperatorGearSupplier supplier) {
        super.bindGear(supplier);
    }

    public void unbindGear(OperatorGearSupplier supplier) {
        super.unbindGear(supplier);
    }

    @Activate
    public void load(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void unload(Map<String, Object> properties) {
        for (Map<String, Map<String, ProductVersionFeature>> map : this.features.values()) {
            map.clear();
        }
        this.versions.values().forEach(Map::clear);
        this.products.clear();
        this.lines.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "products_xmi";
    }

    public Class<ProductLine> getContentClass() {
        return ProductLine.class;
    }

    public String resolveIdentifier(ProductLine content) {
        return content.getIdentifier();
    }

    @Override
    public Collection<ProductLine> productLines() {
        return new ArrayList<ProductLine>(this.lines.values());
    }

    @Override
    public Optional<ProductLine> productLine(String identifier) {
        return Optional.ofNullable(this.lines.get(identifier));
    }

    @Override
    public Collection<Product> products() {
        return new ArrayList<Product>(this.products.values());
    }

    @Override
    public Optional<Product> product(String id) {
        return Optional.ofNullable(this.products.get(id));
    }

    @Override
    public Collection<ProductVersion> productVersions() {
        ArrayList<ProductVersion> list = new ArrayList<ProductVersion>();
        Collection<Map<String, ProductVersion>> values = this.versions.values();
        for (Map<String, ProductVersion> map : values) {
            list.addAll(map.values());
        }
        return list;
    }

    @Override
    public Optional<ProductVersion> productVersion(String product, String version) {
        return Optional.ofNullable(this.versions.get(product)).map(m -> (ProductVersion)m.get(version));
    }

    @Override
    public Collection<ProductVersionFeature> productVersionFeatures() {
        ArrayList<ProductVersionFeature> result = new ArrayList<ProductVersionFeature>();
        for (Map<String, Map<String, ProductVersionFeature>> maps : this.features.values()) {
            for (Map<String, ProductVersionFeature> map : maps.values()) {
                result.addAll(map.values());
            }
        }
        return result;
    }

    protected DomainContentAdapter<ProductLine, ProductDomainRegistry> createContentAdapter() {
        return new ProductsDomainRegistryTracker(this);
    }

    void registerProductLine(ProductLine line) {
        ProductLine existing = this.lines.put(line.getIdentifier(), line);
        if (existing != null && existing != line) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)ProductsCoreMessages.ProductDomain_instance_duplication_message, (Object)existing, (Object)line));
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductLine/create", (Object)line).get());
        line.getProducts().forEach(p -> this.registerProduct((Product)p));
    }

    void registerProduct(Product product) {
        String identifier = product.getIdentifier();
        Product existing = this.products.put(identifier, product);
        if (existing != null && existing != product) {
            String msg = NLS.bind((String)ProductsCoreMessages.ProductDomain_instance_duplication_message, (Object)existing, (Object)product);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/Product/create", (Object)product).get());
        product.getProductVersions().forEach(pv -> this.registerProductVersion(product, (ProductVersion)pv));
    }

    void registerProductVersion(Product product, ProductVersion version) {
        ProductVersion existing = this.versions.computeIfAbsent(product.getIdentifier(), key -> new HashMap()).put(version.getVersion(), version);
        if (existing != null && existing != version) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)ProductsCoreMessages.ProductDomain_instance_duplication_message, (Object)existing, (Object)version));
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductVersion/create", (Object)version).get());
    }

    void registerProductVersionFeature(Product product, ProductVersion version, ProductVersionFeature feature) {
        ProductVersionFeature existing = this.features.computeIfAbsent(product.getIdentifier(), key -> new HashMap()).computeIfAbsent(version.getVersion(), key -> new HashMap()).put(feature.getFeatureIdentifier(), feature);
        if (existing != null && existing != feature) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)ProductsCoreMessages.ProductDomain_instance_duplication_message, (Object)existing, (Object)feature));
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductVersionFeature/create", (Object)feature).get());
    }

    void unregisterProductLine(String id) {
        ProductLine removed = this.lines.remove(id);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductLine/delete", (Object)removed).get());
            removed.getProducts().forEach(p -> this.unregisterProduct(p.getIdentifier()));
        }
    }

    void unregisterProduct(String id) {
        Product removed = this.products.remove(id);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/Product/delete", (Object)removed).get());
            removed.getProductVersions().forEach(pv -> this.unregisterProductVersion(id, pv.getVersion()));
        }
    }

    void unregisterProductVersion(String product, String version) {
        Map<String, ProductVersion> found = this.versions.get(product);
        if (found != null) {
            ProductVersion removed = found.remove(version);
            if (removed != null) {
                this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductVersion/delete", (Object)removed).get());
                removed.getProductVersionFeatures().forEach(pvf -> this.unregisterProductVersionFeature(product, version, pvf.getFeatureIdentifier()));
            }
            if (found.isEmpty()) {
                found.remove(product);
            }
        }
    }

    void unregisterProductVersionFeature(String product, String version, String feature) {
        Map<String, Map<String, ProductVersionFeature>> maps = this.features.get(product);
        if (maps != null) {
            Map<String, ProductVersionFeature> map = maps.get(version);
            if (map != null) {
                ProductVersionFeature removed = map.remove(feature);
                if (removed != null) {
                    this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductVersionFeature/delete", (Object)removed).get());
                }
                if (map.isEmpty()) {
                    maps.remove(version);
                }
            }
            if (maps.isEmpty()) {
                this.features.remove(product);
            }
        }
    }

    private EventAdmin events() {
        return (EventAdmin)this.events.stream().findAny().get();
    }

    public EClass getContentClassifier() {
        return ProductsPackage.eINSTANCE.getProductLine();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return ProductsPackage.eINSTANCE.getProductLine_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return ProductsPackage.eINSTANCE.getProductLine_Name();
    }

    public void registerContent(ProductLine content) {
        this.registerProductLine(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterProductLine(identifier);
    }

    protected final Resource createResource(URI uri) {
        return new ProductsResourceImpl(uri);
    }

    protected boolean emfResource(ResourceHandle handle) {
        return Products.xmi.equals(handle.type()) || Products.xmi033.equals(handle.type());
    }

    protected KnownResources knownResources(OperatorWorkspace workspace) {
        return workspace.products();
    }
}

