/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.products.emfforms.renderers;

import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.products.ui.ProductsUi;
import org.eclipse.passage.loc.workbench.emfforms.renderers.TextWithButtonRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProductVersionRenderer
extends TextWithButtonRenderer {
    private static final String IDENTIFIER_EMPTY = "";
    private final ProductRegistry registry;

    @Inject
    public ProductVersionRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.registry = (ProductRegistry)viewContext.getService(ProductRegistry.class);
    }

    protected Control createSWTControl(Composite parent) {
        Control control = super.createSWTControl(parent);
        this.text.setEditable(true);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductVersionRenderer.this.selectIdentifier();
            }
        });
        return control;
    }

    protected String getUnsetText() {
        return IDENTIFIER_EMPTY;
    }

    protected void selectIdentifier() {
        String identifier;
        Shell shell = Display.getDefault().getActiveShell();
        ProductVersion descriptor = ProductsUi.selectProductVersion((Shell)shell, (ProductRegistry)this.registry);
        if (descriptor != null && (identifier = descriptor.getVersion()) != null) {
            this.text.setText(identifier);
        }
    }
}

