/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.renderers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.conditions.MatchingRule;
import org.eclipse.passage.lic.api.version.SemanticVersion;
import org.eclipse.passage.lic.base.version.BaseSemanticVersion;

final class MatchingRuleExplained {
    private final List<Sample> samples;

    public MatchingRuleExplained(MatchingRule rule, SemanticVersion base) {
        this.samples = this.scale(base).stream().map(required -> new Sample(rule, (SemanticVersion)required, base)).collect(Collectors.toList());
    }

    private List<SemanticVersion> scale(SemanticVersion base) {
        ArrayList<SemanticVersion> scale = new ArrayList<SemanticVersion>();
        if (base.major() > 0) {
            scale.add((SemanticVersion)new BaseSemanticVersion(base.major() - 1, base.minor(), base.service()));
        }
        if (base.minor() > 0) {
            scale.add((SemanticVersion)new BaseSemanticVersion(base.major(), base.minor() - 1, base.service()));
        }
        if (base.service() > 0) {
            scale.add((SemanticVersion)new BaseSemanticVersion(base.major(), base.minor(), base.service() - 1));
        }
        scale.add(base);
        scale.add((SemanticVersion)new BaseSemanticVersion(base.major(), base.minor(), base.service() + 1));
        scale.add((SemanticVersion)new BaseSemanticVersion(base.major(), base.minor() + 1, base.service()));
        scale.add((SemanticVersion)new BaseSemanticVersion(base.major() + 1, base.minor(), base.service()));
        return scale;
    }

    List<Sample> samples() {
        return this.samples;
    }

    static final class Sample {
        private final boolean ok;
        private final SemanticVersion version;

        private Sample(MatchingRule rule, SemanticVersion version, SemanticVersion base) {
            this.ok = rule.match(version.toString(), base.toString());
            this.version = version;
        }

        boolean ok() {
            return this.ok;
        }

        String text() {
            return this.version.toString();
        }
    }
}

