/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.passage.lic.api.Gear;
import org.eclipse.passage.lic.api.GearSupplier;
import org.eclipse.passage.lic.api.LicensingException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GearAware<G extends Gear, S extends GearSupplier<G>> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public final <T> Optional<T> withGear(Unsafe<G, T> with) throws LicensingException {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Collection<Object> references = Collections.emptyList();
        try {
            references = context.getServiceReferences(this.supplier(), null);
        }
        catch (InvalidSyntaxException e) {
            this.log.error("Failed to resolve service references", (Throwable)e);
            return Optional.empty();
        }
        if (references.isEmpty()) {
            this.log.error("No reference of service " + this.supplier().getName());
            return Optional.empty();
        }
        ServiceReference any = (ServiceReference)references.iterator().next();
        try {
            Optional<T> optional = with.apply(((GearSupplier)context.getService(any)).gear());
            return optional;
        }
        catch (Exception e) {
            throw new LicensingException("Error on service invocation", (Throwable)e);
        }
        finally {
            context.ungetService(any);
        }
    }

    protected abstract Class<S> supplier();

    @FunctionalInterface
    public static interface Unsafe<G extends Gear, T> {
        public Optional<T> apply(G var1) throws Exception;
    }
}

