/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface.license;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportLicenseReportWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.PageObserver;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class ConfigPage
extends WizardPage {
    private final PageObserver observer;
    private Button explain;
    private DateTime from;
    private DateTime to;

    protected ConfigPage(PageObserver observer) {
        super("scope");
        this.observer = observer;
        this.setTitle(ExportLicenseReportWizardMessages.ConfigPage_title);
        this.installPageDescription();
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        this.createPeriodSection(content);
        this.createAdditionalContentSection(content);
        this.setControl((Control)content);
    }

    void installInitial() {
        this.installDateToControl(this.from, this.initialFrom());
        this.installDateToControl(this.to, this.initialTo());
        this.explain.setSelection(this.initialExplain());
        this.updateControls();
    }

    boolean explain() {
        return this.explain.getSelection();
    }

    Date from() {
        return this.date(this.from, this::initialFrom);
    }

    Date to() {
        return this.date(this.to, this::initialTo);
    }

    private Date date(DateTime control, Supplier<LocalDate> initial) {
        LocalDate source = Optional.ofNullable(control).isPresent() ? LocalDate.of(control.getYear(), control.getMonth() + 1, control.getDay()) : initial.get();
        return Date.from(source.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    private LocalDate initialFrom() {
        return LocalDate.now().minus(6L, ChronoUnit.MONTHS);
    }

    private LocalDate initialTo() {
        return LocalDate.now().minus(1L, ChronoUnit.DAYS);
    }

    private boolean initialExplain() {
        return false;
    }

    private void installDateToControl(DateTime control, LocalDate date) {
        control.setYear(date.getYear());
        control.setMonth(date.getMonth().getValue() - 1);
        control.setDay(date.getDayOfMonth());
    }

    private void createPeriodSection(Composite parent) {
        Composite content = this.row(parent, 4);
        new Label(content, 0).setText(ExportLicenseReportWizardMessages.ConfigPage_dateFrom_title);
        this.from = new DateTime(content, 4);
        SelectionListener listener = this.validateAndUpdate();
        this.from.addSelectionListener(listener);
        new Label(content, 0).setText(ExportLicenseReportWizardMessages.ConfigPage_dateTo_title);
        this.to = new DateTime(content, 4);
        this.to.addSelectionListener(listener);
    }

    private Composite row(Composite parent, int columns) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(columns, false));
        content.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return content;
    }

    private void createAdditionalContentSection(Composite parent) {
        Composite content = this.row(parent, 2);
        Label label = new Label(content, 64);
        label.setText(ExportLicenseReportWizardMessages.ConfigPage_explain_title);
        label.setToolTipText(ExportLicenseReportWizardMessages.ConfigPage_explain_tooltip);
        this.explain = new Button(content, 32);
        this.explain.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateControls()));
    }

    private void updateControls() {
        this.observer.update();
    }

    private void validate() {
        if (!this.from().before(this.to())) {
            this.setMessage(ExportLicenseReportWizardMessages.ConfigPage_invalidDates, 3);
        } else {
            this.installPageDescription();
        }
    }

    private SelectionListener validateAndUpdate() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            this.validate();
            this.updateControls();
        });
    }

    private void installPageDescription() {
        this.setMessage(ExportLicenseReportWizardMessages.ConfigPage_description, 0);
    }
}

