/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.passage.lic.emf.ecore.ResourceSetProvider;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.loc.workbench.viewers.DomainRegistryLabelProvider;
import org.eclipse.passage.loc.workbench.viewers.ResourceSetAdapter;
import org.eclipse.passage.loc.workbench.viewers.StructuredSelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DomainRegistryExplorer {
    private final ResourceSetProvider resourceSetProvider;
    private final ComposedAdapterFactoryProvider composedAdapterFactoryProvider;
    private final ESelectionService selectionService;
    private ISelectionChangedListener selectionChangeListener;
    private TreeViewer viewer;
    private ResourceSetAdapter resourceSetAdapter;

    public DomainRegistryExplorer(ResourceSetProvider setProvider, ComposedAdapterFactoryProvider factoryProvider, ESelectionService selectionService) {
        this.resourceSetProvider = setProvider;
        this.composedAdapterFactoryProvider = factoryProvider;
        this.selectionService = selectionService;
    }

    public ResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        Composite base = new Composite(parent, 2048);
        base.setLayout((Layout)new GridLayout());
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TreeViewer(base);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ComposedAdapterFactory factory = this.composedAdapterFactoryProvider != null ? this.composedAdapterFactoryProvider.getComposedAdapterFactory() : new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)factory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new DomainRegistryLabelProvider((AdapterFactory)factory));
        this.selectionChangeListener = new StructuredSelectionListener(this.selectionService);
        this.viewer.addSelectionChangedListener(this.selectionChangeListener);
        ResourceSet resourceSet = this.resourceSetProvider.getResourceSet();
        this.resourceSetAdapter = new ResourceSetAdapter((StructuredViewer)this.viewer);
        resourceSet.eAdapters().add((Object)this.resourceSetAdapter);
        this.resetInput();
    }

    @Focus
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @PreDestroy
    public void dispose() {
        this.resourceSetProvider.getResourceSet().eAdapters().remove((Object)this.resourceSetAdapter);
        this.viewer.removeSelectionChangedListener(this.selectionChangeListener);
    }

    protected void resetInput() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            EList resources;
            ResourceSet resourceSet = this.resourceSetProvider.getResourceSet();
            ISelection selection = this.viewer.getSelection();
            this.viewer.setInput((Object)resourceSet);
            if (selection.isEmpty() && !(resources = resourceSet.getResources()).isEmpty()) {
                Resource resource = (Resource)resources.get(0);
                selection = new StructuredSelection((Object)resource);
            }
            this.viewer.setSelection(selection);
        }
    }
}

