/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ManageListValuesDialog
extends Dialog {
    private static final String SPLITTER = ";";
    List lstItems;
    String expressionValues;
    Text txtEditItem;
    Button btnAddItem;
    String resultExpressionValues;

    public ManageListValuesDialog(Shell parentShell, String values) {
        super(parentShell);
        this.expressionValues = values;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Condition Expession");
        shell.setSize(400, 500);
    }

    public String getResultValues() {
        return this.resultExpressionValues;
    }

    private String prepareResultValues() {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = this.lstItems.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (builder.length() > 0) {
                builder.append(SPLITTER);
            }
            builder.append(item);
            ++n2;
        }
        return builder.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.resultExpressionValues = this.prepareResultValues();
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(3, false));
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblTitle = new Label(base, 0);
        lblTitle.setText("Condition Expession values:");
        lblTitle.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.lstItems = new List(base, 2048);
        this.lstItems.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        GridData text = new GridData(4, 4, true, false, 1, 1);
        final Text txtExpressionItem = new Text(base, 2048);
        txtExpressionItem.setLayoutData((Object)text);
        txtExpressionItem.setText("");
        GridData btnGridLayout = new GridData(4, 4, false, false, 1, 1);
        btnGridLayout.heightHint = 30;
        btnGridLayout.widthHint = 70;
        Button btnAdd = new Button(base, 8);
        btnAdd.setText("Add");
        btnAdd.setLayoutData((Object)btnGridLayout);
        btnAdd.getFont().getFontData()[0].setHeight(10);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String textExpression = txtExpressionItem.getText();
                if (!textExpression.isEmpty()) {
                    ManageListValuesDialog.this.lstItems.add(textExpression);
                    txtExpressionItem.setText("");
                }
            }
        });
        Button btnRemove = new Button(base, 8);
        btnRemove.setText("Remove");
        btnRemove.setLayoutData((Object)btnGridLayout);
        btnRemove.getFont().getFontData()[0].setHeight(10);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ManageListValuesDialog.this.lstItems.getSelectionIndex();
                if (selectionIndex > -1) {
                    ManageListValuesDialog.this.lstItems.remove(selectionIndex);
                    txtExpressionItem.setText("");
                }
            }
        });
        if (this.expressionValues != null && !this.expressionValues.isEmpty()) {
            String[] splitedVAlues = this.expressionValues.split(SPLITTER);
            this.lstItems.setItems(splitedVAlues);
        }
        this.lstItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedValue = ManageListValuesDialog.this.lstItems.getItems()[ManageListValuesDialog.this.lstItems.getSelectionIndex()];
                txtExpressionItem.setText(selectedValue);
            }
        });
        return parent;
    }

    protected boolean isResizable() {
        return true;
    }
}

