/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.passage.lic.base.requirements.LicensingRequirements;
import org.eclipse.passage.lic.equinox.ApplicationConfigurations;
import org.eclipse.passage.lic.equinox.LicensingEquinox;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.inspector.FeatureCase;
import org.eclipse.passage.lic.runtime.inspector.FeatureInspector;
import org.eclipse.passage.lic.runtime.requirements.LicensingRequirement;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWiring;

public class EquinoxRequirements {
    public static Iterable<BundleRequirement> extractLicensingManagementRequirements(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            return wiring.getRequirements("licensing.management");
        }
        return Collections.emptyList();
    }

    public static Iterable<BundleCapability> extractLicensingFeatures(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            return wiring.getCapabilities("licensing.feature");
        }
        return Collections.emptyList();
    }

    public static Iterable<LicensingRequirement> getFeatureRequirements(String ... featureIds) {
        FeatureInspector featureInspector = LicensingEquinox.getFeatureInspector();
        if (featureInspector == null) {
            LicensingConfiguration configuration = ApplicationConfigurations.getLicensingConfiguration();
            if (featureIds.length == 0) {
                String id = configuration.getProductIdentifier();
                return Collections.singletonList(LicensingRequirements.createConfigurationError((String)id, (Object)configuration));
            }
            ArrayList<LicensingRequirement> errors = new ArrayList<LicensingRequirement>();
            String[] stringArray = featureIds;
            int n = featureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                errors.add(LicensingRequirements.createConfigurationError((String)id, (Object)configuration));
                ++n2;
            }
            return errors;
        }
        Throwable throwable = null;
        Object var3_7 = null;
        try (FeatureCase inspection = featureInspector.inspectFeatures(featureIds);){
            return inspection.getRequirements();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

