/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.e4.ui.restrictions;

import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdicts;
import org.eclipse.passage.lic.jface.dialogs.LicensingStatusDialog;
import org.eclipse.passage.lic.runtime.LicensingResult;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionExecutor;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionVerdict;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WorkbenchRestrictionExecutor
implements RestrictionExecutor {
    private BundleContext bundleContext;
    private IApplicationContext applicationContext;

    @Activate
    public void activate(BundleContext context) {
        this.bundleContext = context;
    }

    @Reference
    public void bindApplication(IApplicationContext context) {
        this.applicationContext = context;
    }

    public void unbindApplication() {
        this.applicationContext = null;
    }

    public LicensingResult execute(Iterable<RestrictionVerdict> verdicts) {
        boolean andExit;
        String featureId = this.applicationContext.getBrandingId();
        RestrictionVerdict lastVerdict = RestrictionVerdicts.resolveLastVerdict(verdicts, (String)featureId);
        boolean showDialog = RestrictionVerdicts.shouldPauseExecution((RestrictionVerdict)lastVerdict);
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)this.bundleContext);
        if (showDialog) {
            Shell shell = (Shell)serviceContext.get(Shell.class);
            LicensingStatusDialog dialog = new LicensingStatusDialog(shell, new String[]{featureId});
            dialog.open();
            lastVerdict = RestrictionVerdicts.resolveLastVerdict((Iterable)dialog.getRestrictions(), (String)featureId);
        }
        if (andExit = RestrictionVerdicts.shouldInterruptExecution((RestrictionVerdict)lastVerdict)) {
            IWorkbench workbench = (IWorkbench)serviceContext.get(IWorkbench.class);
            workbench.close();
        }
        return LicensingResults.createOK();
    }
}

