/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.container;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.passage.lbc.runtime.ServerHandler;
import org.eclipse.passage.lbc.runtime.ServerRequestAction;
import org.eclipse.passage.lbc.runtime.ServerRequestExecutor;
import org.eclipse.passage.lbc.runtime.ServerRequestHandler;
import org.eclipse.passage.lbc.runtime.ServerRunner;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

public class ServerRunnerImpl
implements ServerRunner {
    private static final String REGISTERED = "[Registered]  %s";
    private static final String REQUEST_HANDLER_NOT_FOUND = "Request handler not registrated for component ";
    private ServerHandler serverHandler;
    private Map<String, ServerRequestHandler> requestHandlers = new HashMap<String, ServerRequestHandler>();
    private Map<String, ServerRequestExecutor> requestExecutors = new HashMap<String, ServerRequestExecutor>();
    private Map<String, ServerRequestAction> requestActions = new HashMap<String, ServerRequestAction>();
    private Logger logger;

    public void activate() {
        if (this.serverHandler != null) {
            this.serverHandler.launch();
        } else {
            this.logger.error("Server not registrated");
        }
    }

    public void bindLogger(LoggerFactory loggerFactory) {
        this.logger = loggerFactory.getLogger(ServerRunnerImpl.class);
    }

    public void unbindLogger(LoggerFactory logService) {
        this.logger = null;
    }

    public void bindServerHandler(ServerHandler serverHandler) {
        this.logger.info(String.format(REGISTERED, serverHandler.toString()));
        this.serverHandler = serverHandler;
    }

    public void unbindServerHandler(ServerHandler serverHandler) {
        this.serverHandler = null;
    }

    public void bindServerRequestHandler(ServerRequestHandler serverRequestHandler, Map<String, String> context) {
        this.logger.debug(String.format(REGISTERED, serverRequestHandler.getClass().getName()));
        String requestHandlerId = context.get("handler");
        if (requestHandlerId != null) {
            this.requestHandlers.put(requestHandlerId, serverRequestHandler);
            this.serverHandler.addServerRequestHandler(serverRequestHandler);
        } else {
            this.logger.error(REQUEST_HANDLER_NOT_FOUND + serverRequestHandler.toString());
        }
    }

    public void unbindServerRequestHandler(ServerRequestHandler serverRequestHandler, Map<String, String> context) {
        String requestHandlerId = context.get("handler");
        if (requestHandlerId != null) {
            this.requestHandlers.remove(requestHandlerId, serverRequestHandler);
            this.serverHandler.remServerRequestHandler(serverRequestHandler);
        } else {
            this.logger.error(REQUEST_HANDLER_NOT_FOUND + serverRequestHandler.toString());
        }
    }

    public void bindServerRequestExecutor(ServerRequestExecutor serverRequestExecutor, Map<String, String> context) {
        this.logger.debug(String.format(REGISTERED, serverRequestExecutor.getClass().getName()));
        String requestExecutorModeId = context.get("mode");
        if (requestExecutorModeId != null) {
            serverRequestExecutor.setAccessModeId(requestExecutorModeId);
            if (!this.requestExecutors.containsKey(requestExecutorModeId)) {
                this.requestExecutors.put(requestExecutorModeId, serverRequestExecutor);
                for (Map.Entry<String, ServerRequestHandler> entry : this.requestHandlers.entrySet()) {
                    entry.getValue().addRequestExecutor(serverRequestExecutor);
                }
            }
        } else {
            this.logger.error(REQUEST_HANDLER_NOT_FOUND + serverRequestExecutor.toString() + "mode" + requestExecutorModeId);
        }
    }

    public void unbindServerRequestExecutor(ServerRequestExecutor serverRequestExecutor, Map<String, String> context) {
        String requestExecutorModeId = context.get("mode");
        if (requestExecutorModeId != null) {
            this.requestExecutors.remove(requestExecutorModeId, serverRequestExecutor);
            for (Map.Entry<String, ServerRequestHandler> entry : this.requestHandlers.entrySet()) {
                entry.getValue().addRequestExecutor(serverRequestExecutor);
            }
        }
    }

    public void bindExecutorByRequest(Map<String, ServerRequestHandler> mapHandlers, Map<String, Map<String, ServerRequestExecutor>> mapRequestExecutors) {
        for (String keyExecutor : mapRequestExecutors.keySet()) {
            Map<String, ServerRequestExecutor> mapExecutors = mapRequestExecutors.get(keyExecutor);
            ServerRequestHandler requestHandler = mapHandlers.get(keyExecutor);
            for (Map.Entry<String, ServerRequestExecutor> iter : mapExecutors.entrySet()) {
                requestHandler.addRequestExecutor(iter.getValue());
            }
        }
    }

    public void bindHandlerByServer(ServerHandler serverHandler, Map<String, ServerRequestHandler> serverRequestHandlers) {
        for (ServerRequestHandler requestHandler : serverRequestHandlers.values()) {
            serverHandler.addServerRequestHandler(requestHandler);
        }
    }

    public void bindServerRequestActions(ServerRequestAction action, Map<String, String> context) {
        this.logger.debug(String.format(REGISTERED, action.getClass().getName()));
        String actionId = context.get("action");
        if (actionId != null && !this.requestActions.containsKey(actionId)) {
            this.requestActions.put(actionId, action);
            this.requestExecutors.values().stream().forEach(a -> a.setRequestAction(this.requestActions));
        }
    }

    public void unbindServerRequestActions(ServerRequestAction action, Map<String, String> context) {
        this.logger.debug(action.getClass().getName());
        String actionId = context.get("action");
        if (actionId != null && this.requestActions.containsKey(actionId)) {
            this.requestActions.remove(actionId, action);
            this.requestExecutors.values().stream().forEach(a -> a.setRequestAction(this.requestActions));
        }
    }
}

