/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base.request;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.passage.lbc.base.BaseComponent;
import org.eclipse.passage.lbc.runtime.ServerRequestAction;
import org.eclipse.passage.lbc.runtime.ServerRequestExecutor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LoggerFactory;

@Component
public class AdminRequestExecutor
extends BaseComponent
implements ServerRequestExecutor {
    private static final String MSG_REQUEST_ACTION_NOT_FOUND_ERROR = "Action id: %s not found";
    private static Map<String, ServerRequestAction> mapActionRequest = new HashMap<String, ServerRequestAction>();
    private String accessModeId = "";

    @Override
    @Reference
    protected void bindLogger(LoggerFactory loggerFactory) {
        super.bindLogger(loggerFactory);
    }

    public void executeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String actionId = request.getParameter("action");
        ServerRequestAction requestAction = mapActionRequest.get(actionId);
        if (requestAction != null) {
            requestAction.execute(request, response);
        } else {
            this.logger.info(String.format(MSG_REQUEST_ACTION_NOT_FOUND_ERROR, requestAction));
        }
    }

    public boolean checkAccesstMode(HttpServletRequest baseRequest) {
        String requestAccessMode = baseRequest.getParameter("mode");
        return requestAccessMode != null && requestAccessMode.equals(this.accessModeId);
    }

    public void setRequestAction(Map<String, ServerRequestAction> mapActions) {
        mapActionRequest.putAll(mapActions);
    }

    public void setAccessModeId(String accessModeId) {
        this.accessModeId = accessModeId;
    }
}

