/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base.condition;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.passage.lbc.base.BaseComponent;
import org.eclipse.passage.lbc.base.condition.ConditionTimerTask;
import org.eclipse.passage.lic.base.access.FeaturePermissions;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.LicensingException;
import org.eclipse.passage.lic.runtime.access.FeaturePermission;
import org.eclipse.passage.lic.runtime.access.PermissionEmitter;
import org.eclipse.passage.lic.runtime.conditions.ConditionMiner;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.log.LoggerFactory;

@Component
public class ServerConditionsDistributor
extends BaseComponent
implements PermissionEmitter {
    private final List<ConditionMiner> miners = new ArrayList<ConditionMiner>();
    private final List<LicensingCondition> lockedConditions = new ArrayList<LicensingCondition>();
    private final List<ConditionTimerTask> conditionTasks = new ArrayList<ConditionTimerTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<FeaturePermission> emitPermissions(LicensingConfiguration configuration, Iterable<LicensingCondition> conditions) throws LicensingException {
        ArrayList<FeaturePermission> permissionsResult = new ArrayList<FeaturePermission>();
        for (LicensingCondition condition : conditions) {
            boolean conditionExists = this.checkExistense(condition, configuration);
            if (!conditionExists) continue;
            LicensingCondition licensingCondition = condition;
            synchronized (licensingCondition) {
                boolean conditionIsLocked;
                if (condition.getConditionType() == "time" && !(conditionIsLocked = this.lockedConditions.contains(condition))) {
                    FeaturePermission createFeaturePermition = this.createFeaturePermission(condition, configuration);
                    this.launchFeaturePermissionTask(condition, createFeaturePermition);
                    this.lockCondition(condition);
                    permissionsResult.add(createFeaturePermition);
                }
            }
        }
        return permissionsResult;
    }

    private void launchFeaturePermissionTask(final LicensingCondition condition, FeaturePermission createFeaturePermition) {
        String conditionLeaseTime = condition.getConditionExpression();
        ConditionTimerTask task = new ConditionTimerTask(conditionLeaseTime){

            @Override
            void timeExpired() {
                ServerConditionsDistributor.this.unlockCondition(condition);
            }
        };
        this.conditionTasks.add(task);
        task.run();
    }

    private synchronized void unlockCondition(LicensingCondition condition) {
        if (this.lockedConditions.contains(condition)) {
            this.lockedConditions.remove(condition);
        }
    }

    private synchronized void lockCondition(LicensingCondition condition) {
        this.lockedConditions.add(condition);
    }

    private FeaturePermission createFeaturePermission(LicensingCondition condition, LicensingConfiguration configuration) {
        long leaseTime = System.currentTimeMillis();
        long expireTime = leaseTime + 3600000L;
        java.sql.Date lease = new java.sql.Date(leaseTime);
        java.sql.Date expire = new java.sql.Date(expireTime);
        FeaturePermission permission = FeaturePermissions.create((LicensingConfiguration)configuration, (LicensingCondition)condition, (Date)lease, (Date)expire);
        return permission;
    }

    private boolean checkExistense(LicensingCondition condition, LicensingConfiguration configuration) {
        for (ConditionMiner miner : this.miners) {
            Iterable extracted = miner.extractLicensingConditions(configuration);
            for (LicensingCondition extractedCondition : extracted) {
                if (!condition.equals(extractedCondition)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Reference
    protected void bindLogger(LoggerFactory loggerFactory) {
        super.bindLogger(loggerFactory);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindConditionMiner(ConditionMiner miner) {
        if (!this.miners.contains(miner)) {
            this.miners.add(miner);
        }
    }

    public void unbindConditionMiner(ConditionMiner miner) {
        if (this.miners.contains(miner)) {
            this.miners.remove(miner);
        }
    }
}

