/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSuback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class Token {
    private static final String CLASS_NAME = Token.class.getName();
    private static final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private volatile boolean completed = false;
    private boolean pendingComplete = false;
    private boolean sent = false;
    private Object responseLock = new Object();
    private Object sentLock = new Object();
    protected MqttMessage message = null;
    private MqttWireMessage response = null;
    private MqttException exception = null;
    private String[] topics = null;
    private String key;
    private IMqttAsyncClient client = null;
    private IMqttActionListener callback = null;
    private Object userContext = null;
    private int messageID = 0;
    private boolean notified = false;

    public Token(String logContext) {
        log.setResourceName(logContext);
    }

    public int getMessageID() {
        return this.messageID;
    }

    public void setMessageID(int messageID) {
        this.messageID = messageID;
    }

    public boolean checkResult() throws MqttException {
        if (this.getException() != null) {
            throw this.getException();
        }
        return true;
    }

    public MqttException getException() {
        return this.exception;
    }

    public boolean isComplete() {
        return this.completed;
    }

    protected boolean isCompletePending() {
        return this.pendingComplete;
    }

    protected boolean isInUse() {
        return this.getClient() != null && !this.isComplete();
    }

    public void setActionCallback(IMqttActionListener listener) {
        this.callback = listener;
    }

    public IMqttActionListener getActionCallback() {
        return this.callback;
    }

    public void waitForCompletion() throws MqttException {
        this.waitForCompletion(-1L);
    }

    public void waitForCompletion(long timeout) throws MqttException {
        log.fine(CLASS_NAME, "waitForCompletion", "407", new Object[]{this.getKey(), timeout, this});
        MqttWireMessage resp = this.waitForResponse(timeout);
        if (resp == null && !this.completed) {
            log.fine(CLASS_NAME, "waitForCompletion", "406", new Object[]{this.getKey(), this});
            this.exception = new MqttException(32000);
            throw this.exception;
        }
        this.checkResult();
    }

    protected MqttWireMessage waitForResponse() throws MqttException {
        return this.waitForResponse(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttWireMessage waitForResponse(long timeout) throws MqttException {
        Object object = this.responseLock;
        synchronized (object) {
            log.fine(CLASS_NAME, "waitForResponse", "400", new Object[]{this.getKey(), timeout, this.sent, this.completed, this.exception == null ? "false" : "true", this.response, this}, this.exception);
            while (!this.completed) {
                if (this.exception == null) {
                    try {
                        log.fine(CLASS_NAME, "waitForResponse", "408", new Object[]{this.getKey(), new Long(timeout)});
                        if (timeout <= 0L) {
                            this.responseLock.wait();
                        } else {
                            this.responseLock.wait(timeout);
                        }
                    }
                    catch (InterruptedException e) {
                        this.exception = new MqttException(e);
                    }
                }
                if (this.completed) continue;
                if (this.exception != null) {
                    log.fine(CLASS_NAME, "waitForResponse", "401", null, this.exception);
                    throw this.exception;
                }
                if (timeout > 0L) break;
            }
        }
        log.fine(CLASS_NAME, "waitForResponse", "402", new Object[]{this.getKey(), this.response});
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markComplete(MqttWireMessage msg, MqttException ex) {
        log.fine(CLASS_NAME, "markComplete", "404", new Object[]{this.getKey(), msg, ex});
        Object object = this.responseLock;
        synchronized (object) {
            if (msg instanceof MqttAck) {
                this.message = null;
            }
            this.pendingComplete = true;
            this.response = msg;
            this.exception = ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyComplete() {
        log.fine(CLASS_NAME, "notifyComplete", "404", new Object[]{this.getKey(), this.response, this.exception});
        Object object = this.responseLock;
        synchronized (object) {
            if (this.exception == null && this.pendingComplete) {
                this.completed = true;
                this.pendingComplete = false;
            } else {
                this.pendingComplete = false;
            }
            this.responseLock.notifyAll();
        }
        object = this.sentLock;
        synchronized (object) {
            this.sent = true;
            this.sentLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void waitUntilSent() throws MqttException {
        var1_1 = this.sentLock;
        synchronized (var1_1) {
            var2_2 = this.responseLock;
            synchronized (var2_2) {
                if (this.exception != null) {
                    throw this.exception;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                if (true) ** GOTO lbl19
            }
            do {
                try {
                    Token.log.fine(Token.CLASS_NAME, "waitUntilSent", "409", new Object[]{this.getKey()});
                    this.sentLock.wait();
                }
                catch (InterruptedException v1) {}
lbl19:
                // 3 sources

            } while (!this.sent);
            if (!this.sent) {
                if (this.exception == null) {
                    throw ExceptionHelper.createMqttException(6);
                }
                throw this.exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySent() {
        log.fine(CLASS_NAME, "notifySent", "403", new Object[]{this.getKey()});
        Object object = this.responseLock;
        synchronized (object) {
            this.response = null;
            this.completed = false;
        }
        object = this.sentLock;
        synchronized (object) {
            this.sent = true;
            this.sentLock.notifyAll();
        }
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    protected void setClient(IMqttAsyncClient client) {
        this.client = client;
    }

    public void reset() throws MqttException {
        if (this.isInUse()) {
            throw new MqttException(32201);
        }
        log.fine(CLASS_NAME, "reset", "410", new Object[]{this.getKey()});
        this.client = null;
        this.completed = false;
        this.response = null;
        this.sent = false;
        this.exception = null;
        this.userContext = null;
    }

    public MqttMessage getMessage() {
        return this.message;
    }

    public MqttWireMessage getWireMessage() {
        return this.response;
    }

    public void setMessage(MqttMessage msg) {
        this.message = msg;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void setTopics(String[] topics) {
        this.topics = (String[])topics.clone();
    }

    public Object getUserContext() {
        return this.userContext;
    }

    public void setUserContext(Object userContext) {
        this.userContext = userContext;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(MqttException exception) {
        Object object = this.responseLock;
        synchronized (object) {
            this.exception = exception;
        }
    }

    public boolean isNotified() {
        return this.notified;
    }

    public void setNotified(boolean notified) {
        this.notified = notified;
    }

    public String toString() {
        StringBuffer tok = new StringBuffer();
        tok.append("key=").append(this.getKey());
        tok.append(" ,topics=");
        if (this.getTopics() != null) {
            int i = 0;
            while (i < this.getTopics().length) {
                tok.append(this.getTopics()[i]).append(", ");
                ++i;
            }
        }
        tok.append(" ,usercontext=").append(this.getUserContext());
        tok.append(" ,isComplete=").append(this.isComplete());
        tok.append(" ,isNotified=").append(this.isNotified());
        tok.append(" ,exception=").append(this.getException());
        tok.append(" ,actioncallback=").append(this.getActionCallback());
        return tok.toString();
    }

    public int[] getGrantedQos() {
        int[] val = new int[]{};
        if (this.response instanceof MqttSuback) {
            val = ((MqttSuback)this.response).getGrantedQos();
        }
        return val;
    }

    public boolean getSessionPresent() {
        boolean val = false;
        if (this.response instanceof MqttConnack) {
            val = ((MqttConnack)this.response).getSessionPresent();
        }
        return val;
    }

    public MqttWireMessage getResponse() {
        return this.response;
    }
}

