/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.sample.utility;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;

public class LED
extends Panel
implements Runnable {
    private static final int[] xOutline = new int[]{2, 3, 4, 8, 9, 10, 10, 9, 9, 8, 7, 3, 2, 2, 1, 1, 2};
    private static final int[] yOutline = new int[]{2, 2, 1, 1, 2, 3, 7, 8, 9, 9, 10, 10, 9, 8, 7, 4, 3};
    private static final int nOutline = xOutline.length;
    private static final int[] xHighlight = new int[]{6, 7, 7, 8, 8};
    private static final int[] yHighlight = new int[]{8, 8, 7, 7, 6};
    private static final int nHighlight = xHighlight.length;
    private static final int[] xOfflight = new int[]{3, 7, 8, 9, 9, 8, 8, 7, 6, 5, 4};
    private static final int[] yOfflight = new int[]{9, 9, 8, 7, 3, 4, 5, 6, 7, 8, 8};
    private static final int nOfflight = xOfflight.length;
    private static final Color OfflightColour = new Color(91, 91, 91);
    private static final int delay = 500;
    private boolean running = true;
    private static final Colours amberColours = new Colours(new Color(240, 168, 0), new Color(95, 64, 0), new Color(240, 224, 112));
    private static final Colours redColours = new Colours(new Color(240, 0, 0), new Color(63, 0, 0), new Color(255, 104, 111));
    private static final Colours greenColours = new Colours(new Color(0, 176, 0), new Color(0, 48, 0), new Color(79, 248, 80));
    private static final Colours offColours = new Colours(new Color(25, 25, 25), new Color(25, 25, 25), new Color(166, 166, 166), new Color(17, 17, 17));
    private Colours state;
    private boolean flashing;
    private boolean off;

    public LED() {
        this.setOff();
        this.setSize(20, 20);
    }

    public LED(LayoutManager layout) {
        super(layout);
    }

    @Override
    public void paint(Graphics g) {
        Colours draw = this.off ? offColours : this.state;
        g.setColor(draw.mainColour);
        g.fillRect(2, 2, 8, 8);
        g.setColor(draw.outerColour);
        g.drawPolyline(xOutline, yOutline, nOutline);
        g.setColor(draw.shadowColour);
        g.drawLine(6, 11, 11, 11);
        g.drawLine(8, 10, 11, 10);
        g.drawLine(10, 9, 12, 9);
        g.drawLine(10, 8, 11, 8);
        g.drawLine(11, 6, 11, 7);
        g.drawLine(9, 12, 9, 12);
        g.drawLine(3, 1, 3, 1);
        g.drawLine(8, 1, 8, 1);
        g.drawLine(10, 3, 10, 3);
        g.drawLine(3, 10, 3, 10);
        g.drawLine(1, 8, 1, 8);
        g.drawLine(1, 3, 1, 3);
        g.setColor(draw.highlightColour);
        g.drawLine(3, 3, 4, 4);
        g.drawPolyline(xHighlight, yHighlight, nHighlight);
        g.setColor(Colours.glintColour);
        g.drawLine(3, 4, 4, 3);
        if (this.off) {
            g.setColor(OfflightColour);
            g.drawPolyline(xOfflight, yOfflight, nOfflight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.flashing) {
                this.off = !this.off;
                this.repaint();
                continue;
            }
            LED lED = this;
            synchronized (lED) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setAmber() {
        this.state = amberColours;
        this.off = false;
        this.repaint();
    }

    public void setColor(int r, int g, int b) {
        Color mainColour = new Color(r, g, b);
        Color outerColour = mainColour.darker().darker().darker();
        Color highlightColour = new Color(148, 148, 148);
        this.state = new Colours(mainColour, outerColour, highlightColour);
        this.off = false;
        this.repaint();
    }

    public boolean isFlashing() {
        return this.flashing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlash() {
        this.flashing = !this.flashing;
        LED lED = this;
        synchronized (lED) {
            this.notify();
        }
        this.repaint();
    }

    public void setGreen() {
        this.state = greenColours;
        this.off = false;
        this.repaint();
    }

    public void setOff() {
        this.off = true;
        this.flashing = false;
        this.repaint();
    }

    public void setRed() {
        this.state = redColours;
        this.off = false;
        this.repaint();
    }

    static class Colours {
        public Color mainColour;
        public Color outerColour;
        public Color highlightColour;
        public Color shadowColour = new Color(47, 0, 0);
        public static final Color glintColour = new Color(255, 248, 255);

        Colours(Color main, Color outer, Color highlight) {
            this.mainColour = main;
            this.outerColour = outer;
            this.highlightColour = highlight;
        }

        Colours(Color main, Color outer, Color highlight, Color shadow) {
            this.mainColour = main;
            this.outerColour = outer;
            this.highlightColour = highlight;
            this.shadowColour = shadow;
        }
    }
}

