/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.sample.utility;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import org.eclipse.paho.sample.utility.MQTTFrame;

public class ConnOpts
extends JPanel
implements ActionListener {
    private static final String CLIENT_ID = "MQTT_Utility";
    private static final String KEEP_ALIVE = "30";
    private static final String RETRY_INT = "10";
    private static final String DEF_PERSIST_DIR = ".";
    private MQTTFrame mqisdpMgr = null;
    private JButton trace;
    private JCheckBox cleanSession;
    private JCheckBox persistEnable;
    private JTextField clientId;
    private JTextField keepAlive;
    private JTextField retryInterval;
    private JTextField lwtTopic;
    private JTextField persistDir;
    private JTextArea lwtData;
    private JCheckBox lwtRetain;
    private JComboBox lwtQoS;
    private Integer[] qos = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};

    public ConnOpts(MQTTFrame mgr, Properties props) {
        this.mqisdpMgr = mgr;
        ConnOpts connOptions = this;
        connOptions.setLayout(new BorderLayout());
        this.cleanSession = new JCheckBox();
        this.cleanSession.setSelected(true);
        this.clientId = new JTextField(props.getProperty("ClientId", CLIENT_ID), 15);
        this.clientId.setMaximumSize(MQTTFrame.TEXT_FIELD_DIMENSION);
        this.persistEnable = new JCheckBox();
        Boolean b = new Boolean(props.getProperty("Persistence", String.valueOf(false)));
        this.persistEnable.setSelected(b);
        this.persistEnable.setToolTipText("Persist publications to ensure delivery");
        JButton reset = new JButton("Default");
        reset.addActionListener(this);
        reset.setToolTipText("Options will be set to default");
        JPanel top = new JPanel();
        top.setBorder(new EtchedBorder());
        top.setLayout(new GridLayout(6, 1));
        JLabel optsLabel = new JLabel("Session Options:    ", 2);
        Font f = optsLabel.getFont();
        optsLabel.setFont(new Font(f.getName(), 1, f.getSize() + 1));
        this.trace = new JButton("Trace(Start)");
        this.trace.addActionListener(this);
        JPanel optsLabelAndTrace = new JPanel();
        optsLabelAndTrace.setLayout(new FlowLayout(0));
        optsLabelAndTrace.add(optsLabel);
        optsLabelAndTrace.add(this.trace);
        JPanel cid = new JPanel();
        cid.setLayout(new FlowLayout(0));
        cid.add(new JLabel("Client Identifier:", 2));
        cid.add(this.clientId);
        JPanel clnSess = new JPanel();
        clnSess.setLayout(new FlowLayout(0));
        clnSess.add(new JLabel("Clean Session:", 2));
        clnSess.add(this.cleanSession);
        JPanel timeouts = new JPanel();
        timeouts.setLayout(new FlowLayout(0));
        timeouts.add(new JLabel("Keep Alive:", 2));
        this.keepAlive = new JTextField(4);
        this.keepAlive.setText(KEEP_ALIVE);
        timeouts.add(this.keepAlive);
        timeouts.add(new JLabel(" Retry Interval:", 2));
        this.retryInterval = new JTextField(4);
        this.retryInterval.setText(RETRY_INT);
        timeouts.add(this.retryInterval);
        timeouts.add(new JLabel("seconds", 2));
        JPanel log = new JPanel();
        log.setLayout(new FlowLayout(0));
        log.add(new JLabel("Use persistence:", 2));
        log.add(this.persistEnable);
        this.persistDir = new JTextField(props.getProperty("PersistenceDir", DEF_PERSIST_DIR), 15);
        this.persistDir.setToolTipText("Enter the root directory for the log");
        log.add(new JLabel(" Directory:", 2));
        log.add(this.persistDir);
        top.add(optsLabelAndTrace);
        top.add(cid);
        top.add(clnSess);
        top.add(timeouts);
        top.add(log);
        JPanel middle = new JPanel();
        middle.setBorder(new EtchedBorder());
        middle.setLayout(new BorderLayout());
        this.lwtTopic = new JTextField(15);
        this.lwtTopic.setMaximumSize(MQTTFrame.TEXT_FIELD_DIMENSION);
        this.lwtTopic.setMargin(MQTTFrame.TEXT_MARGINS);
        this.lwtData = new JTextArea(3, 30);
        this.lwtData.setBorder(new BevelBorder(1));
        this.lwtData.setMargin(MQTTFrame.TEXT_MARGINS);
        this.lwtRetain = new JCheckBox();
        this.lwtRetain.setSelected(false);
        this.lwtQoS = new JComboBox<Integer>(this.qos);
        this.lwtQoS.setSelectedIndex(0);
        this.lwtQoS.setMaximumSize(MQTTFrame.DROP_DOWN_DIMENSION);
        JLabel lwtLabel = new JLabel("Last Will and Testament Settings:", 2);
        Font fnt = lwtLabel.getFont();
        lwtLabel.setFont(new Font(fnt.getName(), 1, fnt.getSize() + 1));
        JPanel lwtTopicOpts = new JPanel();
        lwtTopicOpts.setLayout(new BoxLayout(lwtTopicOpts, 0));
        lwtTopicOpts.add(new JLabel("Topic:"));
        lwtTopicOpts.add(this.lwtTopic);
        lwtTopicOpts.add(new JLabel(" QoS:"));
        lwtTopicOpts.add(this.lwtQoS);
        lwtTopicOpts.add(new JLabel(" Retained:"));
        lwtTopicOpts.add(this.lwtRetain);
        JPanel lwtNorth = new JPanel();
        lwtNorth.setLayout(new GridLayout(2, 1));
        lwtNorth.add(lwtLabel);
        lwtNorth.add(lwtTopicOpts);
        middle.add((Component)lwtNorth, "North");
        middle.add((Component)new JScrollPane(this.lwtData), "Center");
        JPanel bottom = new JPanel();
        bottom.setBorder(new EtchedBorder());
        bottom.add(reset);
        connOptions.add((Component)top, "North");
        connOptions.add((Component)middle, "Center");
        connOptions.add((Component)bottom, "South");
    }

    public boolean isCleanSessionSelected() {
        return this.cleanSession.isSelected();
    }

    public String getClientID() {
        return this.clientId.getText();
    }

    public boolean isPersistenceSelected() {
        return this.persistEnable.isSelected();
    }

    public String getPersistenceDirectory() {
        return this.persistDir.getText();
    }

    public short getKeepAlive() {
        Integer i;
        try {
            i = new Integer(this.keepAlive.getText());
        }
        catch (NumberFormatException e) {
            this.keepAlive.setText(KEEP_ALIVE);
            return 30;
        }
        return i.shortValue();
    }

    public int getRetryInterval() {
        Integer i;
        try {
            i = new Integer(this.retryInterval.getText());
        }
        catch (NumberFormatException e) {
            this.retryInterval.setText(RETRY_INT);
            return 10;
        }
        return i;
    }

    public boolean isLWTRetainSelected() {
        return this.lwtRetain.isSelected();
    }

    public boolean isLWTTopicSet() {
        return !this.lwtTopic.getText().equals("");
    }

    public String getLWTData() {
        return this.lwtData.getText();
    }

    public String getLWTTopic() {
        return this.lwtTopic.getText();
    }

    public int getLWTQoS() {
        return this.lwtQoS.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Trace(Start)")) {
            try {
                this.mqisdpMgr.startTrace();
                this.trace.setText("Trace(Stop)");
            }
            catch (Exception exception) {}
        } else if (e.getActionCommand().equals("Trace(Stop)")) {
            this.mqisdpMgr.stopTrace();
            this.trace.setText("Trace(Start)");
        } else {
            this.cleanSession.setSelected(true);
            this.clientId.setText(CLIENT_ID);
            this.keepAlive.setText(KEEP_ALIVE);
            this.lwtTopic.setText("");
            this.lwtData.setText("");
            this.lwtRetain.setSelected(false);
            this.lwtQoS.setSelectedIndex(0);
            this.persistEnable.setSelected(false);
            this.persistDir.setText(DEF_PERSIST_DIR);
        }
    }
}

