# expand-braces [![NPM version](https://badge.fury.io/js/expand-braces.svg)](http://badge.fury.io/js/expand-braces)

> Wrapper for [braces] to enable brace expansion for arrays of patterns.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i expand-braces --save
```

## Usage

```js
var expand = require('expand-braces');
```

Pass an array or list of strings:

```js
expand('{foo,bar}', '{baz,quux}');
// or
expand(['{foo,bar}', '{baz,quux}']);
// both yield => [ 'foo', 'bar', 'baz', 'quux' ];
```

Pass a function as the last argument to customize output:

```js
expand(['{a..e}', '{f..h}'], function (str) {
  return '_' + str;
});

//=> ['_a', '_b', '_c', '_d', '_e', '_f', '_g', '_h']
```

## Related projects

* [braces](https://www.npmjs.com/package/braces): Fastest brace expansion for node.js, with the most complete support for the Bash 4.3 braces… [more](https://www.npmjs.com/package/braces) | [homepage](https://github.com/jonschlinkert/braces)
* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern.… [more](https://www.npmjs.com/package/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob)
* [micromatch](https://www.npmjs.com/package/micromatch): Glob matching for javascript/node.js. A drop-in replacement and faster alternative to minimatch and multimatch. Just… [more](https://www.npmjs.com/package/micromatch) | [homepage](https://github.com/jonschlinkert/micromatch)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/expand-braces/issues/new).

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on October 31, 2015._