// This is a generated file, modify: generate/templates/templates/class_content.cc

#include <nan.h>
#include <string.h>

extern "C" {
#include <git2.h>
}

#include "../include/nodegit.h"
#include "../include/lock_master.h"
#include "../include/functions/copy.h"
#include "../include/tree.h"
#include "nodegit_wrapper.cc"
#include "../include/async_libgit2_queue_worker.h"

#include "../include/oid.h"
#include "../include/repository.h"
#include "../include/tree_update.h"
#include "../include/tree_entry.h"

#include <iostream>

using namespace std;
using namespace v8;
using namespace node;

GitTree::~GitTree()
{
  // this will cause an error if you have a non-self-freeing object that also needs
  // to save values. Since the object that will eventually free the object has no
  // way of knowing to free these values.
}

void GitTree::InitializeComponent(v8::Local<v8::Object> target)
{
  Nan::HandleScope scope;

  v8::Local<FunctionTemplate> tpl = Nan::New<FunctionTemplate>(JSNewFunction);

  tpl->InstanceTemplate()->SetInternalFieldCount(1);
  tpl->SetClassName(Nan::New("Tree").ToLocalChecked());

  Nan::SetPrototypeMethod(tpl, "createUpdated", CreateUpdated);
  Nan::SetPrototypeMethod(tpl, "dup", Dup);
  Nan::SetPrototypeMethod(tpl, "entryById", EntryByid);
  Nan::SetPrototypeMethod(tpl, "_entryByIndex", EntryByindex);
  Nan::SetPrototypeMethod(tpl, "_entryByName", EntryByname);
  Nan::SetPrototypeMethod(tpl, "entryByPath", EntryBypath);
  Nan::SetMethod(tpl, "entryCmp", EntryCmp);
  Nan::SetMethod(tpl, "entryDup", EntryDup);
  Nan::SetPrototypeMethod(tpl, "entryCount", Entrycount);
  Nan::SetPrototypeMethod(tpl, "free", Free);
  Nan::SetPrototypeMethod(tpl, "id", Id);
  Nan::SetMethod(tpl, "lookup", Lookup);
  Nan::SetMethod(tpl, "lookupPrefix", LookupPrefix);
  Nan::SetPrototypeMethod(tpl, "owner", Owner);

  InitializeTemplate(tpl);

  v8::Local<Function> _constructor_template = Nan::GetFunction(tpl).ToLocalChecked();
  constructor_template.Reset(_constructor_template);
  Nan::Set(target, Nan::New("Tree").ToLocalChecked(), _constructor_template);
}


/*
  * @param Repository repo
     * @param Number nupdates
   * @param TreeUpdate updates
    * @param Oid callback
   */
NAN_METHOD(GitTree::CreateUpdated)
{

  if (info.Length() == 0 || !info[0]->IsObject()) {
    return Nan::ThrowError("Repository repo is required.");
  }

  if (info.Length() == 1 || !info[1]->IsNumber()) {
    return Nan::ThrowError("Number nupdates is required.");
  }

  if (info.Length() == 2 || !info[2]->IsObject()) {
    return Nan::ThrowError("TreeUpdate updates is required.");
  }

  if (info.Length() == 3 || !info[3]->IsFunction()) {
    return Nan::ThrowError("Callback is required and must be a Function.");
  }

  CreateUpdatedBaton* baton = new CreateUpdatedBaton;

  baton->error_code = GIT_OK;
  baton->error = NULL;

  baton->out = (git_oid *)malloc(sizeof(git_oid ));
// start convert_from_v8 block
  git_repository * from_repo = NULL;
  from_repo = Nan::ObjectWrap::Unwrap<GitRepository>(info[0]->ToObject())->GetValue();
// end convert_from_v8 block
  baton->repo = from_repo;
  baton->baseline = Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue();
// start convert_from_v8 block
  size_t from_nupdates;
  from_nupdates = (size_t)   info[1]->ToNumber()->Value();
// end convert_from_v8 block
  baton->nupdates = from_nupdates;
// start convert_from_v8 block
  const git_tree_update * from_updates = NULL;
  from_updates = Nan::ObjectWrap::Unwrap<GitTreeUpdate>(info[2]->ToObject())->GetValue();
// end convert_from_v8 block
  baton->updates = from_updates;

  Nan::Callback *callback = new Nan::Callback(v8::Local<Function>::Cast(info[3]));
  CreateUpdatedWorker *worker = new CreateUpdatedWorker(baton, callback);
  if (!info[0]->IsUndefined() && !info[0]->IsNull())
    worker->SaveToPersistent("repo", info[0]->ToObject());
  worker->SaveToPersistent("baseline", info.This());
  if (!info[1]->IsUndefined() && !info[1]->IsNull())
    worker->SaveToPersistent("nupdates", info[1]->ToObject());
  if (!info[2]->IsUndefined() && !info[2]->IsNull())
    worker->SaveToPersistent("updates", info[2]->ToObject());

  AsyncLibgit2QueueWorker(worker);
  return;
}

void GitTree::CreateUpdatedWorker::Execute()
{
  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */true,baton->out
                                           ,baton->repo
                                           ,baton->baseline
                                           ,baton->updates
                         );

    int result = git_tree_create_updated(
                   baton->out,baton->repo,baton->baseline,baton->nupdates,baton->updates    );

    baton->error_code = result;

    if (result != GIT_OK && giterr_last() != NULL) {
      baton->error = git_error_dup(giterr_last());
    }

  }
}

void GitTree::CreateUpdatedWorker::HandleOKCallback()
{
  if (baton->error_code == GIT_OK) {
    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (baton->out != NULL) {
      // GitOid baton->out
      to = GitOid::New(baton->out, true  );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    v8::Local<v8::Value> result = to;
    v8::Local<v8::Value> argv[2] = {
      Nan::Null(),
      result
    };
    callback->Call(2, argv);
  } else {
    if (baton->error) {
      v8::Local<v8::Object> err;
      if (baton->error->message) {
        err = Nan::Error(baton->error->message)->ToObject();
      } else {
        err = Nan::Error("Method createUpdated has thrown an error.")->ToObject();
      }
      err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
      v8::Local<v8::Value> argv[1] = {
        err
      };
      callback->Call(1, argv);
      if (baton->error->message)
        free((void *)baton->error->message);
      free((void *)baton->error);
    } else if (baton->error_code < 0) {
      std::queue< v8::Local<v8::Value> > workerArguments;
      workerArguments.push(GetFromPersistent("repo"));
      workerArguments.push(GetFromPersistent("nupdates"));
      workerArguments.push(GetFromPersistent("updates"));
      bool callbackFired = false;
      while(!workerArguments.empty()) {
        v8::Local<v8::Value> node = workerArguments.front();
        workerArguments.pop();

        if (
          !node->IsObject()
          || node->IsArray()
          || node->IsBooleanObject()
          || node->IsDate()
          || node->IsFunction()
          || node->IsNumberObject()
          || node->IsRegExp()
          || node->IsStringObject()
        ) {
          continue;
        }

        v8::Local<v8::Object> nodeObj = node->ToObject();
        v8::Local<v8::Value> checkValue = GetPrivate(nodeObj, Nan::New("NodeGitPromiseError").ToLocalChecked());

        if (!checkValue.IsEmpty() && !checkValue->IsNull() && !checkValue->IsUndefined()) {
          v8::Local<v8::Value> argv[1] = {
            checkValue->ToObject()
          };
          callback->Call(1, argv);
          callbackFired = true;
          break;
        }

        v8::Local<v8::Array> properties = nodeObj->GetPropertyNames();
        for (unsigned int propIndex = 0; propIndex < properties->Length(); ++propIndex) {
          v8::Local<v8::String> propName = properties->Get(propIndex)->ToString();
          v8::Local<v8::Value> nodeToQueue = nodeObj->Get(propName);
          if (!nodeToQueue->IsUndefined()) {
            workerArguments.push(nodeToQueue);
          }
        }
      }

      if (!callbackFired) {
        v8::Local<v8::Object> err = Nan::Error("Method createUpdated has thrown an error.")->ToObject();
        err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
        v8::Local<v8::Value> argv[1] = {
          err
        };
        callback->Call(1, argv);
      }
    } else {
      callback->Call(0, NULL);
    }

  }


  delete baton;
}


/*
     * @param Tree callback
   */
NAN_METHOD(GitTree::Dup)
{

  if (info.Length() == 0 || !info[0]->IsFunction()) {
    return Nan::ThrowError("Callback is required and must be a Function.");
  }

  DupBaton* baton = new DupBaton;

  baton->error_code = GIT_OK;
  baton->error = NULL;

  baton->source = Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue();

  Nan::Callback *callback = new Nan::Callback(v8::Local<Function>::Cast(info[0]));
  DupWorker *worker = new DupWorker(baton, callback);
  worker->SaveToPersistent("source", info.This());

  AsyncLibgit2QueueWorker(worker);
  return;
}

void GitTree::DupWorker::Execute()
{
  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */true,baton->source
                         );

    int result = git_tree_dup(
                   &baton->out,baton->source    );

    baton->error_code = result;

    if (result != GIT_OK && giterr_last() != NULL) {
      baton->error = git_error_dup(giterr_last());
    }

  }
}

void GitTree::DupWorker::HandleOKCallback()
{
  if (baton->error_code == GIT_OK) {
    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (baton->out != NULL) {
      // GitTree baton->out
      to = GitTree::New(baton->out, true  );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    v8::Local<v8::Value> result = to;
    v8::Local<v8::Value> argv[2] = {
      Nan::Null(),
      result
    };
    callback->Call(2, argv);
  } else {
    if (baton->error) {
      v8::Local<v8::Object> err;
      if (baton->error->message) {
        err = Nan::Error(baton->error->message)->ToObject();
      } else {
        err = Nan::Error("Method dup has thrown an error.")->ToObject();
      }
      err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
      v8::Local<v8::Value> argv[1] = {
        err
      };
      callback->Call(1, argv);
      if (baton->error->message)
        free((void *)baton->error->message);
      free((void *)baton->error);
    } else if (baton->error_code < 0) {
      std::queue< v8::Local<v8::Value> > workerArguments;
      bool callbackFired = false;
      while(!workerArguments.empty()) {
        v8::Local<v8::Value> node = workerArguments.front();
        workerArguments.pop();

        if (
          !node->IsObject()
          || node->IsArray()
          || node->IsBooleanObject()
          || node->IsDate()
          || node->IsFunction()
          || node->IsNumberObject()
          || node->IsRegExp()
          || node->IsStringObject()
        ) {
          continue;
        }

        v8::Local<v8::Object> nodeObj = node->ToObject();
        v8::Local<v8::Value> checkValue = GetPrivate(nodeObj, Nan::New("NodeGitPromiseError").ToLocalChecked());

        if (!checkValue.IsEmpty() && !checkValue->IsNull() && !checkValue->IsUndefined()) {
          v8::Local<v8::Value> argv[1] = {
            checkValue->ToObject()
          };
          callback->Call(1, argv);
          callbackFired = true;
          break;
        }

        v8::Local<v8::Array> properties = nodeObj->GetPropertyNames();
        for (unsigned int propIndex = 0; propIndex < properties->Length(); ++propIndex) {
          v8::Local<v8::String> propName = properties->Get(propIndex)->ToString();
          v8::Local<v8::Value> nodeToQueue = nodeObj->Get(propName);
          if (!nodeToQueue->IsUndefined()) {
            workerArguments.push(nodeToQueue);
          }
        }
      }

      if (!callbackFired) {
        v8::Local<v8::Object> err = Nan::Error("Method dup has thrown an error.")->ToObject();
        err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
        v8::Local<v8::Value> argv[1] = {
          err
        };
        callback->Call(1, argv);
      }
    } else {
      callback->Call(0, NULL);
    }

  }


  delete baton;
}


/*
   * @param Oid id
     * @return TreeEntry  result    */
NAN_METHOD(GitTree::EntryByid)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0
      || (!info[0]->IsObject() && !info[0]->IsString())) {
    return Nan::ThrowError("Oid id is required.");
  }
// start convert_from_v8 block
  const git_oid * from_id = NULL;
  if (info[0]->IsString()) {
    // Try and parse in a string to a git_oid
    String::Utf8Value oidString(info[0]->ToString());
    git_oid *oidOut = (git_oid *)malloc(sizeof(git_oid));

    if (git_oid_fromstr(oidOut, (const char *) strdup(*oidString)) != GIT_OK) {
      free(oidOut);

      if (giterr_last()) {
        return Nan::ThrowError(giterr_last()->message);
      } else {
        return Nan::ThrowError("Unknown Error");
      }
    }

    from_id = oidOut;
  } else {
    from_id = Nan::ObjectWrap::Unwrap<GitOid>(info[0]->ToObject())->GetValue();
  }
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                                           ,    from_id
                         );

    const git_tree_entry * result = git_tree_entry_byid(
                                      Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                                      ,  from_id
                                    );

    if (info[0]->IsString()) {
      free((void *)from_id);
    }
    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // GitTreeEntry result
      to = GitTreeEntry::New(result, true, info.This() );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
   * @param Number idx
     * @return TreeEntry  result    */
NAN_METHOD(GitTree::EntryByindex)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsNumber()) {
    return Nan::ThrowError("Number idx is required.");
  }

// start convert_from_v8 block
  size_t from_idx;
  from_idx = (size_t)   info[0]->ToNumber()->Value();
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                         );

    const git_tree_entry * result = git_tree_entry_byindex(
                                      Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                                      ,  from_idx
                                    );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // GitTreeEntry result
      to = GitTreeEntry::New(result, true, info.This() );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
   * @param String filename
     * @return TreeEntry  result    */
NAN_METHOD(GitTree::EntryByname)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsString()) {
    return Nan::ThrowError("String filename is required.");
  }

// start convert_from_v8 block
  const char * from_filename = NULL;

  String::Utf8Value filename(info[0]->ToString());
  // malloc with one extra byte so we can add the terminating null character C-strings expect:
  from_filename = (const char *) malloc(filename.length() + 1);
  // copy the characters from the nodejs string into our C-string (used instead of strdup or strcpy because nulls in
  // the middle of strings are valid coming from nodejs):
  memcpy((void *)from_filename, *filename, filename.length());
  // ensure the final byte of our new string is null, extra casts added to ensure compatibility with various C types
  // used in the nodejs binding generation:
  memset((void *)(((char *)from_filename) + filename.length()), 0, 1);
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                                           ,    from_filename
                         );

    const git_tree_entry * result = git_tree_entry_byname(
                                      Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                                      ,  from_filename
                                    );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // GitTreeEntry result
      to = GitTreeEntry::New(result, true, info.This() );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
    * @param String path
    * @param TreeEntry callback
   */
NAN_METHOD(GitTree::EntryBypath)
{

  if (info.Length() == 0 || !info[0]->IsString()) {
    return Nan::ThrowError("String path is required.");
  }

  if (info.Length() == 1 || !info[1]->IsFunction()) {
    return Nan::ThrowError("Callback is required and must be a Function.");
  }

  EntryBypathBaton* baton = new EntryBypathBaton;

  baton->error_code = GIT_OK;
  baton->error = NULL;

  baton->root = Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue();
// start convert_from_v8 block
  const char * from_path = NULL;

  String::Utf8Value path(info[0]->ToString());
  // malloc with one extra byte so we can add the terminating null character C-strings expect:
  from_path = (const char *) malloc(path.length() + 1);
  // copy the characters from the nodejs string into our C-string (used instead of strdup or strcpy because nulls in
  // the middle of strings are valid coming from nodejs):
  memcpy((void *)from_path, *path, path.length());
  // ensure the final byte of our new string is null, extra casts added to ensure compatibility with various C types
  // used in the nodejs binding generation:
  memset((void *)(((char *)from_path) + path.length()), 0, 1);
// end convert_from_v8 block
  baton->path = from_path;

  Nan::Callback *callback = new Nan::Callback(v8::Local<Function>::Cast(info[1]));
  EntryBypathWorker *worker = new EntryBypathWorker(baton, callback);
  worker->SaveToPersistent("root", info.This());
  if (!info[0]->IsUndefined() && !info[0]->IsNull())
    worker->SaveToPersistent("path", info[0]->ToObject());

  AsyncLibgit2QueueWorker(worker);
  return;
}

void GitTree::EntryBypathWorker::Execute()
{
  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */true,baton->root
                                           ,baton->path
                         );

    int result = git_tree_entry_bypath(
                   &baton->out,baton->root,baton->path    );

    baton->error_code = result;

    if (result != GIT_OK && giterr_last() != NULL) {
      baton->error = git_error_dup(giterr_last());
    }

  }
}

void GitTree::EntryBypathWorker::HandleOKCallback()
{
  if (baton->error_code == GIT_OK) {
    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (baton->out != NULL) {
      // GitTreeEntry baton->out
      to = GitTreeEntry::New(baton->out, true  );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    v8::Local<v8::Value> result = to;
    v8::Local<v8::Value> argv[2] = {
      Nan::Null(),
      result
    };
    callback->Call(2, argv);
  } else {
    if (baton->error) {
      v8::Local<v8::Object> err;
      if (baton->error->message) {
        err = Nan::Error(baton->error->message)->ToObject();
      } else {
        err = Nan::Error("Method entryByPath has thrown an error.")->ToObject();
      }
      err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
      v8::Local<v8::Value> argv[1] = {
        err
      };
      callback->Call(1, argv);
      if (baton->error->message)
        free((void *)baton->error->message);
      free((void *)baton->error);
    } else if (baton->error_code < 0) {
      std::queue< v8::Local<v8::Value> > workerArguments;
      workerArguments.push(GetFromPersistent("path"));
      bool callbackFired = false;
      while(!workerArguments.empty()) {
        v8::Local<v8::Value> node = workerArguments.front();
        workerArguments.pop();

        if (
          !node->IsObject()
          || node->IsArray()
          || node->IsBooleanObject()
          || node->IsDate()
          || node->IsFunction()
          || node->IsNumberObject()
          || node->IsRegExp()
          || node->IsStringObject()
        ) {
          continue;
        }

        v8::Local<v8::Object> nodeObj = node->ToObject();
        v8::Local<v8::Value> checkValue = GetPrivate(nodeObj, Nan::New("NodeGitPromiseError").ToLocalChecked());

        if (!checkValue.IsEmpty() && !checkValue->IsNull() && !checkValue->IsUndefined()) {
          v8::Local<v8::Value> argv[1] = {
            checkValue->ToObject()
          };
          callback->Call(1, argv);
          callbackFired = true;
          break;
        }

        v8::Local<v8::Array> properties = nodeObj->GetPropertyNames();
        for (unsigned int propIndex = 0; propIndex < properties->Length(); ++propIndex) {
          v8::Local<v8::String> propName = properties->Get(propIndex)->ToString();
          v8::Local<v8::Value> nodeToQueue = nodeObj->Get(propName);
          if (!nodeToQueue->IsUndefined()) {
            workerArguments.push(nodeToQueue);
          }
        }
      }

      if (!callbackFired) {
        v8::Local<v8::Object> err = Nan::Error("Method entryByPath has thrown an error.")->ToObject();
        err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
        v8::Local<v8::Value> argv[1] = {
          err
        };
        callback->Call(1, argv);
      }
    } else {
      callback->Call(0, NULL);
    }

  }


  delete baton;
}


/*
 * @param TreeEntry e1
   * @param TreeEntry e2
     * @return Number  result    */
NAN_METHOD(GitTree::EntryCmp)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsObject()) {
    return Nan::ThrowError("TreeEntry e1 is required.");
  }

  if (info.Length() == 1 || !info[1]->IsObject()) {
    return Nan::ThrowError("TreeEntry e2 is required.");
  }

// start convert_from_v8 block
  const git_tree_entry * from_e1 = NULL;
  from_e1 = Nan::ObjectWrap::Unwrap<GitTreeEntry>(info[0]->ToObject())->GetValue();
// end convert_from_v8 block
// start convert_from_v8 block
  const git_tree_entry * from_e2 = NULL;
  from_e2 = Nan::ObjectWrap::Unwrap<GitTreeEntry>(info[1]->ToObject())->GetValue();
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    from_e1
                                           ,    from_e2
                         );

    int result = git_tree_entry_cmp(
                   from_e1
                   ,  from_e2
                 );


    v8::Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
 * @param TreeEntry dest
   * @param TreeEntry source
     * @return Number  result    */
NAN_METHOD(GitTree::EntryDup)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsObject()) {
    return Nan::ThrowError("TreeEntry dest is required.");
  }

  if (info.Length() == 1 || !info[1]->IsObject()) {
    return Nan::ThrowError("TreeEntry source is required.");
  }

// start convert_from_v8 block
  git_tree_entry ** from_dest = NULL;
  *from_dest = Nan::ObjectWrap::Unwrap<GitTreeEntry>(info[0]->ToObject())->GetValue();
// end convert_from_v8 block
// start convert_from_v8 block
  const git_tree_entry * from_source = NULL;
  from_source = Nan::ObjectWrap::Unwrap<GitTreeEntry>(info[1]->ToObject())->GetValue();
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    from_dest
                                           ,    from_source
                         );

    int result = git_tree_entry_dup(
                   from_dest
                   ,  from_source
                 );


    v8::Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @return Number  result    */
NAN_METHOD(GitTree::Entrycount)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                         );

    size_t result = git_tree_entrycount(
                      Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                    );


    v8::Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     */
NAN_METHOD(GitTree::Free)
{
  Nan::EscapableHandleScope scope;

  if (Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue() != NULL) {

    giterr_clear();

    {
      LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                           );

      git_tree_free(
        Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
      );

      Nan::ObjectWrap::Unwrap<GitTree>(info.This())->ClearValue();
    }
    return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
  }
}

/*
     * @return Oid  result    */
NAN_METHOD(GitTree::Id)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                         );

    const git_oid * result = git_tree_id(
                               Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                             );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // GitOid result
      to = GitOid::New(result, true, info.This() );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
  * @param Repository repo
   * @param Oid id
    * @param Tree callback
   */
NAN_METHOD(GitTree::Lookup)
{

  if (info.Length() == 0 || !info[0]->IsObject()) {
    return Nan::ThrowError("Repository repo is required.");
  }

  if (info.Length() == 1
      || (!info[1]->IsObject() && !info[1]->IsString())) {
    return Nan::ThrowError("Oid id is required.");
  }
  if (info.Length() == 2 || !info[2]->IsFunction()) {
    return Nan::ThrowError("Callback is required and must be a Function.");
  }

  LookupBaton* baton = new LookupBaton;

  baton->error_code = GIT_OK;
  baton->error = NULL;

// start convert_from_v8 block
  git_repository * from_repo = NULL;
  from_repo = Nan::ObjectWrap::Unwrap<GitRepository>(info[0]->ToObject())->GetValue();
// end convert_from_v8 block
  baton->repo = from_repo;
// start convert_from_v8 block
  const git_oid * from_id = NULL;
  if (info[1]->IsString()) {
    // Try and parse in a string to a git_oid
    String::Utf8Value oidString(info[1]->ToString());
    git_oid *oidOut = (git_oid *)malloc(sizeof(git_oid));

    if (git_oid_fromstr(oidOut, (const char *) strdup(*oidString)) != GIT_OK) {
      free(oidOut);

      if (giterr_last()) {
        return Nan::ThrowError(giterr_last()->message);
      } else {
        return Nan::ThrowError("Unknown Error");
      }
    }

    from_id = oidOut;
  } else {
    from_id = Nan::ObjectWrap::Unwrap<GitOid>(info[1]->ToObject())->GetValue();
  }
// end convert_from_v8 block
  baton->id = from_id;
  baton->idNeedsFree = info[1]->IsString();

  Nan::Callback *callback = new Nan::Callback(v8::Local<Function>::Cast(info[2]));
  LookupWorker *worker = new LookupWorker(baton, callback);
  if (!info[0]->IsUndefined() && !info[0]->IsNull())
    worker->SaveToPersistent("repo", info[0]->ToObject());
  if (!info[1]->IsUndefined() && !info[1]->IsNull())
    worker->SaveToPersistent("id", info[1]->ToObject());

  AsyncLibgit2QueueWorker(worker);
  return;
}

void GitTree::LookupWorker::Execute()
{
  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */true,baton->repo
                                           ,baton->id
                         );

    int result = git_tree_lookup(
                   &baton->out,baton->repo,baton->id    );

    baton->error_code = result;

    if (result != GIT_OK && giterr_last() != NULL) {
      baton->error = git_error_dup(giterr_last());
    }

  }
}

void GitTree::LookupWorker::HandleOKCallback()
{
  if (baton->error_code == GIT_OK) {
    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (baton->out != NULL) {
      // GitTree baton->out
      to = GitTree::New(baton->out, true  );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    v8::Local<v8::Value> result = to;
    v8::Local<v8::Value> argv[2] = {
      Nan::Null(),
      result
    };
    callback->Call(2, argv);
  } else {
    if (baton->error) {
      v8::Local<v8::Object> err;
      if (baton->error->message) {
        err = Nan::Error(baton->error->message)->ToObject();
      } else {
        err = Nan::Error("Method lookup has thrown an error.")->ToObject();
      }
      err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
      v8::Local<v8::Value> argv[1] = {
        err
      };
      callback->Call(1, argv);
      if (baton->error->message)
        free((void *)baton->error->message);
      free((void *)baton->error);
    } else if (baton->error_code < 0) {
      std::queue< v8::Local<v8::Value> > workerArguments;
      workerArguments.push(GetFromPersistent("repo"));
      workerArguments.push(GetFromPersistent("id"));
      bool callbackFired = false;
      while(!workerArguments.empty()) {
        v8::Local<v8::Value> node = workerArguments.front();
        workerArguments.pop();

        if (
          !node->IsObject()
          || node->IsArray()
          || node->IsBooleanObject()
          || node->IsDate()
          || node->IsFunction()
          || node->IsNumberObject()
          || node->IsRegExp()
          || node->IsStringObject()
        ) {
          continue;
        }

        v8::Local<v8::Object> nodeObj = node->ToObject();
        v8::Local<v8::Value> checkValue = GetPrivate(nodeObj, Nan::New("NodeGitPromiseError").ToLocalChecked());

        if (!checkValue.IsEmpty() && !checkValue->IsNull() && !checkValue->IsUndefined()) {
          v8::Local<v8::Value> argv[1] = {
            checkValue->ToObject()
          };
          callback->Call(1, argv);
          callbackFired = true;
          break;
        }

        v8::Local<v8::Array> properties = nodeObj->GetPropertyNames();
        for (unsigned int propIndex = 0; propIndex < properties->Length(); ++propIndex) {
          v8::Local<v8::String> propName = properties->Get(propIndex)->ToString();
          v8::Local<v8::Value> nodeToQueue = nodeObj->Get(propName);
          if (!nodeToQueue->IsUndefined()) {
            workerArguments.push(nodeToQueue);
          }
        }
      }

      if (!callbackFired) {
        v8::Local<v8::Object> err = Nan::Error("Method lookup has thrown an error.")->ToObject();
        err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
        v8::Local<v8::Value> argv[1] = {
          err
        };
        callback->Call(1, argv);
      }
    } else {
      callback->Call(0, NULL);
    }

  }

  if (baton->idNeedsFree) {
    baton->idNeedsFree = false;
    free((void *)baton->id);
  }

  delete baton;
}


/*
  * @param Repository repo
   * @param Oid id
   * @param Number len
    * @param Tree callback
   */
NAN_METHOD(GitTree::LookupPrefix)
{

  if (info.Length() == 0 || !info[0]->IsObject()) {
    return Nan::ThrowError("Repository repo is required.");
  }

  if (info.Length() == 1
      || (!info[1]->IsObject() && !info[1]->IsString())) {
    return Nan::ThrowError("Oid id is required.");
  }
  if (info.Length() == 2 || !info[2]->IsNumber()) {
    return Nan::ThrowError("Number len is required.");
  }

  if (info.Length() == 3 || !info[3]->IsFunction()) {
    return Nan::ThrowError("Callback is required and must be a Function.");
  }

  LookupPrefixBaton* baton = new LookupPrefixBaton;

  baton->error_code = GIT_OK;
  baton->error = NULL;

// start convert_from_v8 block
  git_repository * from_repo = NULL;
  from_repo = Nan::ObjectWrap::Unwrap<GitRepository>(info[0]->ToObject())->GetValue();
// end convert_from_v8 block
  baton->repo = from_repo;
// start convert_from_v8 block
  const git_oid * from_id = NULL;
  if (info[1]->IsString()) {
    // Try and parse in a string to a git_oid
    String::Utf8Value oidString(info[1]->ToString());
    git_oid *oidOut = (git_oid *)malloc(sizeof(git_oid));

    if (git_oid_fromstr(oidOut, (const char *) strdup(*oidString)) != GIT_OK) {
      free(oidOut);

      if (giterr_last()) {
        return Nan::ThrowError(giterr_last()->message);
      } else {
        return Nan::ThrowError("Unknown Error");
      }
    }

    from_id = oidOut;
  } else {
    from_id = Nan::ObjectWrap::Unwrap<GitOid>(info[1]->ToObject())->GetValue();
  }
// end convert_from_v8 block
  baton->id = from_id;
  baton->idNeedsFree = info[1]->IsString();
// start convert_from_v8 block
  size_t from_len;
  from_len = (size_t)   info[2]->ToNumber()->Value();
// end convert_from_v8 block
  baton->len = from_len;

  Nan::Callback *callback = new Nan::Callback(v8::Local<Function>::Cast(info[3]));
  LookupPrefixWorker *worker = new LookupPrefixWorker(baton, callback);
  if (!info[0]->IsUndefined() && !info[0]->IsNull())
    worker->SaveToPersistent("repo", info[0]->ToObject());
  if (!info[1]->IsUndefined() && !info[1]->IsNull())
    worker->SaveToPersistent("id", info[1]->ToObject());
  if (!info[2]->IsUndefined() && !info[2]->IsNull())
    worker->SaveToPersistent("len", info[2]->ToObject());

  AsyncLibgit2QueueWorker(worker);
  return;
}

void GitTree::LookupPrefixWorker::Execute()
{
  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */true,baton->repo
                                           ,baton->id
                         );

    int result = git_tree_lookup_prefix(
                   &baton->out,baton->repo,baton->id,baton->len    );

    baton->error_code = result;

    if (result != GIT_OK && giterr_last() != NULL) {
      baton->error = git_error_dup(giterr_last());
    }

  }
}

void GitTree::LookupPrefixWorker::HandleOKCallback()
{
  if (baton->error_code == GIT_OK) {
    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (baton->out != NULL) {
      // GitTree baton->out
      to = GitTree::New(baton->out, true  );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    v8::Local<v8::Value> result = to;
    v8::Local<v8::Value> argv[2] = {
      Nan::Null(),
      result
    };
    callback->Call(2, argv);
  } else {
    if (baton->error) {
      v8::Local<v8::Object> err;
      if (baton->error->message) {
        err = Nan::Error(baton->error->message)->ToObject();
      } else {
        err = Nan::Error("Method lookupPrefix has thrown an error.")->ToObject();
      }
      err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
      v8::Local<v8::Value> argv[1] = {
        err
      };
      callback->Call(1, argv);
      if (baton->error->message)
        free((void *)baton->error->message);
      free((void *)baton->error);
    } else if (baton->error_code < 0) {
      std::queue< v8::Local<v8::Value> > workerArguments;
      workerArguments.push(GetFromPersistent("repo"));
      workerArguments.push(GetFromPersistent("id"));
      workerArguments.push(GetFromPersistent("len"));
      bool callbackFired = false;
      while(!workerArguments.empty()) {
        v8::Local<v8::Value> node = workerArguments.front();
        workerArguments.pop();

        if (
          !node->IsObject()
          || node->IsArray()
          || node->IsBooleanObject()
          || node->IsDate()
          || node->IsFunction()
          || node->IsNumberObject()
          || node->IsRegExp()
          || node->IsStringObject()
        ) {
          continue;
        }

        v8::Local<v8::Object> nodeObj = node->ToObject();
        v8::Local<v8::Value> checkValue = GetPrivate(nodeObj, Nan::New("NodeGitPromiseError").ToLocalChecked());

        if (!checkValue.IsEmpty() && !checkValue->IsNull() && !checkValue->IsUndefined()) {
          v8::Local<v8::Value> argv[1] = {
            checkValue->ToObject()
          };
          callback->Call(1, argv);
          callbackFired = true;
          break;
        }

        v8::Local<v8::Array> properties = nodeObj->GetPropertyNames();
        for (unsigned int propIndex = 0; propIndex < properties->Length(); ++propIndex) {
          v8::Local<v8::String> propName = properties->Get(propIndex)->ToString();
          v8::Local<v8::Value> nodeToQueue = nodeObj->Get(propName);
          if (!nodeToQueue->IsUndefined()) {
            workerArguments.push(nodeToQueue);
          }
        }
      }

      if (!callbackFired) {
        v8::Local<v8::Object> err = Nan::Error("Method lookupPrefix has thrown an error.")->ToObject();
        err->Set(Nan::New("errno").ToLocalChecked(), Nan::New(baton->error_code));
        v8::Local<v8::Value> argv[1] = {
          err
        };
        callback->Call(1, argv);
      }
    } else {
      callback->Call(0, NULL);
    }

  }

  if (baton->idNeedsFree) {
    baton->idNeedsFree = false;
    free((void *)baton->id);
  }

  delete baton;
}


/*
     * @return Repository  result    */
NAN_METHOD(GitTree::Owner)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false,    Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                         );

    git_repository * result = git_tree_owner(
                                Nan::ObjectWrap::Unwrap<GitTree>(info.This())->GetValue()
                              );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    v8::Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // GitRepository result
      to = GitRepository::New(result, false  );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}
// force base class template instantiation, to make sure we get all the
// methods, statics, etc.
template class NodeGitWrapper<GitTreeTraits>;
