/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.tasks;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.tasks.ITaskCanceller;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.core.tasks.TaskOperationException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class TaskJob
extends Job
implements ITaskCanceller {
    private String userRunningTask;
    private boolean keep;
    private String finalMessage = "Done";
    private TaskInfo task;
    private IStatus realResult;
    private Long taskExpirationTime = null;
    private static int ActiveInstanceCount = 0;

    public TaskJob(String userRunningTask, boolean keep) {
        super("Long running task job");
        this.userRunningTask = userRunningTask;
        this.keep = keep;
    }

    public static int GetActiveCount() {
        return ActiveInstanceCount;
    }

    protected void setFinalMessage(String message) {
        this.finalMessage = message;
    }

    protected void setTaskExpirationTime(Long taskExpirationTime) {
        this.taskExpirationTime = taskExpirationTime;
    }

    public JSONObject getFinalResult() throws JSONException {
        JSONObject finalResult = new JSONObject();
        finalResult.put("Message", (Object)this.finalMessage);
        return finalResult;
    }

    public IStatus getRealResult() {
        return this.realResult;
    }

    private ITaskService getTaskService() {
        return Activator.getDefault().getTaskService();
    }

    private synchronized void cleanUp() {
        if (this.task != null && this.task.isRunning()) {
            this.setTaskResult((IStatus)(this.getRealResult() == null ? new Status(4, "org.eclipse.orion.server.core", "Task finished with unknown status.") : this.getRealResult()));
        }
    }

    public synchronized TaskInfo startTask() {
        this.task = this.getTaskService().createTask(this.userRunningTask, this.keep, this);
        if (this.getRealResult() != null) {
            this.setTaskResult(this.getRealResult());
        }
        return this.task;
    }

    public synchronized void removeTask() {
        if (this.task != null) {
            try {
                this.getTaskService().removeTask(this.task.getUserId(), this.task.getId(), this.task.isKeep());
            }
            catch (TaskOperationException e) {
                LogHelper.log(e);
            }
        }
    }

    public synchronized void setTaskLoaded(int loaded) {
        if (this.task == null) {
            return;
        }
        this.task.setLoaded(loaded);
        this.getTaskService().updateTask(this.task);
    }

    public synchronized void setTaskTotal(int total) {
        if (this.task == null) {
            return;
        }
        this.task.setTotal(total);
        this.getTaskService().updateTask(this.task);
    }

    public synchronized void setTaskMessage(String msg) {
        if (this.task == null) {
            return;
        }
        this.task.setMessage(msg);
        this.getTaskService().updateTask(this.task);
    }

    @Deprecated
    protected IStatus performJob() {
        return Status.CANCEL_STATUS;
    }

    protected IStatus performJob(IProgressMonitor monitor) {
        return this.performJob();
    }

    private synchronized void setTaskResult(IStatus result) {
        if (!this.task.isRunning()) {
            return;
        }
        this.realResult = result;
        this.task.done(this.getRealResult());
        if (this.taskExpirationTime != null) {
            this.task.setExpires(new Date().getTime() + this.taskExpirationTime);
        }
        this.getTaskService().updateTask(this.task);
    }

    protected IStatus run(IProgressMonitor progressMonitor) {
        ++ActiveInstanceCount;
        try {
            this.realResult = this.performJob(progressMonitor);
            if (this.task == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            this.setTaskResult(this.realResult);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            --ActiveInstanceCount;
            this.cleanUp();
        }
    }

    @Override
    public boolean cancelTask() {
        this.cancel();
        return true;
    }

    protected void canceling() {
        super.canceling();
        if (this.task != null && this.task.isRunning()) {
            this.task.done((IStatus)new Status(8, "org.eclipse.orion.server.core", "Task was canceled."));
            if (this.taskExpirationTime != null) {
                this.task.setExpires(new Date().getTime() + this.taskExpirationTime);
            }
            this.getTaskService().updateTask(this.task);
        }
        this.cleanUp();
    }
}

