/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.objects;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.orion.server.cf.objects.CFObject;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Domain")
public class Domain
extends CFObject {
    public static final String RESOURCE = "domains";
    public static final String TYPE = "Domain";
    protected static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private JSONObject domainJSON;

    public Domain() {
        Property[] defaultProperties = new Property[]{new Property("Guid"), new Property("Host"), new Property("DomainName")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
    }

    public Domain setCFJSON(JSONObject domainJSON) {
        this.domainJSON = domainJSON;
        return this;
    }

    public JSONObject getCFJSON() {
        return this.domainJSON;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return null;
    }

    @PropertyDescription(name="Host")
    public String getHost() {
        try {
            return this.domainJSON.getJSONObject("entity").getString("host");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @PropertyDescription(name="DomainName")
    public String getDomainName() {
        try {
            return this.domainJSON.getJSONObject("entity").getString("name");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @PropertyDescription(name="Guid")
    public String getGuid() {
        try {
            return this.domainJSON.getJSONObject("metadata").getString("guid");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }
}

