/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.common.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;

public abstract class AbstractValidator<T extends HttpServletRequest>
implements OAuthValidator<T> {
    protected List<String> requiredParams = new ArrayList<String>();
    protected Map<String, String[]> optionalParams = new HashMap<String, String[]>();
    protected List<String> notAllowedParams = new ArrayList<String>();
    protected boolean enforceClientAuthentication;

    @Override
    public void validateMethod(T request) throws OAuthProblemException {
        if (!request.getMethod().equals("POST")) {
            throw OAuthUtils.handleOAuthProblemException("Method not set to POST.");
        }
    }

    @Override
    public void validateContentType(T request) throws OAuthProblemException {
        String contentType = request.getContentType();
        if (!OAuthUtils.hasContentType(contentType, "application/x-www-form-urlencoded")) {
            throw OAuthUtils.handleBadContentTypeException("application/x-www-form-urlencoded");
        }
    }

    @Override
    public void validateRequiredParameters(T request) throws OAuthProblemException {
        HashSet<String> missingParameters = new HashSet<String>();
        for (String requiredParam : this.requiredParams) {
            String val = request.getParameter(requiredParam);
            if (!OAuthUtils.isEmpty(val)) continue;
            missingParameters.add(requiredParam);
        }
        if (!missingParameters.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(missingParameters);
        }
    }

    @Override
    public void validateOptionalParameters(T request) throws OAuthProblemException {
        HashSet<String> missingParameters = new HashSet<String>();
        for (Map.Entry<String, String[]> requiredParam : this.optionalParams.entrySet()) {
            String[] dependentParams;
            String paramName = requiredParam.getKey();
            String val = request.getParameter(paramName);
            if (OAuthUtils.isEmpty(val) || OAuthUtils.hasEmptyValues(dependentParams = requiredParam.getValue())) continue;
            String[] stringArray = dependentParams;
            int n = dependentParams.length;
            int n2 = 0;
            while (n2 < n) {
                String dependentParam = stringArray[n2];
                val = request.getParameter(dependentParam);
                if (OAuthUtils.isEmpty(val)) {
                    missingParameters.add(dependentParam);
                }
                ++n2;
            }
        }
        if (!missingParameters.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(missingParameters);
        }
    }

    @Override
    public void validateNotAllowedParameters(T request) throws OAuthProblemException {
        ArrayList<String> notAllowedParameters = new ArrayList<String>();
        for (String requiredParam : this.notAllowedParams) {
            String val = request.getParameter(requiredParam);
            if (OAuthUtils.isEmpty(val)) continue;
            notAllowedParameters.add(requiredParam);
        }
        if (!notAllowedParameters.isEmpty()) {
            throw OAuthUtils.handleNotAllowedParametersOAuthException(notAllowedParameters);
        }
    }

    @Override
    public void validateClientAuthenticationCredentials(T request) throws OAuthProblemException {
        if (this.enforceClientAuthentication) {
            HashSet<String> missingParameters = new HashSet<String>();
            String clientAuthHeader = request.getHeader("Authorization");
            String[] clientCreds = OAuthUtils.decodeClientAuthenticationHeader(clientAuthHeader);
            if (clientCreds == null || OAuthUtils.isEmpty(clientCreds[0]) || OAuthUtils.isEmpty(clientCreds[1])) {
                if (OAuthUtils.isEmpty(request.getParameter("client_id"))) {
                    missingParameters.add("client_id");
                }
                if (OAuthUtils.isEmpty(request.getParameter("client_secret"))) {
                    missingParameters.add("client_secret");
                }
            }
            if (!missingParameters.isEmpty()) {
                throw OAuthUtils.handleMissingParameters(missingParameters);
            }
        }
    }

    @Override
    public void performAllValidations(T request) throws OAuthProblemException {
        this.validateContentType(request);
        this.validateMethod(request);
        this.validateRequiredParameters(request);
        this.validateOptionalParameters(request);
        this.validateNotAllowedParameters(request);
        this.validateClientAuthenticationCredentials(request);
    }
}

