/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetDomainsCommand;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckRouteCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Check Route";
    private String domainName;
    private String hostName;
    private List<Route> routes;

    public CheckRouteCommand(Target target, String domainName, String hostName) {
        super(target);
        this.domainName = domainName;
        this.hostName = hostName;
    }

    public List<Route> getRoute() {
        this.assertWasRun();
        return this.routes;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            GetDomainsCommand getDomainsCommand = new GetDomainsCommand(this.target, this.domainName);
            ServerStatus getDomainsStatus = (ServerStatus)getDomainsCommand.doIt();
            if (!getDomainsStatus.isOK()) {
                return getDomainsStatus;
            }
            String domainId = getDomainsCommand.getDomains().get(0).getGuid();
            URI routesURI = targetURI.resolve("/v2/routes/reserved/domain/" + domainId + "/host/" + this.hostName);
            GetMethod getRouteMethod = new GetMethod(routesURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getRouteMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ServerStatus getRouteStatus = HttpUtil.executeMethod((HttpMethodBase)getRouteMethod);
            if (!getRouteStatus.isOK()) {
                if (getRouteStatus.getHttpCode() == 404 && getRouteStatus.getJsonData().getString("error_code").equals("CF-NotFound")) {
                    return new ServerStatus(Status.OK_STATUS, 200, null);
                }
                return getRouteStatus;
            }
            JSONObject result = new JSONObject();
            if (getRouteStatus.getMessage().equals("OK")) {
                result.append("Route", (Object)getRouteStatus.toJSON());
            }
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

