/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.UserInfo;

public class UserEmailUtil {
    private static UserEmailUtil util = null;
    private static final String PATH_EMAIL_CONFIRMATION = "useremailconfirmation";
    private static final String CONTENTTYPE_HTML_UTF8 = "text/html; charset=UTF-8";
    private static final String EMAIL_CONFIRMATION_FILE = "/emails/EmailConfirmation.txt";
    private static final String EMAIL_CONFIRMATION_RESET_PASS_FILE = "/emails/EmailConfirmationPasswordReset.txt";
    private static final String EMAIL_INACTIVEWORKSPACE_NOTIFICATION_FILE = "/emails/InactiveWorkspaceNotification.txt";
    private static final String EMAIL_INACTIVEWORKSPACE_FINALWARNING_FILE = "/emails/InactiveWorkspaceFinalWarning.txt";
    private static final String EMAIL_PASSWORD_RESET = "/emails/PasswordReset.txt";
    private static final String EMAIL_LAST_DATE_LINK = "<LASTDATE>";
    private static final String EMAIL_DELETION_DATE_LINK = "<DELETIONDATE>";
    private static final String EMAIL_URL_LINK = "<URL>";
    private static final String EMAIL_USER_LINK = "<USER>";
    private static final String EMAIL_PASSWORD_LINK = "<PASSWORD>";
    private static final String EMAIL_ADDRESS_LINK = "<EMAIL>";
    private static final String REMINDER = "** Reminder: ";
    private static final Pattern FromPattern = Pattern.compile("^([^<]*)<([^>]*)>\\s*$");
    private String customInactiveWorkspaceFinalWarningContent;
    private String customInactiveWorkspaceNotificationContent;
    private Properties properties = System.getProperties();
    private EmailContent confirmationEmail;
    private EmailContent confirmationResetPassEmail;
    private EmailContent inactiveWorkspaceNotificationEmail;
    private EmailContent inactiveWorkspaceFinalWarningEmail;
    private EmailContent passwordResetEmail;

    public UserEmailUtil() {
        this.properties.put("mail.smtp.starttls.enable", PreferenceHelper.getString("mail.smtp.starttls.enable", "true"));
        if (PreferenceHelper.getString("mail.smtp.host", null) != null) {
            this.properties.put("mail.smtp.host", PreferenceHelper.getString("mail.smtp.host", null));
        }
        if (PreferenceHelper.getString("mail.smtp.port", null) != null) {
            this.properties.put("mail.smtp.port", PreferenceHelper.getString("mail.smtp.port", null));
        }
        if (PreferenceHelper.getString("mail.smtp.user", null) != null) {
            this.properties.put("mail.smtp.user", PreferenceHelper.getString("mail.smtp.user", null));
        }
        if (PreferenceHelper.getString("mail.smtp.password", null) != null) {
            this.properties.put("mail.smtp.password", PreferenceHelper.getString("mail.smtp.password", null));
        }
        this.properties.put("mail.smtp.auth", PreferenceHelper.getString("mail.smtp.auth", "false"));
        this.properties.put("mail.debug", PreferenceHelper.getString("mail.debug", "false"));
    }

    public static UserEmailUtil getUtil() {
        if (util == null) {
            util = new UserEmailUtil();
        }
        return util;
    }

    public boolean isEmailConfigured() {
        return PreferenceHelper.getString("mail.smtp.host", null) != null;
    }

    public void sendEmail(String subject, String messageText, String emailAddress) throws URISyntaxException, IOException, CoreException {
        this.sendEmail(subject, messageText, emailAddress, false);
    }

    public void sendEmail(String subject, String messageText, String emailAddress, boolean isMultipart) throws URISyntaxException, IOException, CoreException {
        Session session = Session.getInstance((Properties)this.properties, null);
        try {
            String fromPreference = PreferenceHelper.getString("mail.from", "OrionAdmin");
            Matcher matcher = FromPattern.matcher(fromPreference);
            InternetAddress from = matcher.find() ? new InternetAddress(matcher.group(2).trim(), matcher.group(1).trim()) : new InternetAddress(fromPreference);
            InternetAddress to = new InternetAddress(emailAddress);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)from);
            message.addRecipient(Message.RecipientType.TO, (Address)to);
            message.setSubject(subject);
            if (isMultipart) {
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setContent((Object)messageText, CONTENTTYPE_HTML_UTF8);
                MimeMultipart mmp = new MimeMultipart();
                mmp.addBodyPart((BodyPart)mbp);
                message.setContent((Multipart)mmp);
            } else {
                message.setText(messageText);
            }
            Transport transport = session.getTransport("smtp");
            transport.connect(this.properties.getProperty("mail.smtp.host", null), this.properties.getProperty("mail.smtp.user", null), this.properties.getProperty("mail.smtp.password", null));
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (AddressException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", e.getMessage(), (Throwable)e));
        }
        catch (MessagingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", e.getMessage(), (Throwable)e));
        }
    }

    public void sendEmailConfirmation(HttpServletRequest req, UserInfo userInfo) throws URISyntaxException, IOException, CoreException {
        URL confirmLocation = new URL(req.getScheme(), req.getServerName(), req.getServerPort(), "/useremailconfirmation");
        if (this.confirmationEmail == null) {
            this.confirmationEmail = new EmailContent(EMAIL_CONFIRMATION_FILE);
        }
        String confirmURL = confirmLocation.toString();
        confirmURL = String.valueOf(confirmURL) + "/" + userInfo.getUniqueId();
        confirmURL = String.valueOf(confirmURL) + "?EmailConfirmationId=" + userInfo.getProperty("EmailConfirmationId");
        this.sendEmail(this.confirmationEmail.getTitle(), this.confirmationEmail.getContent().replaceAll(EMAIL_USER_LINK, userInfo.getUniqueId()).replaceAll(EMAIL_URL_LINK, confirmURL).replaceAll(EMAIL_ADDRESS_LINK, userInfo.getProperty("Email")), userInfo.getProperty("Email"));
    }

    public void sendInactiveWorkspaceNotification(UserInfo userInfo, String lastDate, String deletionDate, String installUrl, boolean isReminder, String emailAddress) throws URISyntaxException, IOException, CoreException {
        if (this.inactiveWorkspaceNotificationEmail == null) {
            this.inactiveWorkspaceNotificationEmail = this.customInactiveWorkspaceNotificationContent == null ? new EmailContent(EMAIL_INACTIVEWORKSPACE_NOTIFICATION_FILE) : new EmailContent().init(new BufferedReader(new StringReader(this.customInactiveWorkspaceNotificationContent)));
        }
        this.sendEmail(String.valueOf(isReminder ? REMINDER : "") + this.inactiveWorkspaceNotificationEmail.getTitle(), this.inactiveWorkspaceNotificationEmail.getContent().replaceAll(EMAIL_LAST_DATE_LINK, lastDate).replaceAll(EMAIL_DELETION_DATE_LINK, deletionDate).replaceAll(EMAIL_URL_LINK, installUrl), emailAddress != null ? emailAddress : userInfo.getProperty("Email"), true);
    }

    public void sendInactiveWorkspaceFinalWarning(UserInfo userInfo, String deletionDate, String installUrl, String emailAddress) throws URISyntaxException, IOException, CoreException {
        if (this.inactiveWorkspaceFinalWarningEmail == null) {
            this.inactiveWorkspaceFinalWarningEmail = this.customInactiveWorkspaceFinalWarningContent == null ? new EmailContent(EMAIL_INACTIVEWORKSPACE_FINALWARNING_FILE) : new EmailContent().init(new BufferedReader(new StringReader(this.customInactiveWorkspaceFinalWarningContent)));
        }
        this.sendEmail(this.inactiveWorkspaceFinalWarningEmail.getTitle(), this.inactiveWorkspaceFinalWarningEmail.getContent().replaceAll(EMAIL_DELETION_DATE_LINK, deletionDate).replaceAll(EMAIL_URL_LINK, installUrl), emailAddress != null ? emailAddress : userInfo.getProperty("Email"), true);
    }

    public void sendResetPasswordConfirmation(URI baseURI, UserInfo userInfo) throws URISyntaxException, IOException, CoreException {
        if (this.confirmationResetPassEmail == null) {
            this.confirmationResetPassEmail = new EmailContent(EMAIL_CONFIRMATION_RESET_PASS_FILE);
        }
        String confirmURL = baseURI.toURL().toString();
        confirmURL = String.valueOf(confirmURL) + "/" + userInfo.getUniqueId();
        confirmURL = String.valueOf(confirmURL) + "?PasswordResetId=" + userInfo.getProperty("PasswordResetId");
        this.sendEmail(this.confirmationResetPassEmail.getTitle(), this.confirmationResetPassEmail.getContent().replaceAll(EMAIL_URL_LINK, confirmURL).replaceAll(EMAIL_USER_LINK, userInfo.getUniqueId()), userInfo.getProperty("Email"));
    }

    public void sendPasswordResetEmail(UserInfo userInfo) throws URISyntaxException, IOException, CoreException {
        if (this.passwordResetEmail == null) {
            this.passwordResetEmail = new EmailContent(EMAIL_PASSWORD_RESET);
        }
        this.sendEmail(this.passwordResetEmail.getTitle(), this.passwordResetEmail.getContent().replaceAll(EMAIL_USER_LINK, userInfo.getUniqueId()).replaceAll(EMAIL_PASSWORD_LINK, userInfo.getProperty("Password")), userInfo.getProperty("Email"));
    }

    public void setInactivateWorkspaceFinalWarningContent(String value) {
        this.customInactiveWorkspaceFinalWarningContent = value;
    }

    public void setInactivateWorkspaceNotificationContent(String value) {
        this.customInactiveWorkspaceNotificationContent = value;
    }

    private class EmailContent {
        private String title;
        private String content;

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public EmailContent() {
        }

        public EmailContent(String fileName) throws URISyntaxException, IOException {
            URL entry = Activator.getDefault().getContext().getBundle().getEntry(fileName);
            if (entry == null) {
                throw new IOException("File not found: " + fileName);
            }
            this.init(new BufferedReader(new InputStreamReader(entry.openStream())));
        }

        public EmailContent init(BufferedReader reader) throws IOException {
            String line = null;
            try {
                this.title = reader.readLine();
                StringBuilder stringBuilder = new StringBuilder();
                String ls = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                }
                this.content = stringBuilder.toString();
            }
            finally {
                reader.close();
            }
            return this;
        }
    }
}

