/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.servlets;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.File;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.LogUtils;
import org.eclipse.orion.server.logs.jobs.ListRollingFileAppendersJob;
import org.eclipse.orion.server.logs.jobs.RollingFileAppenderJob;
import org.eclipse.orion.server.logs.servlets.AbstractLogHandler;
import org.eclipse.orion.server.logs.servlets.ArchivedLogFileHandler;
import org.eclipse.osgi.util.NLS;

public class RollingFileAppenderHandler
extends AbstractLogHandler {
    private final ServletResourceHandler<IPath> archivedLogFileHandler;

    public RollingFileAppenderHandler(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
        this.archivedLogFileHandler = new ArchivedLogFileHandler(statusHandler);
    }

    private boolean downloadLog(HttpServletRequest request, HttpServletResponse response, ILogService logService, String appenderName) throws ServletException {
        RollingFileAppender<ILoggingEvent> appender = logService.getRollingFileAppender(appenderName);
        if (appender == null) {
            String msg = NLS.bind((String)"Appender not found: {0}", (Object)appenderName);
            ServerStatus error = new ServerStatus(4, 404, msg, null);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
        File logFile = new File(appender.getFile());
        try {
            LogUtils.provideLogFile(logFile, response);
        }
        catch (Exception ex) {
            String msg = NLS.bind((String)"An error occured when looking for log {0}.", (Object)logFile.getName());
            ServerStatus error = new ServerStatus(4, 500, msg, (Throwable)ex);
            LogHelper.log((IStatus)error);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
        return true;
    }

    @Override
    protected boolean handleGet(HttpServletRequest request, HttpServletResponse response, ILogService logService) throws ServletException {
        try {
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)new ListRollingFileAppendersJob(TaskJobHandler.getUserId((HttpServletRequest)request), logService, RollingFileAppenderHandler.getURI((HttpServletRequest)request)), (ServletResourceHandler)this.statusHandler);
        }
        catch (Exception e) {
            ServerStatus error = new ServerStatus(4, 500, "An error occured when looking for rolling file appenders.", (Throwable)e);
            LogHelper.log((IStatus)error);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
    }

    @Override
    protected boolean handleGet(HttpServletRequest request, HttpServletResponse response, ILogService logService, IPath path) throws ServletException {
        boolean metadata;
        String appenderName = path.segment(0);
        String logFileName = path.segment(1);
        if (logFileName != null) {
            return this.archivedLogFileHandler.handleRequest(request, response, (Object)path);
        }
        String parts = request.getParameter("parts");
        boolean bl = metadata = parts != null && "meta".equals(parts);
        if (!metadata) {
            return this.downloadLog(request, response, logService, appenderName);
        }
        try {
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)new RollingFileAppenderJob(TaskJobHandler.getUserId((HttpServletRequest)request), logService, RollingFileAppenderHandler.getURI((HttpServletRequest)request), appenderName), (ServletResourceHandler)this.statusHandler);
        }
        catch (Exception e) {
            ServerStatus error = new ServerStatus(4, 500, "An error occured when looking for rolling appenders.", (Throwable)e);
            LogHelper.log((IStatus)error);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
    }
}

