/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.SubmoduleInitCommand;
import org.eclipse.jgit.api.SubmoduleStatusCommand;
import org.eclipse.jgit.api.SubmoduleSyncCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class GitSubmoduleHandlerV1
extends AbstractGitHandler {
    GitSubmoduleHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected boolean handlePost(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        block12: {
            block10: {
                String name;
                String gitUrl;
                String targetPath;
                Repository db;
                block11: {
                    JSONObject toAdd = requestInfo.getJSONRequest();
                    HttpServletRequest request = requestInfo.request;
                    HttpServletResponse response = requestInfo.response;
                    db = requestInfo.db;
                    try {
                        Path filePath;
                        targetPath = null;
                        gitUrl = toAdd.optString("GitUrl", null);
                        name = toAdd.optString("Name", null);
                        if (gitUrl == null) break block10;
                        String workspacePath = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)toAdd.optString("Location", null));
                        String filePathString = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)toAdd.optString("Path", null));
                        Path path = filePath = filePathString == null ? null : new Path(filePathString);
                        if (filePath != null && filePath.segmentCount() < 3) {
                            filePath = null;
                        }
                        if (filePath == null && workspacePath == null) {
                            String msg = NLS.bind((String)"Either {0} or {1} should be provided: {2}", (Object[])new Object[]{"Path", "Location", toAdd});
                            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                        }
                        ProjectInfo project = null;
                        if (filePath != null) {
                            project = GitUtils.projectFromPath((IPath)filePath);
                            if (project == null) {
                                String msg = NLS.bind((String)"Specified project does not exist: {0}", (Object)filePath.segment(2));
                                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                            }
                            if (name == null) {
                                name = project.getContentLocation().relativize(project.getProjectStore().getFileStore(filePath.removeFirstSegments(3)).toURI()).toString();
                            }
                            break block11;
                        }
                        if (workspacePath != null) {
                            if (name == null) {
                                Path path2 = new Path(workspacePath);
                                IMetaStore metaStore = OrionConfiguration.getMetaStore();
                                WorkspaceInfo workspace = metaStore.readWorkspace(path2.segment(1));
                                name = new URIish(gitUrl).getHumanishName();
                                name = GitUtils.getUniqueProjectName(workspace, name);
                            }
                            break block11;
                        }
                        return false;
                    }
                    catch (Exception ex) {
                        String msg = "An error occured for add submodule command.";
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)ex));
                    }
                }
                targetPath = targetPath == null ? name : targetPath;
                GitSubmoduleHandlerV1.addSubmodules(db, gitUrl, targetPath);
                break block12;
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean handlePut(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String operation;
        Repository db;
        block5: {
            JSONObject requestPayload = requestInfo.getJSONRequest();
            HttpServletRequest request = requestInfo.request;
            HttpServletResponse response = requestInfo.response;
            db = requestInfo.db;
            try {
                operation = requestPayload.optString("Operation", null);
                if (operation != null) break block5;
                return false;
            }
            catch (Exception ex) {
                String msg = "An error occured for update submodule command.";
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)ex));
            }
        }
        if (operation.equals("update")) {
            return GitSubmoduleHandlerV1.updateSubmodules(db);
        }
        if (operation.equals("sync")) {
            return GitSubmoduleHandlerV1.syncSubmodules(db);
        }
        return false;
    }

    @Override
    protected boolean handleDelete(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        Repository parentRepo = null;
        try {
            Map<IPath, File> parents = GitUtils.getGitDirs(requestInfo.filePath.removeLastSegments(1), GitUtils.Traverse.GO_UP);
            if (parents.size() < 1) {
                return false;
            }
            parentRepo = FileRepositoryBuilder.create((File)parents.entrySet().iterator().next().getValue());
            String pathToSubmodule = db.getWorkTree().toString().substring(parentRepo.getWorkTree().toString().length() + 1);
            GitSubmoduleHandlerV1.removeSubmodule(db, parentRepo, pathToSubmodule);
            return true;
        }
        catch (Exception ex) {
            String msg = "An error occured for delete submodule command.";
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)ex));
            return bl;
        }
        finally {
            if (parentRepo != null) {
                parentRepo.close();
            }
        }
    }

    public static boolean updateSubmodules(Repository repo) throws GitAPIException {
        SubmoduleInitCommand init = new SubmoduleInitCommand(repo);
        init.call();
        SubmoduleUpdateCommand update = new SubmoduleUpdateCommand(repo);
        Collection updated = update.call();
        SubmoduleStatusCommand status = new SubmoduleStatusCommand(repo);
        Map statusResult = status.call();
        return updated.size() == statusResult.size();
    }

    public static boolean syncSubmodules(Repository repo) throws GitAPIException {
        SubmoduleSyncCommand sync = new SubmoduleSyncCommand(repo);
        Map synced = sync.call();
        SubmoduleStatusCommand status = new SubmoduleStatusCommand(repo);
        Map statusResult = status.call();
        return synced.size() == statusResult.size();
    }

    public static void addSubmodules(Repository repo, String targetUrl, String targetPath) throws GitAPIException {
        SubmoduleAddCommand addCommand = new SubmoduleAddCommand(repo);
        addCommand.setURI(targetUrl);
        addCommand.setPath(targetPath);
        Repository repository = addCommand.call();
        repository.close();
    }

    public static void removeSubmodule(Repository db, Repository parentRepo, String pathToSubmodule) throws Exception {
        pathToSubmodule = pathToSubmodule.replace("\\", "/");
        StoredConfig gitSubmodulesConfig = GitSubmoduleHandlerV1.getGitSubmodulesConfig(parentRepo);
        gitSubmodulesConfig.unsetSection("submodule", pathToSubmodule);
        gitSubmodulesConfig.save();
        StoredConfig repositoryConfig = parentRepo.getConfig();
        repositoryConfig.unsetSection("submodule", pathToSubmodule);
        repositoryConfig.save();
        Git git = Git.wrap((Repository)parentRepo);
        git.add().addFilepattern(".gitmodules").call();
        RmCommand rm = git.rm().addFilepattern(pathToSubmodule);
        if (gitSubmodulesConfig.getSections().size() == 0) {
            rm.addFilepattern(".gitmodules");
        }
        rm.call();
        FileUtils.delete((File)db.getWorkTree(), (int)1);
        FileUtils.delete((File)db.getDirectory(), (int)1);
    }

    private static StoredConfig getGitSubmodulesConfig(Repository repository) throws IOException, ConfigInvalidException {
        File gitSubmodulesFile = new File(repository.getWorkTree(), ".gitmodules");
        FileBasedConfig gitSubmodulesConfig = new FileBasedConfig(null, gitSubmodulesFile, FS.DETECTED);
        gitSubmodulesConfig.load();
        return gitSubmodulesConfig;
    }
}

